<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO_Prepaid_Amortization_Schedule_Outbound_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Prepaid Spend Amortization Schedule for Purchase Order
 * @subpackage Structs
 */
class PO_Prepaid_Amortization_Schedule_Outbound_DataType extends AbstractStructBase
{
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Frequency to be used when generating the next prepaid accounting entry.
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The Number_of_Prepayment_Installments
     * Meta information extracted from the WSDL
     * - documentation: The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Prepayment_Installments;
    /**
     * The Use_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Invoice Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Invoice_Date;
    /**
     * The Specified_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Specified Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Specified_Date;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Prepaid Purchase Order Lines in the Amortization Schedule
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType[]
     */
    public $Purchase_Order_Line_Reference;
    /**
     * Constructor method for PO_Prepaid_Amortization_Schedule_Outbound_DataType
     * @uses PO_Prepaid_Amortization_Schedule_Outbound_DataType::setFrequency_Reference()
     * @uses PO_Prepaid_Amortization_Schedule_Outbound_DataType::setNumber_of_Prepayment_Installments()
     * @uses PO_Prepaid_Amortization_Schedule_Outbound_DataType::setUse_Invoice_Date()
     * @uses PO_Prepaid_Amortization_Schedule_Outbound_DataType::setSpecified_Date()
     * @uses PO_Prepaid_Amortization_Schedule_Outbound_DataType::setPurchase_Order_Line_Reference()
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param float $number_of_Prepayment_Installments
     * @param bool $use_Invoice_Date
     * @param string $specified_Date
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     */
    public function __construct(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $number_of_Prepayment_Installments = null, $use_Invoice_Date = null, $specified_Date = null, array $purchase_Order_Line_Reference = array())
    {
        $this
            ->setFrequency_Reference($frequency_Reference)
            ->setNumber_of_Prepayment_Installments($number_of_Prepayment_Installments)
            ->setUse_Invoice_Date($use_Invoice_Date)
            ->setSpecified_Date($specified_Date)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference);
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Number_of_Prepayment_Installments value
     * @return float|null
     */
    public function getNumber_of_Prepayment_Installments()
    {
        return $this->Number_of_Prepayment_Installments;
    }
    /**
     * Set Number_of_Prepayment_Installments value
     * @param float $number_of_Prepayment_Installments
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function setNumber_of_Prepayment_Installments($number_of_Prepayment_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Prepayment_Installments) && !(is_float($number_of_Prepayment_Installments) || is_numeric($number_of_Prepayment_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Prepayment_Installments, true), gettype($number_of_Prepayment_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Prepayment_Installments) && mb_strlen(mb_substr($number_of_Prepayment_Installments, false !== mb_strpos($number_of_Prepayment_Installments, '.') ? mb_strpos($number_of_Prepayment_Installments, '.') + 1 : mb_strlen($number_of_Prepayment_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Prepayment_Installments, true), mb_strlen(mb_substr($number_of_Prepayment_Installments, mb_strpos($number_of_Prepayment_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Prepayment_Installments) && $number_of_Prepayment_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Prepayment_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Prepayment_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Prepayment_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Prepayment_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Prepayment_Installments))), __LINE__);
        }
        $this->Number_of_Prepayment_Installments = $number_of_Prepayment_Installments;
        return $this;
    }
    /**
     * Get Use_Invoice_Date value
     * @return bool|null
     */
    public function getUse_Invoice_Date()
    {
        return $this->Use_Invoice_Date;
    }
    /**
     * Set Use_Invoice_Date value
     * @param bool $use_Invoice_Date
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function setUse_Invoice_Date($use_Invoice_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Date) && !is_bool($use_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Date, true), gettype($use_Invoice_Date)), __LINE__);
        }
        $this->Use_Invoice_Date = $use_Invoice_Date;
        return $this;
    }
    /**
     * Get Specified_Date value
     * @return string|null
     */
    public function getSpecified_Date()
    {
        return $this->Specified_Date;
    }
    /**
     * Set Specified_Date value
     * @param string $specified_Date
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function setSpecified_Date($specified_Date = null)
    {
        // validation for constraint: string
        if (!is_null($specified_Date) && !is_string($specified_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specified_Date, true), gettype($specified_Date)), __LINE__);
        }
        $this->Specified_Date = $specified_Date;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType[]|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem instanceof \StructType\Purchase_Order_LineObjectType) {
                $invalidValues[] = is_object($pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem) ? get_class($pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem) : sprintf('%s(%s)', gettype($pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem), var_export($pO_Prepaid_Amortization_Schedule_Outbound_DataTypePurchase_Order_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function setPurchase_Order_Line_Reference(array $purchase_Order_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Line_ReferenceArrayErrorMessage = self::validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference($purchase_Order_Line_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType $item
     * @return \StructType\PO_Prepaid_Amortization_Schedule_Outbound_DataType
     */
    public function addToPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Line_Reference[] = $item;
        return $this;
    }
}
