<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Close_Status_InformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional information on the status of the closed purchase order (PO) line. Includes information such as the date the PO line was closed, who closed the line, and the reason it was closed. This field is read-only and ignored when
 * you submit.
 * @subpackage Structs
 */
class Close_Status_InformationType extends AbstractStructBase
{
    /**
     * The Closed_On
     * Meta information extracted from the WSDL
     * - documentation: The date and time the purchase order line was closed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Closed_On;
    /**
     * The Closed_By_Reference
     * Meta information extracted from the WSDL
     * - documentation: The user that closed the purchase order line.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Closed_By_Reference;
    /**
     * The Reason_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The close reason for the purchase order line.
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Reason_Code_Reference;
    /**
     * Constructor method for Close_Status_InformationType
     * @uses Close_Status_InformationType::setClosed_On()
     * @uses Close_Status_InformationType::setClosed_By_Reference()
     * @uses Close_Status_InformationType::setReason_Code_Reference()
     * @param string $closed_On
     * @param \StructType\WorkerObjectType $closed_By_Reference
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     */
    public function __construct($closed_On = null, \StructType\WorkerObjectType $closed_By_Reference = null, \StructType\Reason_CodeObjectType $reason_Code_Reference = null)
    {
        $this
            ->setClosed_On($closed_On)
            ->setClosed_By_Reference($closed_By_Reference)
            ->setReason_Code_Reference($reason_Code_Reference);
    }
    /**
     * Get Closed_On value
     * @return string|null
     */
    public function getClosed_On()
    {
        return $this->Closed_On;
    }
    /**
     * Set Closed_On value
     * @param string $closed_On
     * @return \StructType\Close_Status_InformationType
     */
    public function setClosed_On($closed_On = null)
    {
        // validation for constraint: string
        if (!is_null($closed_On) && !is_string($closed_On)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closed_On, true), gettype($closed_On)), __LINE__);
        }
        $this->Closed_On = $closed_On;
        return $this;
    }
    /**
     * Get Closed_By_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getClosed_By_Reference()
    {
        return $this->Closed_By_Reference;
    }
    /**
     * Set Closed_By_Reference value
     * @param \StructType\WorkerObjectType $closed_By_Reference
     * @return \StructType\Close_Status_InformationType
     */
    public function setClosed_By_Reference(\StructType\WorkerObjectType $closed_By_Reference = null)
    {
        $this->Closed_By_Reference = $closed_By_Reference;
        return $this;
    }
    /**
     * Get Reason_Code_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReason_Code_Reference()
    {
        return $this->Reason_Code_Reference;
    }
    /**
     * Set Reason_Code_Reference value
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     * @return \StructType\Close_Status_InformationType
     */
    public function setReason_Code_Reference(\StructType\Reason_CodeObjectType $reason_Code_Reference = null)
    {
        $this->Reason_Code_Reference = $reason_Code_Reference;
        return $this;
    }
}
