<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Supplier_Invoice_On_Hold_Status_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot change the On Hold status of a Supplier Invoice in a Draft or In Progress Netting Transaction | You cannot change the On Hold status of a Supplier Invoice with no amount due | You cannot change the On Hold status of a
 * Supplier Invoice in an In Progress Settlement Run | You cannot change the On Hold status of a Supplier Invoice in a Non-Processed Settlement Run | The supplier invoice instance on which the user wants to run On Hold web service.
 * @subpackage Structs
 */
class Change_Supplier_Invoice_On_Hold_Status_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Supplier Invoice
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The On_Hold_Data
     * @var \StructType\On_Hold_DataType
     */
    public $On_Hold_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Change_Supplier_Invoice_On_Hold_Status_RequestType
     * @uses Change_Supplier_Invoice_On_Hold_Status_RequestType::setSupplier_Invoice_Reference()
     * @uses Change_Supplier_Invoice_On_Hold_Status_RequestType::setOn_Hold_Data()
     * @uses Change_Supplier_Invoice_On_Hold_Status_RequestType::setVersion()
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference
     * @param \StructType\On_Hold_DataType $on_Hold_Data
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference = null, \StructType\On_Hold_DataType $on_Hold_Data = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setOn_Hold_Data($on_Hold_Data)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference
     * @return \StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get On_Hold_Data value
     * @return \StructType\On_Hold_DataType|null
     */
    public function getOn_Hold_Data()
    {
        return $this->On_Hold_Data;
    }
    /**
     * Set On_Hold_Data value
     * @param \StructType\On_Hold_DataType $on_Hold_Data
     * @return \StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType
     */
    public function setOn_Hold_Data(\StructType\On_Hold_DataType $on_Hold_Data = null)
    {
        $this->On_Hold_Data = $on_Hold_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
