<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bill_To_Address_ReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a reference instance or a Address Reference ID for an existing address
 * @subpackage Structs
 */
class Bill_To_Address_ReferenceType extends AbstractStructBase
{
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference ID
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceType[]
     */
    public $Address_Reference;
    /**
     * Constructor method for Bill_To_Address_ReferenceType
     * @uses Bill_To_Address_ReferenceType::setBill_To_Address_Reference()
     * @uses Bill_To_Address_ReferenceType::setAddress_Reference()
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param \StructType\Address_ReferenceType[] $address_Reference
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, array $address_Reference = array())
    {
        $this
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setAddress_Reference($address_Reference);
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->Bill_To_Address_Reference;
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\Bill_To_Address_ReferenceType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Address_Reference value
     * @return \StructType\Address_ReferenceType[]|null
     */
    public function getAddress_Reference()
    {
        return $this->Address_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bill_To_Address_ReferenceTypeAddress_ReferenceItem) {
            // validation for constraint: itemType
            if (!$bill_To_Address_ReferenceTypeAddress_ReferenceItem instanceof \StructType\Address_ReferenceType) {
                $invalidValues[] = is_object($bill_To_Address_ReferenceTypeAddress_ReferenceItem) ? get_class($bill_To_Address_ReferenceTypeAddress_ReferenceItem) : sprintf('%s(%s)', gettype($bill_To_Address_ReferenceTypeAddress_ReferenceItem), var_export($bill_To_Address_ReferenceTypeAddress_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType[] $address_Reference
     * @return \StructType\Bill_To_Address_ReferenceType
     */
    public function setAddress_Reference(array $address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($address_ReferenceArrayErrorMessage = self::validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference($address_Reference))) {
            throw new \InvalidArgumentException($address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Address_Reference = $address_Reference;
        return $this;
    }
    /**
     * Add item to Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType $item
     * @return \StructType\Bill_To_Address_ReferenceType
     */
    public function addToAddress_Reference(\StructType\Address_ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address_Reference[] = $item;
        return $this;
    }
}
