<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Connection_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains all Supplier Connections for the supplier
 * @subpackage Structs
 */
class Supplier_Connection_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_ID;
    /**
     * The Supplier_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_ID;
    /**
     * The Supplier_Connection_Line
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Connection_LineType[]
     */
    public $Supplier_Connection_Line;
    /**
     * Constructor method for Supplier_Connection_DataType
     * @uses Supplier_Connection_DataType::setSupplier_Reference_ID()
     * @uses Supplier_Connection_DataType::setSupplier_ID()
     * @uses Supplier_Connection_DataType::setSupplier_Connection_Line()
     * @param string $supplier_Reference_ID
     * @param string $supplier_ID
     * @param \StructType\Supplier_Connection_LineType[] $supplier_Connection_Line
     */
    public function __construct($supplier_Reference_ID = null, $supplier_ID = null, array $supplier_Connection_Line = array())
    {
        $this
            ->setSupplier_Reference_ID($supplier_Reference_ID)
            ->setSupplier_ID($supplier_ID)
            ->setSupplier_Connection_Line($supplier_Connection_Line);
    }
    /**
     * Get Supplier_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Reference_ID()
    {
        return $this->Supplier_Reference_ID;
    }
    /**
     * Set Supplier_Reference_ID value
     * @param string $supplier_Reference_ID
     * @return \StructType\Supplier_Connection_DataType
     */
    public function setSupplier_Reference_ID($supplier_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_ID) && !is_string($supplier_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_ID, true), gettype($supplier_Reference_ID)), __LINE__);
        }
        $this->Supplier_Reference_ID = $supplier_Reference_ID;
        return $this;
    }
    /**
     * Get Supplier_ID value
     * @return string|null
     */
    public function getSupplier_ID()
    {
        return $this->Supplier_ID;
    }
    /**
     * Set Supplier_ID value
     * @param string $supplier_ID
     * @return \StructType\Supplier_Connection_DataType
     */
    public function setSupplier_ID($supplier_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_ID) && !is_string($supplier_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_ID, true), gettype($supplier_ID)), __LINE__);
        }
        $this->Supplier_ID = $supplier_ID;
        return $this;
    }
    /**
     * Get Supplier_Connection_Line value
     * @return \StructType\Supplier_Connection_LineType[]|null
     */
    public function getSupplier_Connection_Line()
    {
        return $this->Supplier_Connection_Line;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Connection_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_Line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Connection_LineForArrayConstraintsFromSetSupplier_Connection_Line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Connection_DataTypeSupplier_Connection_LineItem) {
            // validation for constraint: itemType
            if (!$supplier_Connection_DataTypeSupplier_Connection_LineItem instanceof \StructType\Supplier_Connection_LineType) {
                $invalidValues[] = is_object($supplier_Connection_DataTypeSupplier_Connection_LineItem) ? get_class($supplier_Connection_DataTypeSupplier_Connection_LineItem) : sprintf('%s(%s)', gettype($supplier_Connection_DataTypeSupplier_Connection_LineItem), var_export($supplier_Connection_DataTypeSupplier_Connection_LineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Connection_Line property can only contain items of type \StructType\Supplier_Connection_LineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Connection_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Connection_LineType[] $supplier_Connection_Line
     * @return \StructType\Supplier_Connection_DataType
     */
    public function setSupplier_Connection_Line(array $supplier_Connection_Line = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Connection_LineArrayErrorMessage = self::validateSupplier_Connection_LineForArrayConstraintsFromSetSupplier_Connection_Line($supplier_Connection_Line))) {
            throw new \InvalidArgumentException($supplier_Connection_LineArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Connection_Line = $supplier_Connection_Line;
        return $this;
    }
    /**
     * Add item to Supplier_Connection_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Connection_LineType $item
     * @return \StructType\Supplier_Connection_DataType
     */
    public function addToSupplier_Connection_Line(\StructType\Supplier_Connection_LineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Connection_LineType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Connection_Line property can only contain items of type \StructType\Supplier_Connection_LineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Connection_Line[] = $item;
        return $this;
    }
}
