<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Remit_To_Supplier_Connection_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Connection Event Business Processing Options, Supplier Connection reference for update. Flag to indicate if this operation is add only, and Supplier Connection data items required to create a complete
 * Supplier Connection
 * @subpackage Structs
 */
class Submit_Remit_To_Supplier_Connection_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier for Supplier Connection
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Connection_Data
     * Meta information extracted from the WSDL
     * - documentation: This Element contains Supplier Connection attributes
     * - minOccurs: 0
     * @var \StructType\Supplier_Connection_DataType
     */
    public $Supplier_Connection_Data;
    /**
     * Constructor method for Submit_Remit_To_Supplier_Connection_RequestType
     * @uses Submit_Remit_To_Supplier_Connection_RequestType::setSupplier_Reference()
     * @uses Submit_Remit_To_Supplier_Connection_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Remit_To_Supplier_Connection_RequestType::setSupplier_Connection_Data()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Connection_DataType $supplier_Connection_Data
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Connection_DataType $supplier_Connection_Data = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Connection_Data($supplier_Connection_Data);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Submit_Remit_To_Supplier_Connection_RequestType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Remit_To_Supplier_Connection_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Connection_Data value
     * @return \StructType\Supplier_Connection_DataType|null
     */
    public function getSupplier_Connection_Data()
    {
        return $this->Supplier_Connection_Data;
    }
    /**
     * Set Supplier_Connection_Data value
     * @param \StructType\Supplier_Connection_DataType $supplier_Connection_Data
     * @return \StructType\Submit_Remit_To_Supplier_Connection_RequestType
     */
    public function setSupplier_Connection_Data(\StructType\Supplier_Connection_DataType $supplier_Connection_Data = null)
    {
        $this->Supplier_Connection_Data = $supplier_Connection_Data;
        return $this;
    }
}
