<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Project_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing Submit Project Response
 * @subpackage Structs
 */
class Submit_Project_ResponseType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project
     * - minOccurs: 0
     * @var \StructType\Project_AbstractObjectType
     */
    public $Project_Reference;
    /**
     * The Application_Instance_Related_Exceptions_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Application_Instance_Related_Exceptions_DataType[]
     */
    public $Application_Instance_Related_Exceptions_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Project_ResponseType
     * @uses Submit_Project_ResponseType::setProject_Reference()
     * @uses Submit_Project_ResponseType::setApplication_Instance_Related_Exceptions_Data()
     * @uses Submit_Project_ResponseType::setVersion()
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $application_Instance_Related_Exceptions_Data
     * @param string $version
     */
    public function __construct(\StructType\Project_AbstractObjectType $project_Reference = null, array $application_Instance_Related_Exceptions_Data = array(), $version = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setApplication_Instance_Related_Exceptions_Data($application_Instance_Related_Exceptions_Data)
            ->setVersion($version);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\Project_AbstractObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @return \StructType\Submit_Project_ResponseType
     */
    public function setProject_Reference(\StructType\Project_AbstractObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Application_Instance_Related_Exceptions_Data value
     * @return \StructType\Application_Instance_Related_Exceptions_DataType[]|null
     */
    public function getApplication_Instance_Related_Exceptions_Data()
    {
        return $this->Application_Instance_Related_Exceptions_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setApplication_Instance_Related_Exceptions_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplication_Instance_Related_Exceptions_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplication_Instance_Related_Exceptions_DataForArrayConstraintsFromSetApplication_Instance_Related_Exceptions_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
                $invalidValues[] = is_object($submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem) ? get_class($submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem) : sprintf('%s(%s)', gettype($submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem), var_export($submit_Project_ResponseTypeApplication_Instance_Related_Exceptions_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Application_Instance_Related_Exceptions_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Application_Instance_Related_Exceptions_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $application_Instance_Related_Exceptions_Data
     * @return \StructType\Submit_Project_ResponseType
     */
    public function setApplication_Instance_Related_Exceptions_Data(array $application_Instance_Related_Exceptions_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($application_Instance_Related_Exceptions_DataArrayErrorMessage = self::validateApplication_Instance_Related_Exceptions_DataForArrayConstraintsFromSetApplication_Instance_Related_Exceptions_Data($application_Instance_Related_Exceptions_Data))) {
            throw new \InvalidArgumentException($application_Instance_Related_Exceptions_DataArrayErrorMessage, __LINE__);
        }
        $this->Application_Instance_Related_Exceptions_Data = $application_Instance_Related_Exceptions_Data;
        return $this;
    }
    /**
     * Add item to Application_Instance_Related_Exceptions_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType $item
     * @return \StructType\Submit_Project_ResponseType
     */
    public function addToApplication_Instance_Related_Exceptions_Data(\StructType\Application_Instance_Related_Exceptions_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
            throw new \InvalidArgumentException(sprintf('The Application_Instance_Related_Exceptions_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Application_Instance_Related_Exceptions_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Project_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
