<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Pool_Hierarchy_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Pool Hierarchy Data Element used in Resource Pool Hierarchy Web Service Task.
 * @subpackage Structs
 */
class Resource_Pool_Hierarchy_DataType extends AbstractStructBase
{
    /**
     * The Resource_Pool_Hierarchy_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchy ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Pool_Hierarchy_ID;
    /**
     * The Resource_Pool_Hierarchy_Name
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchy Name is Required.
     * - maxOccurs: 1
     * @var string
     */
    public $Resource_Pool_Hierarchy_Name;
    /**
     * The Include_Resource_Pool_Hierarchy_ID_in_Name
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating if the Resource Pool Hierarchy ID will be included in the display of Resource Pool Hierarchy Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Resource_Pool_Hierarchy_ID_in_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates the resource pool hierarchy is inactive. A resource pool hierarchy may also be inactivated by a parent resource pool hierarchy as indicated by the 'Inactivated By Hierarchy Reference'. In which case, the current resource
     * pool hierarchy is considered Inactive even though this Boolean returns False. Changes to an inactive hierarchy are ignored. Reactivating a resource pool hierarchy can only be done on the hierarchy if it was explicitly marked 'Inactive' or by
     * reactivating the hierarchy that made the current hierarchy inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchy Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactivated_By_Reference
     * Meta information extracted from the WSDL
     * - documentation: This information is for outbound purposes only. Workday doesn't process this information for inbound Web Service requests.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_HierarchyObjectType[]
     */
    public $Inactivated_By_Reference;
    /**
     * The Parent_Reference
     * Meta information extracted from the WSDL
     * - documentation: Parent Resource Pool Hierarchy for the Resource Pool Hierarchy created from Put Resource Pool Hierarchy Web Service Task.
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_HierarchyObjectType
     */
    public $Parent_Reference;
    /**
     * The Included_Resource_Pools_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pools rolled up under Resource Pool Hierarchy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_PoolObjectType[]
     */
    public $Included_Resource_Pools_Reference;
    /**
     * Constructor method for Resource_Pool_Hierarchy_DataType
     * @uses Resource_Pool_Hierarchy_DataType::setResource_Pool_Hierarchy_ID()
     * @uses Resource_Pool_Hierarchy_DataType::setResource_Pool_Hierarchy_Name()
     * @uses Resource_Pool_Hierarchy_DataType::setInclude_Resource_Pool_Hierarchy_ID_in_Name()
     * @uses Resource_Pool_Hierarchy_DataType::setInactive()
     * @uses Resource_Pool_Hierarchy_DataType::setDescription()
     * @uses Resource_Pool_Hierarchy_DataType::setInactivated_By_Reference()
     * @uses Resource_Pool_Hierarchy_DataType::setParent_Reference()
     * @uses Resource_Pool_Hierarchy_DataType::setIncluded_Resource_Pools_Reference()
     * @param string $resource_Pool_Hierarchy_ID
     * @param string $resource_Pool_Hierarchy_Name
     * @param bool $include_Resource_Pool_Hierarchy_ID_in_Name
     * @param bool $inactive
     * @param string $description
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $inactivated_By_Reference
     * @param \StructType\Resource_Pool_HierarchyObjectType $parent_Reference
     * @param \StructType\Resource_PoolObjectType[] $included_Resource_Pools_Reference
     */
    public function __construct($resource_Pool_Hierarchy_ID = null, $resource_Pool_Hierarchy_Name = null, $include_Resource_Pool_Hierarchy_ID_in_Name = null, $inactive = null, $description = null, array $inactivated_By_Reference = array(), \StructType\Resource_Pool_HierarchyObjectType $parent_Reference = null, array $included_Resource_Pools_Reference = array())
    {
        $this
            ->setResource_Pool_Hierarchy_ID($resource_Pool_Hierarchy_ID)
            ->setResource_Pool_Hierarchy_Name($resource_Pool_Hierarchy_Name)
            ->setInclude_Resource_Pool_Hierarchy_ID_in_Name($include_Resource_Pool_Hierarchy_ID_in_Name)
            ->setInactive($inactive)
            ->setDescription($description)
            ->setInactivated_By_Reference($inactivated_By_Reference)
            ->setParent_Reference($parent_Reference)
            ->setIncluded_Resource_Pools_Reference($included_Resource_Pools_Reference);
    }
    /**
     * Get Resource_Pool_Hierarchy_ID value
     * @return string|null
     */
    public function getResource_Pool_Hierarchy_ID()
    {
        return $this->Resource_Pool_Hierarchy_ID;
    }
    /**
     * Set Resource_Pool_Hierarchy_ID value
     * @param string $resource_Pool_Hierarchy_ID
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setResource_Pool_Hierarchy_ID($resource_Pool_Hierarchy_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Pool_Hierarchy_ID) && !is_string($resource_Pool_Hierarchy_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Pool_Hierarchy_ID, true), gettype($resource_Pool_Hierarchy_ID)), __LINE__);
        }
        $this->Resource_Pool_Hierarchy_ID = $resource_Pool_Hierarchy_ID;
        return $this;
    }
    /**
     * Get Resource_Pool_Hierarchy_Name value
     * @return string|null
     */
    public function getResource_Pool_Hierarchy_Name()
    {
        return $this->Resource_Pool_Hierarchy_Name;
    }
    /**
     * Set Resource_Pool_Hierarchy_Name value
     * @param string $resource_Pool_Hierarchy_Name
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setResource_Pool_Hierarchy_Name($resource_Pool_Hierarchy_Name = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Pool_Hierarchy_Name) && !is_string($resource_Pool_Hierarchy_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Pool_Hierarchy_Name, true), gettype($resource_Pool_Hierarchy_Name)), __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Name = $resource_Pool_Hierarchy_Name;
        return $this;
    }
    /**
     * Get Include_Resource_Pool_Hierarchy_ID_in_Name value
     * @return bool|null
     */
    public function getInclude_Resource_Pool_Hierarchy_ID_in_Name()
    {
        return $this->Include_Resource_Pool_Hierarchy_ID_in_Name;
    }
    /**
     * Set Include_Resource_Pool_Hierarchy_ID_in_Name value
     * @param bool $include_Resource_Pool_Hierarchy_ID_in_Name
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setInclude_Resource_Pool_Hierarchy_ID_in_Name($include_Resource_Pool_Hierarchy_ID_in_Name = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Resource_Pool_Hierarchy_ID_in_Name) && !is_bool($include_Resource_Pool_Hierarchy_ID_in_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Resource_Pool_Hierarchy_ID_in_Name, true), gettype($include_Resource_Pool_Hierarchy_ID_in_Name)), __LINE__);
        }
        $this->Include_Resource_Pool_Hierarchy_ID_in_Name = $include_Resource_Pool_Hierarchy_ID_in_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactivated_By_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType[]|null
     */
    public function getInactivated_By_Reference()
    {
        return $this->Inactivated_By_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInactivated_By_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInactivated_By_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInactivated_By_ReferenceForArrayConstraintsFromSetInactivated_By_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem instanceof \StructType\Resource_Pool_HierarchyObjectType) {
                $invalidValues[] = is_object($resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem) ? get_class($resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem), var_export($resource_Pool_Hierarchy_DataTypeInactivated_By_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inactivated_By_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inactivated_By_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $inactivated_By_Reference
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setInactivated_By_Reference(array $inactivated_By_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($inactivated_By_ReferenceArrayErrorMessage = self::validateInactivated_By_ReferenceForArrayConstraintsFromSetInactivated_By_Reference($inactivated_By_Reference))) {
            throw new \InvalidArgumentException($inactivated_By_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Inactivated_By_Reference = $inactivated_By_Reference;
        return $this;
    }
    /**
     * Add item to Inactivated_By_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType $item
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function addToInactivated_By_Reference(\StructType\Resource_Pool_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Inactivated_By_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Inactivated_By_Reference[] = $item;
        return $this;
    }
    /**
     * Get Parent_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType|null
     */
    public function getParent_Reference()
    {
        return $this->Parent_Reference;
    }
    /**
     * Set Parent_Reference value
     * @param \StructType\Resource_Pool_HierarchyObjectType $parent_Reference
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setParent_Reference(\StructType\Resource_Pool_HierarchyObjectType $parent_Reference = null)
    {
        $this->Parent_Reference = $parent_Reference;
        return $this;
    }
    /**
     * Get Included_Resource_Pools_Reference value
     * @return \StructType\Resource_PoolObjectType[]|null
     */
    public function getIncluded_Resource_Pools_Reference()
    {
        return $this->Included_Resource_Pools_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIncluded_Resource_Pools_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncluded_Resource_Pools_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncluded_Resource_Pools_ReferenceForArrayConstraintsFromSetIncluded_Resource_Pools_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem instanceof \StructType\Resource_PoolObjectType) {
                $invalidValues[] = is_object($resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem) ? get_class($resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem), var_export($resource_Pool_Hierarchy_DataTypeIncluded_Resource_Pools_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Included_Resource_Pools_Reference property can only contain items of type \StructType\Resource_PoolObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Included_Resource_Pools_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_PoolObjectType[] $included_Resource_Pools_Reference
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function setIncluded_Resource_Pools_Reference(array $included_Resource_Pools_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($included_Resource_Pools_ReferenceArrayErrorMessage = self::validateIncluded_Resource_Pools_ReferenceForArrayConstraintsFromSetIncluded_Resource_Pools_Reference($included_Resource_Pools_Reference))) {
            throw new \InvalidArgumentException($included_Resource_Pools_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Included_Resource_Pools_Reference = $included_Resource_Pools_Reference;
        return $this;
    }
    /**
     * Add item to Included_Resource_Pools_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_PoolObjectType $item
     * @return \StructType\Resource_Pool_Hierarchy_DataType
     */
    public function addToIncluded_Resource_Pools_Reference(\StructType\Resource_PoolObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_PoolObjectType) {
            throw new \InvalidArgumentException(sprintf('The Included_Resource_Pools_Reference property can only contain items of type \StructType\Resource_PoolObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Included_Resource_Pools_Reference[] = $item;
        return $this;
    }
}
