<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recovery_Expense_Reports_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Recovery Expense Reports Data has reference to the Expense Reports being paid by this Receivable Repayment.
 * @subpackage Structs
 */
class Recovery_Expense_Reports_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Initial Expense Reports
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType[]
     */
    public $Expense_Report_Reference;
    /**
     * The Receivable_Repayment_Adhoc_Bank_Transaction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType[]
     */
    public $Receivable_Repayment_Adhoc_Bank_Transaction;
    /**
     * The Receivable_Repayment_Journal_Lines
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receivable_Repayment_Journal_LinesType[]
     */
    public $Receivable_Repayment_Journal_Lines;
    /**
     * Constructor method for Recovery_Expense_Reports_DataType
     * @uses Recovery_Expense_Reports_DataType::setExpense_Report_Reference()
     * @uses Recovery_Expense_Reports_DataType::setReceivable_Repayment_Adhoc_Bank_Transaction()
     * @uses Recovery_Expense_Reports_DataType::setReceivable_Repayment_Journal_Lines()
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     * @param \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType[] $receivable_Repayment_Adhoc_Bank_Transaction
     * @param \StructType\Receivable_Repayment_Journal_LinesType[] $receivable_Repayment_Journal_Lines
     */
    public function __construct(array $expense_Report_Reference = array(), array $receivable_Repayment_Adhoc_Bank_Transaction = array(), array $receivable_Repayment_Journal_Lines = array())
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setReceivable_Repayment_Adhoc_Bank_Transaction($receivable_Repayment_Adhoc_Bank_Transaction)
            ->setReceivable_Repayment_Journal_Lines($receivable_Repayment_Journal_Lines);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType[]|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem instanceof \StructType\Expense_ReportObjectType) {
                $invalidValues[] = is_object($recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem) ? get_class($recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem) : sprintf('%s(%s)', gettype($recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem), var_export($recovery_Expense_Reports_DataTypeExpense_Report_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function setExpense_Report_Reference(array $expense_Report_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Report_ReferenceArrayErrorMessage = self::validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference($expense_Report_Reference))) {
            throw new \InvalidArgumentException($expense_Report_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType $item
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function addToExpense_Report_Reference(\StructType\Expense_ReportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ReportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report_Reference[] = $item;
        return $this;
    }
    /**
     * Get Receivable_Repayment_Adhoc_Bank_Transaction value
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType[]|null
     */
    public function getReceivable_Repayment_Adhoc_Bank_Transaction()
    {
        return $this->Receivable_Repayment_Adhoc_Bank_Transaction;
    }
    /**
     * This method is responsible for validating the values passed to the setReceivable_Repayment_Adhoc_Bank_Transaction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceivable_Repayment_Adhoc_Bank_Transaction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceivable_Repayment_Adhoc_Bank_TransactionForArrayConstraintsFromSetReceivable_Repayment_Adhoc_Bank_Transaction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem) {
            // validation for constraint: itemType
            if (!$recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem instanceof \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType) {
                $invalidValues[] = is_object($recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem) ? get_class($recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem) : sprintf('%s(%s)', gettype($recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem), var_export($recovery_Expense_Reports_DataTypeReceivable_Repayment_Adhoc_Bank_TransactionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receivable_Repayment_Adhoc_Bank_Transaction property can only contain items of type \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receivable_Repayment_Adhoc_Bank_Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType[] $receivable_Repayment_Adhoc_Bank_Transaction
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function setReceivable_Repayment_Adhoc_Bank_Transaction(array $receivable_Repayment_Adhoc_Bank_Transaction = array())
    {
        // validation for constraint: array
        if ('' !== ($receivable_Repayment_Adhoc_Bank_TransactionArrayErrorMessage = self::validateReceivable_Repayment_Adhoc_Bank_TransactionForArrayConstraintsFromSetReceivable_Repayment_Adhoc_Bank_Transaction($receivable_Repayment_Adhoc_Bank_Transaction))) {
            throw new \InvalidArgumentException($receivable_Repayment_Adhoc_Bank_TransactionArrayErrorMessage, __LINE__);
        }
        $this->Receivable_Repayment_Adhoc_Bank_Transaction = $receivable_Repayment_Adhoc_Bank_Transaction;
        return $this;
    }
    /**
     * Add item to Receivable_Repayment_Adhoc_Bank_Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType $item
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function addToReceivable_Repayment_Adhoc_Bank_Transaction(\StructType\Receivable_Repayment_Adhoc_Bank_TransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType) {
            throw new \InvalidArgumentException(sprintf('The Receivable_Repayment_Adhoc_Bank_Transaction property can only contain items of type \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receivable_Repayment_Adhoc_Bank_Transaction[] = $item;
        return $this;
    }
    /**
     * Get Receivable_Repayment_Journal_Lines value
     * @return \StructType\Receivable_Repayment_Journal_LinesType[]|null
     */
    public function getReceivable_Repayment_Journal_Lines()
    {
        return $this->Receivable_Repayment_Journal_Lines;
    }
    /**
     * This method is responsible for validating the values passed to the setReceivable_Repayment_Journal_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceivable_Repayment_Journal_Lines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceivable_Repayment_Journal_LinesForArrayConstraintsFromSetReceivable_Repayment_Journal_Lines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem) {
            // validation for constraint: itemType
            if (!$recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem instanceof \StructType\Receivable_Repayment_Journal_LinesType) {
                $invalidValues[] = is_object($recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem) ? get_class($recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem) : sprintf('%s(%s)', gettype($recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem), var_export($recovery_Expense_Reports_DataTypeReceivable_Repayment_Journal_LinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receivable_Repayment_Journal_Lines property can only contain items of type \StructType\Receivable_Repayment_Journal_LinesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receivable_Repayment_Journal_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_Journal_LinesType[] $receivable_Repayment_Journal_Lines
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function setReceivable_Repayment_Journal_Lines(array $receivable_Repayment_Journal_Lines = array())
    {
        // validation for constraint: array
        if ('' !== ($receivable_Repayment_Journal_LinesArrayErrorMessage = self::validateReceivable_Repayment_Journal_LinesForArrayConstraintsFromSetReceivable_Repayment_Journal_Lines($receivable_Repayment_Journal_Lines))) {
            throw new \InvalidArgumentException($receivable_Repayment_Journal_LinesArrayErrorMessage, __LINE__);
        }
        $this->Receivable_Repayment_Journal_Lines = $receivable_Repayment_Journal_Lines;
        return $this;
    }
    /**
     * Add item to Receivable_Repayment_Journal_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_Journal_LinesType $item
     * @return \StructType\Recovery_Expense_Reports_DataType
     */
    public function addToReceivable_Repayment_Journal_Lines(\StructType\Receivable_Repayment_Journal_LinesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receivable_Repayment_Journal_LinesType) {
            throw new \InvalidArgumentException(sprintf('The Receivable_Repayment_Journal_Lines property can only contain items of type \StructType\Receivable_Repayment_Journal_LinesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receivable_Repayment_Journal_Lines[] = $item;
        return $this;
    }
}
