<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Asset_Pooling_Rule_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Asset Pooling Rules operation.
 * @subpackage Structs
 */
class Put_Asset_Pooling_Rule_RequestType extends AbstractStructBase
{
    /**
     * The Asset_Pooling_Rule_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Asset Pooling Rules
     * - minOccurs: 0
     * @var \StructType\Asset_Pooling_Rule_DataType
     */
    public $Asset_Pooling_Rule_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Enable to ensure that the request will not delete or modify any existing Asset Pooling Rules.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Asset_Pooling_Rule_RequestType
     * @uses Put_Asset_Pooling_Rule_RequestType::setAsset_Pooling_Rule_Data()
     * @uses Put_Asset_Pooling_Rule_RequestType::setAdd_Only()
     * @uses Put_Asset_Pooling_Rule_RequestType::setVersion()
     * @param \StructType\Asset_Pooling_Rule_DataType $asset_Pooling_Rule_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Asset_Pooling_Rule_DataType $asset_Pooling_Rule_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setAsset_Pooling_Rule_Data($asset_Pooling_Rule_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Asset_Pooling_Rule_Data value
     * @return \StructType\Asset_Pooling_Rule_DataType|null
     */
    public function getAsset_Pooling_Rule_Data()
    {
        return $this->Asset_Pooling_Rule_Data;
    }
    /**
     * Set Asset_Pooling_Rule_Data value
     * @param \StructType\Asset_Pooling_Rule_DataType $asset_Pooling_Rule_Data
     * @return \StructType\Put_Asset_Pooling_Rule_RequestType
     */
    public function setAsset_Pooling_Rule_Data(\StructType\Asset_Pooling_Rule_DataType $asset_Pooling_Rule_Data = null)
    {
        $this->Asset_Pooling_Rule_Data = $asset_Pooling_Rule_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Asset_Pooling_Rule_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Asset_Pooling_Rule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
