<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cardholder_Listing_File__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Card Holder Listing File data.
 * @subpackage Structs
 */
class Cardholder_Listing_File__HV__DataType extends AbstractStructBase
{
    /**
     * The Card_Holder_Listing_File_Number
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Number. This is the Card Holder Listing File unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Number;
    /**
     * The Card_Holder_Listing_File_Name
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Name;
    /**
     * The Card_Holder_Listing_File_Date
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Date;
    /**
     * The Credit_Card_Data
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card__HV__DataType[]
     */
    public $Credit_Card_Data;
    /**
     * Constructor method for Cardholder_Listing_File__HV__DataType
     * @uses Cardholder_Listing_File__HV__DataType::setCard_Holder_Listing_File_Number()
     * @uses Cardholder_Listing_File__HV__DataType::setCard_Holder_Listing_File_Name()
     * @uses Cardholder_Listing_File__HV__DataType::setCard_Holder_Listing_File_Date()
     * @uses Cardholder_Listing_File__HV__DataType::setCredit_Card_Data()
     * @param string $card_Holder_Listing_File_Number
     * @param string $card_Holder_Listing_File_Name
     * @param string $card_Holder_Listing_File_Date
     * @param \StructType\Credit_Card__HV__DataType[] $credit_Card_Data
     */
    public function __construct($card_Holder_Listing_File_Number = null, $card_Holder_Listing_File_Name = null, $card_Holder_Listing_File_Date = null, array $credit_Card_Data = array())
    {
        $this
            ->setCard_Holder_Listing_File_Number($card_Holder_Listing_File_Number)
            ->setCard_Holder_Listing_File_Name($card_Holder_Listing_File_Name)
            ->setCard_Holder_Listing_File_Date($card_Holder_Listing_File_Date)
            ->setCredit_Card_Data($credit_Card_Data);
    }
    /**
     * Get Card_Holder_Listing_File_Number value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Number()
    {
        return $this->Card_Holder_Listing_File_Number;
    }
    /**
     * Set Card_Holder_Listing_File_Number value
     * @param string $card_Holder_Listing_File_Number
     * @return \StructType\Cardholder_Listing_File__HV__DataType
     */
    public function setCard_Holder_Listing_File_Number($card_Holder_Listing_File_Number = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Number) && !is_string($card_Holder_Listing_File_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Number, true), gettype($card_Holder_Listing_File_Number)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Number = $card_Holder_Listing_File_Number;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Name value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Name()
    {
        return $this->Card_Holder_Listing_File_Name;
    }
    /**
     * Set Card_Holder_Listing_File_Name value
     * @param string $card_Holder_Listing_File_Name
     * @return \StructType\Cardholder_Listing_File__HV__DataType
     */
    public function setCard_Holder_Listing_File_Name($card_Holder_Listing_File_Name = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Name) && !is_string($card_Holder_Listing_File_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Name, true), gettype($card_Holder_Listing_File_Name)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Name = $card_Holder_Listing_File_Name;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Date value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Date()
    {
        return $this->Card_Holder_Listing_File_Date;
    }
    /**
     * Set Card_Holder_Listing_File_Date value
     * @param string $card_Holder_Listing_File_Date
     * @return \StructType\Cardholder_Listing_File__HV__DataType
     */
    public function setCard_Holder_Listing_File_Date($card_Holder_Listing_File_Date = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Date) && !is_string($card_Holder_Listing_File_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Date, true), gettype($card_Holder_Listing_File_Date)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Date = $card_Holder_Listing_File_Date;
        return $this;
    }
    /**
     * Get Credit_Card_Data value
     * @return \StructType\Credit_Card__HV__DataType[]|null
     */
    public function getCredit_Card_Data()
    {
        return $this->Credit_Card_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit_Card_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit_Card_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCredit_Card_DataForArrayConstraintsFromSetCredit_Card_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem) {
            // validation for constraint: itemType
            if (!$cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem instanceof \StructType\Credit_Card__HV__DataType) {
                $invalidValues[] = is_object($cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem) ? get_class($cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem) : sprintf('%s(%s)', gettype($cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem), var_export($cardholder_Listing_File_HV_DataTypeCredit_Card_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Credit_Card_Data property can only contain items of type \StructType\Credit_Card__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Credit_Card_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card__HV__DataType[] $credit_Card_Data
     * @return \StructType\Cardholder_Listing_File__HV__DataType
     */
    public function setCredit_Card_Data(array $credit_Card_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($credit_Card_DataArrayErrorMessage = self::validateCredit_Card_DataForArrayConstraintsFromSetCredit_Card_Data($credit_Card_Data))) {
            throw new \InvalidArgumentException($credit_Card_DataArrayErrorMessage, __LINE__);
        }
        $this->Credit_Card_Data = $credit_Card_Data;
        return $this;
    }
    /**
     * Add item to Credit_Card_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card__HV__DataType $item
     * @return \StructType\Cardholder_Listing_File__HV__DataType
     */
    public function addToCredit_Card_Data(\StructType\Credit_Card__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Credit_Card_Data property can only contain items of type \StructType\Credit_Card__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Credit_Card_Data[] = $item;
        return $this;
    }
}
