<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Submit ServiceType
 */
$submit = new \ServiceType\Submit($options);
$submit->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Submit_Supplier_Invoice operation/method
 */
if ($submit->Submit_Supplier_Invoice(new \StructType\Submit_Supplier_Invoice_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Invoice_Adjustment operation/method
 */
if ($submit->Submit_Supplier_Invoice_Adjustment(new \StructType\Submit_Supplier_Invoice_Adjustment_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Catalog_Load operation/method
 */
if ($submit->Submit_Catalog_Load(new \StructType\Submit_Catalog_Load_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Expense_Report operation/method
 */
if ($submit->Submit_Expense_Report(new \StructType\Submit_Expense_Report_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Purchase_Order operation/method
 */
if ($submit->Submit_Purchase_Order(new \StructType\Submit_Purchase_Order_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Expense_Report_for_Applicant operation/method
 */
if ($submit->Submit_Expense_Report_for_Applicant(new \StructType\Submit_Expense_Report_for_Applicant_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Invoice_Contract operation/method
 */
if ($submit->Submit_Supplier_Invoice_Contract(new \StructType\Submit_Supplier_Invoice_Contract_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Order_Contract operation/method
 */
if ($submit->Submit_Supplier_Order_Contract(new \StructType\Submit_Supplier_Order_Contract_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Receipt operation/method
 */
if ($submit->Submit_Receipt(new \StructType\Submit_Receipt_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Requisition operation/method
 */
if ($submit->Submit_Requisition(new \StructType\Submit_Requisition_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Spend_Authorization operation/method
 */
if ($submit->Submit_Spend_Authorization(new \StructType\Submit_Spend_Authorization_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Contract operation/method
 */
if ($submit->Submit_Supplier_Contract(new \StructType\Submit_Supplier_Contract_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Prepaid_Spend_Amortization operation/method
 */
if ($submit->Submit_Prepaid_Spend_Amortization(new \StructType\Submit_Prepaid_Spend_Amortization_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Invoice_Schedule operation/method
 */
if ($submit->Submit_Supplier_Invoice_Schedule(new \StructType\Submit_Supplier_Invoice_Schedule_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Purchase_Order_Schedule operation/method
 */
if ($submit->Submit_Purchase_Order_Schedule(new \StructType\Submit_Purchase_Order_Schedule_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Prepaid_Spend_Amortization_Schedule operation/method
 */
if ($submit->Submit_Prepaid_Spend_Amortization_Schedule(new \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier operation/method
 */
if ($submit->Submit_Supplier(new \StructType\Submit_Supplier_RequestRootType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Return operation/method
 */
if ($submit->Submit_Return(new \StructType\Submit_Return_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Workday_Project_Hierarchy operation/method
 */
if ($submit->Submit_Workday_Project_Hierarchy(new \StructType\Submit_Workday_Project_Hierarchy_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Procurement_Card_Transaction_Verification
 * operation/method
 */
if ($submit->Submit_Procurement_Card_Transaction_Verification(new \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Procurement_Mass_Close operation/method
 */
if ($submit->Submit_Procurement_Mass_Close(new \StructType\Submit_Procurement_Mass_Close_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Project operation/method
 */
if ($submit->Submit_Project(new \StructType\Submit_Project_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Resource_Plan operation/method
 */
if ($submit->Submit_Resource_Plan(new \StructType\Submit_Resource_Plan_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Request_for_Quote operation/method
 */
if ($submit->Submit_Request_for_Quote(new \StructType\Submit_Request_for_Quote_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Request_for_Quote_Response operation/method
 */
if ($submit->Submit_Request_for_Quote_Response(new \StructType\Submit_Request_for_Quote_Response_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Remit_To_Supplier_Connection operation/method
 */
if ($submit->Submit_Remit_To_Supplier_Connection(new \StructType\Submit_Remit_To_Supplier_Connection_RequestRootType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Request_for_Quote_Award operation/method
 */
if ($submit->Submit_Request_for_Quote_Award(new \StructType\Submit_Request_for_Quote_Award_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Contact_Information operation/method
 */
if ($submit->Submit_Supplier_Contact_Information(new \StructType\Submit_Supplier_Contact_Information_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Purchase_Order_Change_Order operation/method
 */
if ($submit->Submit_Purchase_Order_Change_Order(new \StructType\Submit_Purchase_Order_Change_Order_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Expense_Report_for_Non_Worker operation/method
 */
if ($submit->Submit_Expense_Report_for_Non_Worker(new \StructType\Submit_Expense_Report_for_Non_Worker_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Internal_Service_Delivery operation/method
 */
if ($submit->Submit_Internal_Service_Delivery(new \StructType\Submit_Internal_Service_Delivery_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Invoice_Request operation/method
 */
if ($submit->Submit_Supplier_Invoice_Request(new \StructType\Submit_Supplier_Invoice_Request_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Advanced_Ship_Notice operation/method
 */
if ($submit->Submit_Advanced_Ship_Notice(new \StructType\Submit_Advanced_Ship_Notice_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Purchase_Order_Acknowledgement operation/method
 */
if ($submit->Submit_Purchase_Order_Acknowledgement(new \StructType\Submit_Purchase_Order_Acknowledgement_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Mass_Reopen_Procurement_Documents operation/method
 */
if ($submit->Submit_Mass_Reopen_Procurement_Documents(new \StructType\Submit_Mass_Reopen_Procurement_Documents_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Order_From_Supplier_Connection operation/method
 */
if ($submit->Submit_Order_From_Supplier_Connection(new \StructType\Submit_Order_From_Supplier_Connection_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Contract_Amendment operation/method
 */
if ($submit->Submit_Supplier_Contract_Amendment(new \StructType\Submit_Supplier_Contract_Amendment_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Contract_Lease_Amendment operation/method
 */
if ($submit->Submit_Supplier_Contract_Lease_Amendment(new \StructType\Submit_Supplier_Contract_Lease_Amendment_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Receipt_Adjustment operation/method
 */
if ($submit->Submit_Receipt_Adjustment(new \StructType\Submit_Receipt_Adjustment_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Netting_Transaction operation/method
 */
if ($submit->Submit_Netting_Transaction(new \StructType\Submit_Netting_Transaction_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for Submit_Supplier_Refund operation/method
 */
if ($submit->Submit_Supplier_Refund(new \StructType\Submit_Supplier_Refund_RequestType()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Get_Resource_Categories operation/method
 */
if ($get->Get_Resource_Categories(new \StructType\Get_Resource_Categories_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Item_Groups operation/method
 */
if ($get->Get_Purchase_Item_Groups(new \StructType\Get_Purchase_Item_Groups_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Items operation/method
 */
if ($get->Get_Expense_Items(new \StructType\Get_Expense_Items_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Items operation/method
 */
if ($get->Get_Purchase_Items(new \StructType\Get_Purchase_Items_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Suppliers operation/method
 */
if ($get->Get_Suppliers(new \StructType\Get_Suppliers_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Item_Groups operation/method
 */
if ($get->Get_Expense_Item_Groups(new \StructType\Get_Expense_Item_Groups_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_PO_for_PO_Issue_Outbound operation/method
 */
if ($get->Get_PO_for_PO_Issue_Outbound(new \StructType\Get_PO_Outbound_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Categories operation/method
 */
if ($get->Get_Supplier_Categories(new \StructType\Get_Supplier_Categories_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Groups operation/method
 */
if ($get->Get_Supplier_Groups(new \StructType\Get_Supplier_Groups_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Timesheets operation/method
 */
if ($get->Get_Timesheets(new \StructType\Get_Timesheets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Corporate_Credit_Card_Billing_Accounts operation/method
 */
if ($get->Get_Corporate_Credit_Card_Billing_Accounts(new \StructType\Get_Corporate_Credit_Card_Billing_Accounts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Credit_Cards operation/method
 */
if ($get->Get_Expense_Credit_Cards(new \StructType\Get_Expense_Credit_Cards_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Business_Entity_Contacts operation/method
 */
if ($get->Get_Business_Entity_Contacts(new \StructType\Get_Business_Entity_Contacts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoices operation/method
 */
if ($get->Get_Supplier_Invoices(new \StructType\Get_Supplier_Invoices_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Adjustments operation/method
 */
if ($get->Get_Supplier_Invoice_Adjustments(new \StructType\Get_Supplier_Invoice_Adjustments_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Catalog_Loads operation/method
 */
if ($get->Get_Catalog_Loads(new \StructType\Get_Catalog_Loads_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Histories operation/method
 */
if ($get->Get_Supplier_Invoice_Histories(new \StructType\Get_Supplier_Invoice_Histories_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Worker_Roles operation/method
 */
if ($get->Get_Project_Worker_Roles(new \StructType\Get_Project_Worker_Roles_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Plan_Templates operation/method
 */
if ($get->Get_Project_Plan_Templates(new \StructType\Get_Project_Plan_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Templates operation/method
 */
if ($get->Get_Project_Templates(new \StructType\Get_Project_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Tasks operation/method
 */
if ($get->Get_Project_Tasks(new \StructType\Get_Project_Tasks_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Phases operation/method
 */
if ($get->Get_Project_Phases(new \StructType\Get_Project_Phases_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Reports operation/method
 */
if ($get->Get_Expense_Reports(new \StructType\Get_Expense_Reports_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Order_Contracts operation/method
 */
if ($get->Get_Supplier_Order_Contracts(new \StructType\Get_Supplier_Order_Contracts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Orders operation/method
 */
if ($get->Get_Purchase_Orders(new \StructType\Get_Purchase_Orders_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Policy_Groups operation/method
 */
if ($get->Get_Expense_Policy_Groups(new \StructType\Get_Expense_Policy_Groups_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Rate_Table_Rules operation/method
 */
if ($get->Get_Expense_Rate_Table_Rules(new \StructType\Get_Expense_Rate_Table_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Rate_Tables operation/method
 */
if ($get->Get_Expense_Rate_Tables(new \StructType\Get_Expense_Rate_Tables_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Spend_Category_Hierarchies operation/method
 */
if ($get->Get_Spend_Category_Hierarchies(new \StructType\Get_Spend_Category_Hierarchies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Payroll_Timesheets_Time_In_Time_Out operation/method
 */
if ($get->Get_Payroll_Timesheets_Time_In_Time_Out(new \StructType\Get_Payroll_Timesheets_Time_In_Time_Out_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Payroll_Timesheets_Total_Hours operation/method
 */
if ($get->Get_Payroll_Timesheets_Total_Hours(new \StructType\Get_Payroll_Timesheets_Total_Hours_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Timesheets operation/method
 */
if ($get->Get_Project_Timesheets(new \StructType\Get_Project_Timesheets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Travel_Profiles operation/method
 */
if ($get->Get_Travel_Profiles(new \StructType\Get_Travel_Profiles_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Credit_Card_Transaction_Files operation/method
 */
if ($get->Get_Expense_Credit_Card_Transaction_Files(new \StructType\Get_Credit_Card_Transaction_Files_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Credit_Card_Transactions operation/method
 */
if ($get->Get_Expense_Credit_Card_Transactions(new \StructType\Get_Expense_Credit_Card_Transactions_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Company_Defaults operation/method
 */
if ($get->Get_Expense_Company_Defaults(new \StructType\Get_Expense_Company_Defaults_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Card_Holder_Listing_Files operation/method
 */
if ($get->Get_Card_Holder_Listing_Files(new \StructType\Get_Card_Holder_Listing_Files_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Expense_Item_Attribute_Groups operation/method
 */
if ($get->Get_Expense_Item_Attribute_Groups(new \StructType\Get_Expense_Item_Attribute_Groups_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Receipts operation/method
 */
if ($get->Get_Receipts(new \StructType\Get_Receipts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Catalog_Items operation/method
 */
if ($get->Get_Catalog_Items(new \StructType\Get_Catalog_Items_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requisitions operation/method
 */
if ($get->Get_Requisitions(new \StructType\Get_Requisitions_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Asset_Book_Rules operation/method
 */
if ($get->Get_Asset_Book_Rules(new \StructType\Get_Asset_Book_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Spend_Authorizations operation/method
 */
if ($get->Get_Spend_Authorizations(new \StructType\Get_Spend_Authorizations_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Schedules operation/method
 */
if ($get->Get_Supplier_Invoice_Schedules(new \StructType\Get_Supplier_Invoice_Schedules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Order_Schedules operation/method
 */
if ($get->Get_Purchase_Order_Schedules(new \StructType\Get_Purchase_Order_Schedules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Contracts operation/method
 */
if ($get->Get_Supplier_Contracts(new \StructType\Get_Supplier_Contracts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Catalogs operation/method
 */
if ($get->Get_Supplier_Catalogs(new \StructType\Get_Supplier_Catalogs_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Airlines operation/method
 */
if ($get->Get_Airlines(new \StructType\Get_Airlines_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Hotels operation/method
 */
if ($get->Get_Hotels(new \StructType\Get_Hotels_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Car_Rental_Agencies operation/method
 */
if ($get->Get_Car_Rental_Agencies(new \StructType\Get_Car_Rental_Agencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Travel_Cities operation/method
 */
if ($get->Get_Travel_Cities(new \StructType\Get_Travel_Cities_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Airports operation/method
 */
if ($get->Get_Airports(new \StructType\Get_Airports_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Assets operation/method
 */
if ($get->Get_Assets(new \StructType\Get_Assets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Asset_Book_Configurations operation/method
 */
if ($get->Get_Asset_Book_Configurations(new \StructType\Get_Asset_Book_Configurations_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Prepaid_Spend_Amortizations operation/method
 */
if ($get->Get_Prepaid_Spend_Amortizations(new \StructType\Get_Prepaid_Spend_Amortizations_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Prepaid_Spend_Amortization_Schedules operation/method
 */
if ($get->Get_Prepaid_Spend_Amortization_Schedules(new \StructType\Get_Prepaid_Spend_Amortization_Schedules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Asset operation/method
 */
if ($get->Get_Project_Asset(new \StructType\Get_Project_Asset_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Asset_Pooling_Rules operation/method
 */
if ($get->Get_Asset_Pooling_Rules(new \StructType\Get_Asset_Pooling_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Returns operation/method
 */
if ($get->Get_Returns(new \StructType\Get_Returns_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Workday_Project_Hierarchies operation/method
 */
if ($get->Get_Workday_Project_Hierarchies(new \StructType\Get_Workday_Project_Hierarchies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Workday_Project_Hierarchies_without_Dependencies
 * operation/method
 */
if ($get->Get_Workday_Project_Hierarchies_without_Dependencies(new \StructType\Get_Workday_Project_Hierarchies_without_Dependencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Procurement_Card_Transaction_Verifications operation/method
 */
if ($get->Get_Procurement_Card_Transaction_Verifications(new \StructType\Get_Procurement_Card_Transaction_Verifications_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Procurement_Mass_Close operation/method
 */
if ($get->Get_Procurement_Mass_Close(new \StructType\Get_Procurement_Mass_Close_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Travel_Booking_Files operation/method
 */
if ($get->Get_Travel_Booking_Files(new \StructType\Get_Travel_Booking_Files_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Task_Resources operation/method
 */
if ($get->Get_Project_Task_Resources(new \StructType\Get_Project_Task_Resources_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Projects operation/method
 */
if ($get->Get_Projects(new \StructType\Get_Projects_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Plans operation/method
 */
if ($get->Get_Project_Plans(new \StructType\Get_Project_Plans_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Plans operation/method
 */
if ($get->Get_Resource_Plans(new \StructType\Get_Resource_Plans_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Request_for_Quote operation/method
 */
if ($get->Get_Request_for_Quote(new \StructType\Get_Request_for_Quote_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Item_Identifier_Types operation/method
 */
if ($get->Get_Item_Identifier_Types(new \StructType\Get_Item_Identifier_Types_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Request_for_Quote_Responses operation/method
 */
if ($get->Get_Request_for_Quote_Responses(new \StructType\Get_Request_for_Quote_Responses_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Remit_To_Supplier_Connections operation/method
 */
if ($get->Get_Remit_To_Supplier_Connections(new \StructType\Get_Remit_To_Supplier_Connections_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requirements_for_Resource_Plan operation/method
 */
if ($get->Get_Requirements_for_Resource_Plan(new \StructType\Get_Requirements_for_Resource_Plan_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Request_for_Quote_Awards operation/method
 */
if ($get->Get_Request_for_Quote_Awards(new \StructType\Get_Request_for_Quote_Awards_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requisition_Sourcing_Rules operation/method
 */
if ($get->Get_Requisition_Sourcing_Rules(new \StructType\Get_Requisition_Sourcing_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Guests operation/method
 */
if ($get->Get_Guests(new \StructType\Get_Guests_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Guest_Listing_Files operation/method
 */
if ($get->Get_Guest_Listing_Files(new \StructType\Get_Guest_Listing_Files_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Contact_Information operation/method
 */
if ($get->Get_Supplier_Contact_Information(new \StructType\Get_Supplier_Contact_Information_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Forecasts operation/method
 */
if ($get->Get_Resource_Forecasts(new \StructType\Get_Resource_Forecasts_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Cash_Advance_Repayments operation/method
 */
if ($get->Get_Cash_Advance_Repayments(new \StructType\Get_Cash_Advance_Repayments_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Order_Change_Orders operation/method
 */
if ($get->Get_Purchase_Order_Change_Orders(new \StructType\Get_Purchase_Order_Change_Orders_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Asset_Shares operation/method
 */
if ($get->Get_Asset_Shares(new \StructType\Get_Asset_Shares_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Standard_Cost_Rate_Sheets operation/method
 */
if ($get->Get_Project_Standard_Cost_Rate_Sheets(new \StructType\Get_Project_Standard_Cost_Rate_Sheets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Internal_Service_Deliveries operation/method
 */
if ($get->Get_Internal_Service_Deliveries(new \StructType\Get_Internal_Service_Deliveries_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Item_Tags operation/method
 */
if ($get->Get_Item_Tags(new \StructType\Get_Item_Tags_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Internal_Service_Providers operation/method
 */
if ($get->Get_Internal_Service_Providers(new \StructType\Get_Internal_Service_Providers_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Internal_Catalogs operation/method
 */
if ($get->Get_Internal_Catalogs(new \StructType\Get_Internal_Catalogs_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Credit_Card_Code_Mappings operation/method
 */
if ($get->Get_Credit_Card_Code_Mappings(new \StructType\Get_Credit_Card_Code_Mappings_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Requests operation/method
 */
if ($get->Get_Supplier_Invoice_Requests(new \StructType\Get_Supplier_Invoice_Requests_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Plan_Templates operation/method
 */
if ($get->Get_Resource_Plan_Templates(new \StructType\Get_Resource_Plan_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Advanced_Ship_Notices operation/method
 */
if ($get->Get_Advanced_Ship_Notices(new \StructType\Get_Advanced_Ship_Notices_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Worker_Travel_Profile_Listing_Files operation/method
 */
if ($get->Get_Worker_Travel_Profile_Listing_Files(new \StructType\Get_Worker_Travel_Profile_Listing_Files_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Order_Acknowledgement operation/method
 */
if ($get->Get_Purchase_Order_Acknowledgement(new \StructType\Get_Purchase_Order_Acknowledgements_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Location_Customer_Account_Number_Details operation/method
 */
if ($get->Get_Location_Customer_Account_Number_Details(new \StructType\Get_Location_Customer_Account_Number_Details_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Role_Categories operation/method
 */
if ($get->Get_Project_Role_Categories(new \StructType\Get_Project_Role_Categories_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Classifications operation/method
 */
if ($get->Get_Supplier_Classifications(new \StructType\Get_Supplier_Classifications_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Invoice_Types operation/method
 */
if ($get->Get_Invoice_Types(new \StructType\Get_Invoice_Types_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Pool_Hierarchies operation/method
 */
if ($get->Get_Resource_Pool_Hierarchies(new \StructType\Get_Resource_Pool_Hierarchies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Pools operation/method
 */
if ($get->Get_Resource_Pools(new \StructType\Get_Resource_Pools_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Resource_Pool_Hierarchies_without_Dependencies
 * operation/method
 */
if ($get->Get_Resource_Pool_Hierarchies_without_Dependencies(new \StructType\Get_Resource_Pool_Hierarchies_without_Dependencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requisition_Additional_Data operation/method
 */
if ($get->Get_Requisition_Additional_Data(new \StructType\Get_Requisition_Additional_Data_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requisition_Line_Additional_Data operation/method
 */
if ($get->Get_Requisition_Line_Additional_Data(new \StructType\Get_Requisition_Line_Additional_Data_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Company_Asset_Book_Restrictions operation/method
 */
if ($get->Get_Company_Asset_Book_Restrictions(new \StructType\Get_Company_Asset_Book_Restrictions_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Transfer_Pricing_Rate_Sheet operation/method
 */
if ($get->Get_Transfer_Pricing_Rate_Sheet(new \StructType\Get_Transfer_Pricing_Rate_Sheets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Order_From_Supplier_Connections operation/method
 */
if ($get->Get_Order_From_Supplier_Connections(new \StructType\Get_Order_From_Supplier_Connections_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requisition_Templates operation/method
 */
if ($get->Get_Requisition_Templates(new \StructType\Get_Requisition_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Items operation/method
 */
if ($get->Get_Supplier_Items(new \StructType\Get_Supplier_Items_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Revenue_Centers operation/method
 */
if ($get->Get_Revenue_Centers(new \StructType\Get_Revenue_Centers_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Contract_Amendments operation/method
 */
if ($get->Get_Supplier_Contract_Amendments(new \StructType\Get_Supplier_Contract_Amendments_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Line_Additional_Data operation/method
 */
if ($get->Get_Supplier_Invoice_Line_Additional_Data(new \StructType\Get_Supplier_Invoice_Line_Additional_Data_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Worker_Utilization_Target_Sheets operation/method
 */
if ($get->Get_Worker_Utilization_Target_Sheets(new \StructType\Get_Worker_Utilization_Target_Sheets_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Order_Lines_Additional_Data operation/method
 */
if ($get->Get_Purchase_Order_Lines_Additional_Data(new \StructType\Get_Purchase_Order_Lines_Additional_Data_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Portfolios operation/method
 */
if ($get->Get_Project_Portfolios(new \StructType\Get_Project_Portfolios_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Contract_Lease_Amendments operation/method
 */
if ($get->Get_Supplier_Contract_Lease_Amendments(new \StructType\Get_Supplier_Contract_Lease_Amendments_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Worktag_Split_Template_Restrictions operation/method
 */
if ($get->Get_Worktag_Split_Template_Restrictions(new \StructType\Get_Worktag_Split_Template_Restrictions_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Worktag_Split_Templates operation/method
 */
if ($get->Get_Worktag_Split_Templates(new \StructType\Get_Worktag_Split_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Portfolios_without_Dependencies operation/method
 */
if ($get->Get_Project_Portfolios_without_Dependencies(new \StructType\Get_Project_Portfolios_without_Dependencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Travel_Booking_Records operation/method
 */
if ($get->Get_Travel_Booking_Records(new \StructType\Get_Travel_Booking_Records_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Receivable_Repayment operation/method
 */
if ($get->Get_Receivable_Repayment(new \StructType\Get_Receivable_Repayment_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Lines operation/method
 */
if ($get->Get_Supplier_Invoice_Lines(new \StructType\Get_Supplier_Invoice_Lines_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Receipt_Adjustments operation/method
 */
if ($get->Get_Receipt_Adjustments(new \StructType\Get_Receipt_Adjustments_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Commodity_Code_Types operation/method
 */
if ($get->Get_Commodity_Code_Types(new \StructType\Get_Commodity_Code_Types_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Work_Queue_Tags operation/method
 */
if ($get->Get_Supplier_Invoice_Work_Queue_Tags(new \StructType\Get_Supplier_Invoice_Work_Queue_Tags_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Commodity_Codes operation/method
 */
if ($get->Get_Commodity_Codes(new \StructType\Get_Commodity_Codes_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules
 * operation/method
 */
if ($get->Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules(new \StructType\Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Plans_without_Dependencies operation/method
 */
if ($get->Get_Project_Plans_without_Dependencies(new \StructType\Get_Project_Plans_without_Dependencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_Assignment_Rules operation/method
 */
if ($get->Get_Supplier_Invoice_Assignment_Rules(new \StructType\Get_Supplier_Invoice_Assignment_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Assign_Supplier_to_Contingent_Worker operation/method
 */
if ($get->Get_Assign_Supplier_to_Contingent_Worker(new \StructType\Get_Assign_Supplier_to_Contingent_Worker_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Procurement_Conditional_Rules_Without_Dependencies
 * operation/method
 */
if ($get->Get_Procurement_Conditional_Rules_Without_Dependencies(new \StructType\Get_Procurement_Conditional_Rules_Without_Dependencies_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Procurement_Conditional_Rules operation/method
 */
if ($get->Get_Procurement_Conditional_Rules(new \StructType\Get_Procurement_Conditional_Rules_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Project_Budget_Templates operation/method
 */
if ($get->Get_Project_Budget_Templates(new \StructType\Get_Project_Budget_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Item_Request_Templates operation/method
 */
if ($get->Get_Purchase_Item_Request_Templates(new \StructType\Get_Purchase_Item_Request_Templates_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Item_Request_Types operation/method
 */
if ($get->Get_Purchase_Item_Request_Types(new \StructType\Get_Purchase_Item_Request_Types_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_External_Transaction_Sources operation/method
 */
if ($get->Get_External_Transaction_Sources(new \StructType\Get_External_Transaction_Sources_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Netting_Transactions operation/method
 */
if ($get->Get_Netting_Transactions(new \StructType\Get_Netting_Transactions_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Refunds operation/method
 */
if ($get->Get_Supplier_Refunds(new \StructType\Get_Supplier_Refunds_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Requesting_Entities operation/method
 */
if ($get->Get_Requesting_Entities(new \StructType\Get_Requesting_Entities_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Purchase_Item_Lists operation/method
 */
if ($get->Get_Purchase_Item_Lists(new \StructType\Get_Purchase_Item_Lists_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Web_Item_Attributes operation/method
 */
if ($get->Get_Web_Item_Attributes(new \StructType\Get_Web_Item_Attributes_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_External_Business_Entity_Contact operation/method
 */
if ($get->Get_External_Business_Entity_Contact(new \StructType\Get_External_Business_Entity_Contact_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Supplier_Invoice_System_Validation_Configuration
 * operation/method
 */
if ($get->Get_Supplier_Invoice_System_Validation_Configuration(new \StructType\Get_Supplier_Invoice_System_Validation_Configuration_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get_Carriers operation/method
 */
if ($get->Get_Carriers(new \StructType\Get_Carriers_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Put ServiceType
 */
$put = new \ServiceType\Put($options);
$put->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Put_Resource_Category operation/method
 */
if ($put->Put_Resource_Category(new \StructType\Put_Resource_Category_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Item_Group operation/method
 */
if ($put->Put_Purchase_Item_Group(new \StructType\Put_Purchase_Item_Group_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Item operation/method
 */
if ($put->Put_Purchase_Item(new \StructType\Put_Purchase_Item_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Item operation/method
 */
if ($put->Put_Expense_Item(new \StructType\Put_Expense_Item_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier operation/method
 */
if ($put->Put_Supplier(new \StructType\Put_Supplier_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Item_Group operation/method
 */
if ($put->Put_Expense_Item_Group(new \StructType\Put_Expense_Item_Group_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Category operation/method
 */
if ($put->Put_Supplier_Category(new \StructType\Put_Supplier_Category_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Group operation/method
 */
if ($put->Put_Supplier_Group(new \StructType\Put_Supplier_Group_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Corporate_Credit_Card_Billing_Account operation/method
 */
if ($put->Put_Corporate_Credit_Card_Billing_Account(new \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Credit_Card operation/method
 */
if ($put->Put_Expense_Credit_Card(new \StructType\Put_Expense_Credit_Card_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Business_Entity_Contact operation/method
 */
if ($put->Put_Business_Entity_Contact(new \StructType\Put_Business_Entity_Contact_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_History operation/method
 */
if ($put->Put_Supplier_Invoice_History(new \StructType\Put_Supplier_Invoice_History_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Worker_Role operation/method
 */
if ($put->Put_Project_Worker_Role(new \StructType\Put_Project_Worker_Role_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Task operation/method
 */
if ($put->Put_Project_Task(new \StructType\Put_Project_Task_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Phase operation/method
 */
if ($put->Put_Project_Phase(new \StructType\Put_Project_Phase_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Policy_Group operation/method
 */
if ($put->Put_Expense_Policy_Group(new \StructType\Put_Expense_Policy_Group_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Rate_Table_Rule operation/method
 */
if ($put->Put_Expense_Rate_Table_Rule(new \StructType\Put_Expense_Rate_Table_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Spend_Category_Hierarchy operation/method
 */
if ($put->Put_Spend_Category_Hierarchy(new \StructType\Put_Spend_Category_Hierarchy_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Credit_Card_Transaction_File operation/method
 */
if ($put->Put_Expense_Credit_Card_Transaction_File(new \StructType\Put_Credit_Card_Transaction_File_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Credit_Card_Transaction operation/method
 */
if ($put->Put_Expense_Credit_Card_Transaction(new \StructType\Put_Expense_Credit_Card_Transaction_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Company_Default operation/method
 */
if ($put->Put_Expense_Company_Default(new \StructType\Put_Expense_Company_Default_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Card_Holder_Listing_File operation/method
 */
if ($put->Put_Card_Holder_Listing_File(new \StructType\Put_Card_Holder_Listing_File_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Expense_Item_Attribute_Group operation/method
 */
if ($put->Put_Expense_Item_Attribute_Group(new \StructType\Put_Expense_Item_Attribute_Group_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Asset_Book_Rules operation/method
 */
if ($put->Put_Asset_Book_Rules(new \StructType\Put_Asset_Book_Rules_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Catalog operation/method
 */
if ($put->Put_Supplier_Catalog(new \StructType\Put_Supplier_Catalog_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Airline operation/method
 */
if ($put->Put_Airline(new \StructType\Put_Airline_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Hotel operation/method
 */
if ($put->Put_Hotel(new \StructType\Put_Hotel_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Car_Rental_Agency operation/method
 */
if ($put->Put_Car_Rental_Agency(new \StructType\Put_Car_Rental_Agency_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Travel_City operation/method
 */
if ($put->Put_Travel_City(new \StructType\Put_Travel_City_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Airport operation/method
 */
if ($put->Put_Airport(new \StructType\Put_Airport_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Asset operation/method
 */
if ($put->Put_Project_Asset(new \StructType\Put_Project_Asset_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Asset_Pooling_Rule operation/method
 */
if ($put->Put_Asset_Pooling_Rule(new \StructType\Put_Asset_Pooling_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Task_Resources operation/method
 */
if ($put->Put_Project_Task_Resources(new \StructType\Put_Project_Task_Resources_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Plan operation/method
 */
if ($put->Put_Project_Plan(new \StructType\Put_Project_Plan_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Item_Identifier_Type operation/method
 */
if ($put->Put_Item_Identifier_Type(new \StructType\Put_Item_Identifier_Type_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requirements_for_Resource_Plan operation/method
 */
if ($put->Put_Requirements_for_Resource_Plan(new \StructType\Put_Requirements_for_Resource_Plan_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requisition_Sourcing_Rule operation/method
 */
if ($put->Put_Requisition_Sourcing_Rule(new \StructType\Put_Requisition_Sourcing_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Cash_Advance_Repayment operation/method
 */
if ($put->Put_Cash_Advance_Repayment(new \StructType\Put_Cash_Advance_Repayment_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Standard_Cost_Rate_Sheet operation/method
 */
if ($put->Put_Project_Standard_Cost_Rate_Sheet(new \StructType\Put_Project_Standard_Cost_Rate_Sheet_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Item_Tag operation/method
 */
if ($put->Put_Item_Tag(new \StructType\Put_Item_Tag_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Internal_Service_Provider operation/method
 */
if ($put->Put_Internal_Service_Provider(new \StructType\Put_Internal_Service_Provider_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Internal_Catalog operation/method
 */
if ($put->Put_Internal_Catalog(new \StructType\Put_Internal_Catalog_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Credit_Card_Code_Mapping operation/method
 */
if ($put->Put_Credit_Card_Code_Mapping(new \StructType\Put_Credit_Card_Code_Mapping_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Procurement_Document_Attachment operation/method
 */
if ($put->Put_Procurement_Document_Attachment(new \StructType\Put_Procurement_Document_Attachment_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Location_Customer_Account_Number_Detail operation/method
 */
if ($put->Put_Location_Customer_Account_Number_Detail(new \StructType\Put_Location_Customer_Account_Number_Detail_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Role_Category operation/method
 */
if ($put->Put_Project_Role_Category(new \StructType\Put_Project_Role_Category_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Classification operation/method
 */
if ($put->Put_Supplier_Classification(new \StructType\Put_Supplier_Classification_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Invoice_Types operation/method
 */
if ($put->Put_Invoice_Types(new \StructType\Put_Invoice_Types_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Contract_Document_Link operation/method
 */
if ($put->Put_Supplier_Contract_Document_Link(new \StructType\Put_Supplier_Contract_Document_Link_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Resource_Pool_Hierarchy operation/method
 */
if ($put->Put_Resource_Pool_Hierarchy(new \StructType\Put_Resource_Pool_Hierarchy_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Resource_Pool operation/method
 */
if ($put->Put_Resource_Pool(new \StructType\Put_Resource_Pool_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requisition_Additional_Data operation/method
 */
if ($put->Put_Requisition_Additional_Data(new \StructType\Put_Requisition_Additional_Data_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requisition_Line_Additional_Data operation/method
 */
if ($put->Put_Requisition_Line_Additional_Data(new \StructType\Put_Requisition_Line_Additional_Data_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Company_Asset_Book_Restrictions operation/method
 */
if ($put->Put_Company_Asset_Book_Restrictions(new \StructType\Put_Company_Asset_Book_Restrictions_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Transfer_Pricing_Rate_Sheet operation/method
 */
if ($put->Put_Transfer_Pricing_Rate_Sheet(new \StructType\Put_Transfer_Pricing_Rate_Sheet_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Revenue_Center operation/method
 */
if ($put->Put_Revenue_Center(new \StructType\Put_Revenue_Center_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requisition_Template operation/method
 */
if ($put->Put_Requisition_Template(new \StructType\Put_Requisition_Template_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Patient_Charge_Information operation/method
 */
if ($put->Put_Patient_Charge_Information(new \StructType\Put_Patient_Charge_Information_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_Line_Additional_Data operation/method
 */
if ($put->Put_Supplier_Invoice_Line_Additional_Data(new \StructType\Put_Supplier_Invoice_Line_Additional_Data_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Worker_Utilization_Target_Sheet operation/method
 */
if ($put->Put_Worker_Utilization_Target_Sheet(new \StructType\Put_Worker_Utilization_Target_Sheet_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_OCR_Supplier_Invoice operation/method
 */
if ($put->Put_OCR_Supplier_Invoice(new \StructType\Put_OCR_Supplier_Invoice_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Payment_Memo operation/method
 */
if ($put->Put_Supplier_Payment_Memo(new \StructType\Put_Supplier_Payment_Memo_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Order_Line_Additional_Data operation/method
 */
if ($put->Put_Purchase_Order_Line_Additional_Data(new \StructType\Put_Purchase_Order_Line_Additional_Data_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Portfolio operation/method
 */
if ($put->Put_Project_Portfolio(new \StructType\Put_Project_Portfolio_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Worktag_Split_Template_Restriction operation/method
 */
if ($put->Put_Worktag_Split_Template_Restriction(new \StructType\Put_Worktag_Split_Template_Restriction_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Worktag_Split_Template operation/method
 */
if ($put->Put_Worktag_Split_Template(new \StructType\Put_Worktag_Split_Template_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Receivable_Repayment operation/method
 */
if ($put->Put_Receivable_Repayment(new \StructType\Put_Receivable_Repayment_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Tax_Certificate_Numbers_On_Supplier_Payment operation/method
 */
if ($put->Put_Tax_Certificate_Numbers_On_Supplier_Payment(new \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Commodity_Code_Type operation/method
 */
if ($put->Put_Commodity_Code_Type(new \StructType\Put_Commodity_Code_Type_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_Work_Queue_Tag operation/method
 */
if ($put->Put_Supplier_Invoice_Work_Queue_Tag(new \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Commodity_Code operation/method
 */
if ($put->Put_Commodity_Code(new \StructType\Put_Commodity_Code_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule
 * operation/method
 */
if ($put->Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule(new \StructType\Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_Assignment_Rule operation/method
 */
if ($put->Put_Supplier_Invoice_Assignment_Rule(new \StructType\Put_Supplier_Invoice_Assignment_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Assign_Supplier_to_Contingent_Worker operation/method
 */
if ($put->Put_Assign_Supplier_to_Contingent_Worker(new \StructType\Put_Assign_Supplier_to_Contingent_Worker_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Procurement_Conditional_Rule operation/method
 */
if ($put->Put_Procurement_Conditional_Rule(new \StructType\Put_Procurement_Conditional_Rule_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Project_Budget_Template operation/method
 */
if ($put->Put_Project_Budget_Template(new \StructType\Put_Project_Budget_Template_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Item_Request_Type operation/method
 */
if ($put->Put_Purchase_Item_Request_Type(new \StructType\Put_Purchase_Item_Request_Type_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Item_Request_Template operation/method
 */
if ($put->Put_Purchase_Item_Request_Template(new \StructType\Put_Purchase_Item_Request_Template_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_External_Transaction_Source operation/method
 */
if ($put->Put_External_Transaction_Source(new \StructType\Put_External_Transaction_Source_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_External_Reference_on_Spend_Transaction operation/method
 */
if ($put->Put_External_Reference_on_Spend_Transaction(new \StructType\Put_External_Reference_on_Spend_Transaction_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Requesting_Entity operation/method
 */
if ($put->Put_Requesting_Entity(new \StructType\Put_Requesting_Entity_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Purchase_Item_List operation/method
 */
if ($put->Put_Purchase_Item_List(new \StructType\Put_Purchase_Item_List_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Web_Item_Attributes operation/method
 */
if ($put->Put_Web_Item_Attributes(new \StructType\Put_Web_Item_Attributes_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_External_Business_Entity_Contact operation/method
 */
if ($put->Put_External_Business_Entity_Contact(new \StructType\Put_External_Business_Entity_Contact_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_System_Validation_Configuration
 * operation/method
 */
if ($put->Put_Supplier_Invoice_System_Validation_Configuration(new \StructType\Put_Supplier_Invoice_System_Validation_Configuration_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Carriers operation/method
 */
if ($put->Put_Carriers(new \StructType\Put_Carriers_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for Put_Supplier_Invoice_Links operation/method
 */
if ($put->Put_Supplier_Invoice_Links(new \StructType\Put_Supplier_Invoice_Links_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Cancel_Supplier_Invoice operation/method
 */
if ($cancel->Cancel_Supplier_Invoice(new \StructType\Cancel_Supplier_Invoice_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Supplier_Invoice_Adjustment operation/method
 */
if ($cancel->Cancel_Supplier_Invoice_Adjustment(new \StructType\Cancel_Supplier_Invoice_Adjustment_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Expense_Report operation/method
 */
if ($cancel->Cancel_Expense_Report(new \StructType\Cancel_Expense_Report_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Timesheet operation/method
 */
if ($cancel->Cancel_Timesheet(new \StructType\Cancel_Timesheet_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Purchase_Order operation/method
 */
if ($cancel->Cancel_Purchase_Order(new \StructType\Cancel_Purchase_Order_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Requisition operation/method
 */
if ($cancel->Cancel_Requisition(new \StructType\Cancel_Requisition_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Receipt operation/method
 */
if ($cancel->Cancel_Receipt(new \StructType\Cancel_Receipt_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Request_for_Quote_Response operation/method
 */
if ($cancel->Cancel_Request_for_Quote_Response(new \StructType\Cancel_Request_for_Quote_Response_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Internal_Service_Delivery operation/method
 */
if ($cancel->Cancel_Internal_Service_Delivery(new \StructType\Cancel_Internal_Service_Delivery_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Advanced_Ship_Notice operation/method
 */
if ($cancel->Cancel_Advanced_Ship_Notice(new \StructType\Cancel_Advanced_Ship_Notice_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Purchase_Order_Acknowledgement operation/method
 */
if ($cancel->Cancel_Purchase_Order_Acknowledgement(new \StructType\Cancel_Purchase_Order_Acknowledgement_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Procurement_Card_Transaction_Verification
 * operation/method
 */
if ($cancel->Cancel_Procurement_Card_Transaction_Verification(new \StructType\Cancel_Procurement_Card_Transaction_Verification_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Pending_Supplier_Change operation/method
 */
if ($cancel->Cancel_Pending_Supplier_Change(new \StructType\Cancel_Pending_Supplier_Change_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Spend_Authorization operation/method
 */
if ($cancel->Cancel_Spend_Authorization(new \StructType\Cancel_Spend_Authorization_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Receipt_Adjustment operation/method
 */
if ($cancel->Cancel_Receipt_Adjustment(new \StructType\Cancel_Receipt_Adjustment_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Netting_Transaction operation/method
 */
if ($cancel->Cancel_Netting_Transaction(new \StructType\Cancel_Netting_Transaction_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel_Supplier_Payment operation/method
 */
if ($cancel->Cancel_Supplier_Payment(new \StructType\Cancel_Supplier_Payment_RequestType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
$register->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Register_Asset operation/method
 */
if ($register->Register_Asset(new \StructType\Register_Asset_RequestRootType()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Issue ServiceType
 */
$issue = new \ServiceType\Issue($options);
$issue->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Issue_Asset operation/method
 */
if ($issue->Issue_Asset(new \StructType\Issue_Asset_RequestType()) !== false) {
    print_r($issue->getResult());
} else {
    print_r($issue->getLastError());
}
/**
 * Samples for Adjust ServiceType
 */
$adjust = new \ServiceType\Adjust($options);
$adjust->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Adjust_Asset_Cost operation/method
 */
if ($adjust->Adjust_Asset_Cost(new \StructType\Adjust_Asset_Cost_RequestRootType()) !== false) {
    print_r($adjust->getResult());
} else {
    print_r($adjust->getLastError());
}
/**
 * Sample call for Adjust_Asset_In_Service_Date operation/method
 */
if ($adjust->Adjust_Asset_In_Service_Date(new \StructType\Adjust_Asset_In_Service_Date_RequestType()) !== false) {
    print_r($adjust->getResult());
} else {
    print_r($adjust->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \ServiceType\Edit($options);
$edit->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Edit_Asset operation/method
 */
if ($edit->Edit_Asset(new \StructType\Edit_Asset_RequestType()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Update_Asset_Useful_Life operation/method
 */
if ($update->Update_Asset_Useful_Life(new \StructType\Update_Asset_Useful_Life_RequestType()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for Update_Asset_Book_Configuration operation/method
 */
if ($update->Update_Asset_Book_Configuration(new \StructType\Update_Asset_Book_Configuration_RequestRootType()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \ServiceType\Transfer($options);
$transfer->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Transfer_Asset operation/method
 */
if ($transfer->Transfer_Asset(new \StructType\Transfer_Asset_RequestRootType()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for Transfer_Asset_To_Different_Company operation/method
 */
if ($transfer->Transfer_Asset_To_Different_Company(new \StructType\Transfer_Asset_To_Different_Company_RequestType()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Impair ServiceType
 */
$impair = new \ServiceType\Impair($options);
$impair->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Impair_Asset operation/method
 */
if ($impair->Impair_Asset(new \StructType\Impair_Asset_RequestType()) !== false) {
    print_r($impair->getResult());
} else {
    print_r($impair->getLastError());
}
/**
 * Samples for Reinstate ServiceType
 */
$reinstate = new \ServiceType\Reinstate($options);
$reinstate->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Reinstate_Asset operation/method
 */
if ($reinstate->Reinstate_Asset(new \StructType\Reinstate_Asset_RequestType()) !== false) {
    print_r($reinstate->getResult());
} else {
    print_r($reinstate->getLastError());
}
/**
 * Samples for Dispose ServiceType
 */
$dispose = new \ServiceType\Dispose($options);
$dispose->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Dispose_Asset operation/method
 */
if ($dispose->Dispose_Asset(new \StructType\Dispose_Asset_RequestRootType()) !== false) {
    print_r($dispose->getResult());
} else {
    print_r($dispose->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Remove_Asset operation/method
 */
if ($remove->Remove_Asset(new \StructType\Remove_Asset_RequestType()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for Remove_Supplier_Contract_Line_Hold operation/method
 */
if ($remove->Remove_Supplier_Contract_Line_Hold(new \StructType\Remove_Supplier_Contract_Line_Hold_RequestType()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Suspend ServiceType
 */
$suspend = new \ServiceType\Suspend($options);
$suspend->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Suspend_Asset_Depreciation operation/method
 */
if ($suspend->Suspend_Asset_Depreciation(new \StructType\Suspend_Asset_Depreciation_RequestType()) !== false) {
    print_r($suspend->getResult());
} else {
    print_r($suspend->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Add_Supplier_Contract_Line_Hold operation/method
 */
if ($add->Add_Supplier_Contract_Line_Hold(new \StructType\Add_Supplier_Contract_Line_Hold_RequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Resume ServiceType
 */
$resume = new \ServiceType\Resume($options);
$resume->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Resume_Asset_Depreciation operation/method
 */
if ($resume->Resume_Asset_Depreciation(new \StructType\Resume_Asset_Depreciation_RequestType()) !== false) {
    print_r($resume->getResult());
} else {
    print_r($resume->getLastError());
}
/**
 * Samples for Place ServiceType
 */
$place = new \ServiceType\Place($options);
$place->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Place_Asset_in_Service operation/method
 */
if ($place->Place_Asset_in_Service(new \StructType\Place_Asset_in_Service_RequestType()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Reclassify ServiceType
 */
$reclassify = new \ServiceType\Reclassify($options);
$reclassify->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Reclassify_Asset operation/method
 */
if ($reclassify->Reclassify_Asset(new \StructType\Reclassify_Asset_RequestType()) !== false) {
    print_r($reclassify->getResult());
} else {
    print_r($reclassify->getLastError());
}
/**
 * Samples for Maintain ServiceType
 */
$maintain = new \ServiceType\Maintain($options);
$maintain->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Maintain_Asset_Shares operation/method
 */
if ($maintain->Maintain_Asset_Shares(new \StructType\Maintain_Asset_Shares_RequestType()) !== false) {
    print_r($maintain->getResult());
} else {
    print_r($maintain->getLastError());
}
/**
 * Samples for Reassign ServiceType
 */
$reassign = new \ServiceType\Reassign($options);
$reassign->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Reassign_Expense_Credit_Card_Transaction operation/method
 */
if ($reassign->Reassign_Expense_Credit_Card_Transaction(new \StructType\Reassign_Expense_Credit_Card_Transaction_RequestType()) !== false) {
    print_r($reassign->getResult());
} else {
    print_r($reassign->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
$assign->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Assign_Expense_Central_Travel_Card_Transaction operation/method
 */
if ($assign->Assign_Expense_Central_Travel_Card_Transaction(new \StructType\Assign_Expense_Central_Travel_Card_Transaction_RequestType()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Change_Depreciation_Accounting_Status operation/method
 */
if ($change->Change_Depreciation_Accounting_Status(new \StructType\Change_Depreciation_Accounting_Status_RequestType()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for Change_Prepaid_Amortization_Type operation/method
 */
if ($change->Change_Prepaid_Amortization_Type(new \StructType\Change_Prepaid_Amortization_Type_RequestType()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for Change_Supplier_Invoice_On_Hold_Status operation/method
 */
if ($change->Change_Supplier_Invoice_On_Hold_Status(new \StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
$import->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Import_Supplier_Invoice operation/method
 */
if ($import->Import_Supplier_Invoice(new \StructType\Import_Supplier_Invoice_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Travel_Booking_Records operation/method
 */
if ($import->Import_Travel_Booking_Records(new \StructType\Travel_Booking_Header_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Credit_Card_Transactions operation/method
 */
if ($import->Import_Credit_Card_Transactions(new \StructType\Credit_Card_Transaction_Header__HV__RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Catalog_Load operation/method
 */
if ($import->Import_Catalog_Load(new \StructType\Import_Catalog_Load_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Credit_Cards operation/method
 */
if ($import->Import_Credit_Cards(new \StructType\Credit_Card_Header__HV__RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Guests operation/method
 */
if ($import->Import_Guests(new \StructType\Guest_Header__HV__RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Resource_Forecast operation/method
 */
if ($import->Import_Resource_Forecast(new \StructType\Import_Resource_Forecast_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Expense_Rate_Table operation/method
 */
if ($import->Import_Expense_Rate_Table(new \StructType\Expense_Rate_Table_Header__HV__RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Travel_Profiles operation/method
 */
if ($import->Import_Travel_Profiles(new \StructType\Worker_Travel_Profile_Header__HV__RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Supplier_Items operation/method
 */
if ($import->Import_Supplier_Items(new \StructType\Supplier_Item_Price_Update_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Purchase_Order_Close_Lines operation/method
 */
if ($import->Import_Purchase_Order_Close_Lines(new \StructType\Import_Purchase_Order_Close_Lines_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Bulk ServiceType
 */
$bulk = new \ServiceType\Bulk($options);
$bulk->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Bulk_Import_Submit_Supplier operation/method
 */
if ($bulk->Bulk_Import_Submit_Supplier(new \StructType\Bulk_Import_Submit_Supplier_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Adjust_Asset_Cost operation/method
 */
if ($bulk->Bulk_Import_Adjust_Asset_Cost(new \StructType\Bulk_Import_Adjust_Asset_Cost_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Asset_Book_Configuration operation/method
 */
if ($bulk->Bulk_Import_Asset_Book_Configuration(new \StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Transfer_Asset operation/method
 */
if ($bulk->Bulk_Import_Transfer_Asset(new \StructType\Bulk_Import_Transfer_Asset_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Dispose_Asset operation/method
 */
if ($bulk->Bulk_Import_Dispose_Asset(new \StructType\Bulk_Import_Dispose_Asset_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Submit_Remit_To_Supplier_Connection operation/method
 */
if ($bulk->Bulk_Import_Submit_Remit_To_Supplier_Connection(new \StructType\Bulk_Import_Submit_Remit_To_Supplier_Connection_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for Bulk_Import_Register_Asset operation/method
 */
if ($bulk->Bulk_Import_Register_Asset(new \StructType\Bulk_Import_Register_Asset_RequestType()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
