<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Item_Attributes_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Web Item Attributes Data Element
 * @subpackage Structs
 */
class Web_Item_Attributes_DataType extends AbstractStructBase
{
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the web item. This data is not used for inbound requests and any data provided in this element will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplier associated with the web item. This data is not used for inbound requests and any data provided in this element will be ignored.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The supplier's item identifier associated with the web item. This data is not used for inbound requests and any data provided in this element will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The spend category associated with the web item. This data is not used for inbound requests and any data provided in this element will be ignored.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: The purchase item linked to the web item.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ordering unit of measure of the web item. This data is not used for inbound requests and any data provided in this element will be ignored.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * Constructor method for Web_Item_Attributes_DataType
     * @uses Web_Item_Attributes_DataType::setItem_Description()
     * @uses Web_Item_Attributes_DataType::setSupplier_Reference()
     * @uses Web_Item_Attributes_DataType::setSupplier_Item_Identifier()
     * @uses Web_Item_Attributes_DataType::setSpend_Category_Reference()
     * @uses Web_Item_Attributes_DataType::setPurchase_Item_Reference()
     * @uses Web_Item_Attributes_DataType::setUnit_of_Measure_Reference()
     * @uses Web_Item_Attributes_DataType::setConversion_Factor()
     * @param string $item_Description
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param string $supplier_Item_Identifier
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $conversion_Factor
     */
    public function __construct($item_Description = null, \StructType\SupplierObjectType $supplier_Reference = null, $supplier_Item_Identifier = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $conversion_Factor = null)
    {
        $this
            ->setItem_Description($item_Description)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setConversion_Factor($conversion_Factor);
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Web_Item_Attributes_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
}
