<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Schedule_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Supplier Invoice Schedule Response Data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Supplier_Invoice_Schedule_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Schedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_ScheduleType[]
     */
    public $Supplier_Invoice_Schedule;
    /**
     * Constructor method for Supplier_Invoice_Schedule_Response_DataType
     * @uses Supplier_Invoice_Schedule_Response_DataType::setSupplier_Invoice_Schedule()
     * @param \StructType\Supplier_Invoice_ScheduleType[] $supplier_Invoice_Schedule
     */
    public function __construct(array $supplier_Invoice_Schedule = array())
    {
        $this
            ->setSupplier_Invoice_Schedule($supplier_Invoice_Schedule);
    }
    /**
     * Get Supplier_Invoice_Schedule value
     * @return \StructType\Supplier_Invoice_ScheduleType[]|null
     */
    public function getSupplier_Invoice_Schedule()
    {
        return $this->Supplier_Invoice_Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Schedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Schedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Schedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem instanceof \StructType\Supplier_Invoice_ScheduleType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem) ? get_class($supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem), var_export($supplier_Invoice_Schedule_Response_DataTypeSupplier_Invoice_ScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Schedule property can only contain items of type \StructType\Supplier_Invoice_ScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_ScheduleType[] $supplier_Invoice_Schedule
     * @return \StructType\Supplier_Invoice_Schedule_Response_DataType
     */
    public function setSupplier_Invoice_Schedule(array $supplier_Invoice_Schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_ScheduleArrayErrorMessage = self::validateSupplier_Invoice_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Schedule($supplier_Invoice_Schedule))) {
            throw new \InvalidArgumentException($supplier_Invoice_ScheduleArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Schedule = $supplier_Invoice_Schedule;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_ScheduleType $item
     * @return \StructType\Supplier_Invoice_Schedule_Response_DataType
     */
    public function addToSupplier_Invoice_Schedule(\StructType\Supplier_Invoice_ScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_ScheduleType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Schedule property can only contain items of type \StructType\Supplier_Invoice_ScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Schedule[] = $item;
        return $this;
    }
}
