<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Amendment_InformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Contract Amendment Information Data
 * @subpackage Structs
 */
class Supplier_Contract_Amendment_InformationType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Amendment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Type
     * @var \StructType\Supplier_Contract_Amendment_TypeObjectType
     */
    public $Supplier_Contract_Amendment_Type_Reference;
    /**
     * The Supplier_Contract_Lease_Amendment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Amendment Type for Lease Contract Amendment
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType
     */
    public $Supplier_Contract_Lease_Amendment_Type_Reference;
    /**
     * The Amendment_Date
     * Meta information extracted from the WSDL
     * - documentation: Amendment Date
     * - maxOccurs: 1
     * @var string
     */
    public $Amendment_Date;
    /**
     * The Amendment_Number
     * Meta information extracted from the WSDL
     * - documentation: Amendment Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amendment_Number;
    /**
     * The Amendment_Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the Amendment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amendment_Description;
    /**
     * The Amendment_Signed_Date
     * Meta information extracted from the WSDL
     * - documentation: Amendment Signed Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amendment_Signed_Date;
    /**
     * Constructor method for Supplier_Contract_Amendment_InformationType
     * @uses Supplier_Contract_Amendment_InformationType::setSupplier_Contract_Amendment_Type_Reference()
     * @uses Supplier_Contract_Amendment_InformationType::setSupplier_Contract_Lease_Amendment_Type_Reference()
     * @uses Supplier_Contract_Amendment_InformationType::setAmendment_Date()
     * @uses Supplier_Contract_Amendment_InformationType::setAmendment_Number()
     * @uses Supplier_Contract_Amendment_InformationType::setAmendment_Description()
     * @uses Supplier_Contract_Amendment_InformationType::setAmendment_Signed_Date()
     * @param \StructType\Supplier_Contract_Amendment_TypeObjectType $supplier_Contract_Amendment_Type_Reference
     * @param \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference
     * @param string $amendment_Date
     * @param string $amendment_Number
     * @param string $amendment_Description
     * @param string $amendment_Signed_Date
     */
    public function __construct(\StructType\Supplier_Contract_Amendment_TypeObjectType $supplier_Contract_Amendment_Type_Reference = null, \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference = null, $amendment_Date = null, $amendment_Number = null, $amendment_Description = null, $amendment_Signed_Date = null)
    {
        $this
            ->setSupplier_Contract_Amendment_Type_Reference($supplier_Contract_Amendment_Type_Reference)
            ->setSupplier_Contract_Lease_Amendment_Type_Reference($supplier_Contract_Lease_Amendment_Type_Reference)
            ->setAmendment_Date($amendment_Date)
            ->setAmendment_Number($amendment_Number)
            ->setAmendment_Description($amendment_Description)
            ->setAmendment_Signed_Date($amendment_Signed_Date);
    }
    /**
     * Get Supplier_Contract_Amendment_Type_Reference value
     * @return \StructType\Supplier_Contract_Amendment_TypeObjectType|null
     */
    public function getSupplier_Contract_Amendment_Type_Reference()
    {
        return $this->Supplier_Contract_Amendment_Type_Reference;
    }
    /**
     * Set Supplier_Contract_Amendment_Type_Reference value
     * @param \StructType\Supplier_Contract_Amendment_TypeObjectType $supplier_Contract_Amendment_Type_Reference
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setSupplier_Contract_Amendment_Type_Reference(\StructType\Supplier_Contract_Amendment_TypeObjectType $supplier_Contract_Amendment_Type_Reference = null)
    {
        $this->Supplier_Contract_Amendment_Type_Reference = $supplier_Contract_Amendment_Type_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Lease_Amendment_Type_Reference value
     * @return \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType|null
     */
    public function getSupplier_Contract_Lease_Amendment_Type_Reference()
    {
        return $this->Supplier_Contract_Lease_Amendment_Type_Reference;
    }
    /**
     * Set Supplier_Contract_Lease_Amendment_Type_Reference value
     * @param \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setSupplier_Contract_Lease_Amendment_Type_Reference(\StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference = null)
    {
        $this->Supplier_Contract_Lease_Amendment_Type_Reference = $supplier_Contract_Lease_Amendment_Type_Reference;
        return $this;
    }
    /**
     * Get Amendment_Date value
     * @return string|null
     */
    public function getAmendment_Date()
    {
        return $this->Amendment_Date;
    }
    /**
     * Set Amendment_Date value
     * @param string $amendment_Date
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setAmendment_Date($amendment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Date) && !is_string($amendment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Date, true), gettype($amendment_Date)), __LINE__);
        }
        $this->Amendment_Date = $amendment_Date;
        return $this;
    }
    /**
     * Get Amendment_Number value
     * @return string|null
     */
    public function getAmendment_Number()
    {
        return $this->Amendment_Number;
    }
    /**
     * Set Amendment_Number value
     * @param string $amendment_Number
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setAmendment_Number($amendment_Number = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Number) && !is_string($amendment_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Number, true), gettype($amendment_Number)), __LINE__);
        }
        $this->Amendment_Number = $amendment_Number;
        return $this;
    }
    /**
     * Get Amendment_Description value
     * @return string|null
     */
    public function getAmendment_Description()
    {
        return $this->Amendment_Description;
    }
    /**
     * Set Amendment_Description value
     * @param string $amendment_Description
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setAmendment_Description($amendment_Description = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Description) && !is_string($amendment_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Description, true), gettype($amendment_Description)), __LINE__);
        }
        $this->Amendment_Description = $amendment_Description;
        return $this;
    }
    /**
     * Get Amendment_Signed_Date value
     * @return string|null
     */
    public function getAmendment_Signed_Date()
    {
        return $this->Amendment_Signed_Date;
    }
    /**
     * Set Amendment_Signed_Date value
     * @param string $amendment_Signed_Date
     * @return \StructType\Supplier_Contract_Amendment_InformationType
     */
    public function setAmendment_Signed_Date($amendment_Signed_Date = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Signed_Date) && !is_string($amendment_Signed_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Signed_Date, true), gettype($amendment_Signed_Date)), __LINE__);
        }
        $this->Amendment_Signed_Date = $amendment_Signed_Date;
        return $this;
    }
}
