<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Catalog_Load_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request reference and response group for getting Catalog Load data
 * @subpackage Structs
 */
class Submit_Catalog_Load_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Catalog_Load_Data
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Data
     * @var \StructType\Catalog_Load_DataType
     */
    public $Catalog_Load_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Catalog_Load_RequestType
     * @uses Submit_Catalog_Load_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Catalog_Load_RequestType::setCatalog_Load_Data()
     * @uses Submit_Catalog_Load_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\Catalog_Load_DataType $catalog_Load_Data
     * @param string $version
     */
    public function __construct(array $business_Process_Parameters = array(), \StructType\Catalog_Load_DataType $catalog_Load_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setCatalog_Load_Data($catalog_Load_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem) ? get_class($submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem), var_export($submit_Catalog_Load_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Submit_Catalog_Load_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Submit_Catalog_Load_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Catalog_Load_Data value
     * @return \StructType\Catalog_Load_DataType|null
     */
    public function getCatalog_Load_Data()
    {
        return $this->Catalog_Load_Data;
    }
    /**
     * Set Catalog_Load_Data value
     * @param \StructType\Catalog_Load_DataType $catalog_Load_Data
     * @return \StructType\Submit_Catalog_Load_RequestType
     */
    public function setCatalog_Load_Data(\StructType\Catalog_Load_DataType $catalog_Load_Data = null)
    {
        $this->Catalog_Load_Data = $catalog_Load_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Catalog_Load_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
