<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Advanced_Ship_Notice_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Advanced Ship Notice reference for update, Advanced Ship Notice Business Processing Options, Flag to indicate if this operation is add only and all Advanced Ship Notice data items required to create a Advanced Ship
 * Notice.
 * @subpackage Structs
 */
class Submit_Advanced_Ship_Notice_RequestType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Advanced Ship Notice.
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_NoticeObjectType
     */
    public $Advanced_Ship_Notice_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Advanced_Ship_Notice_Data
     * Meta information extracted from the WSDL
     * - documentation: Advanced Ship Notice Data.
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public $Advanced_Ship_Notice_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Advanced_Ship_Notice_RequestType
     * @uses Submit_Advanced_Ship_Notice_RequestType::setAdvanced_Ship_Notice_Reference()
     * @uses Submit_Advanced_Ship_Notice_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Advanced_Ship_Notice_RequestType::setAdvanced_Ship_Notice_Data()
     * @uses Submit_Advanced_Ship_Notice_RequestType::setAdd_Only()
     * @uses Submit_Advanced_Ship_Notice_RequestType::setVersion()
     * @param \StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Advanced_Ship_Notice_Data_InboundType $advanced_Ship_Notice_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Advanced_Ship_Notice_Data_InboundType $advanced_Ship_Notice_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setAdvanced_Ship_Notice_Reference($advanced_Ship_Notice_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setAdvanced_Ship_Notice_Data($advanced_Ship_Notice_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Advanced_Ship_Notice_Reference value
     * @return \StructType\Advanced_Ship_NoticeObjectType|null
     */
    public function getAdvanced_Ship_Notice_Reference()
    {
        return $this->Advanced_Ship_Notice_Reference;
    }
    /**
     * Set Advanced_Ship_Notice_Reference value
     * @param \StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference
     * @return \StructType\Submit_Advanced_Ship_Notice_RequestType
     */
    public function setAdvanced_Ship_Notice_Reference(\StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference = null)
    {
        $this->Advanced_Ship_Notice_Reference = $advanced_Ship_Notice_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Advanced_Ship_Notice_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Advanced_Ship_Notice_Data value
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType|null
     */
    public function getAdvanced_Ship_Notice_Data()
    {
        return $this->Advanced_Ship_Notice_Data;
    }
    /**
     * Set Advanced_Ship_Notice_Data value
     * @param \StructType\Advanced_Ship_Notice_Data_InboundType $advanced_Ship_Notice_Data
     * @return \StructType\Submit_Advanced_Ship_Notice_RequestType
     */
    public function setAdvanced_Ship_Notice_Data(\StructType\Advanced_Ship_Notice_Data_InboundType $advanced_Ship_Notice_Data = null)
    {
        $this->Advanced_Ship_Notice_Data = $advanced_Ship_Notice_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Advanced_Ship_Notice_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Advanced_Ship_Notice_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
