<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Related_Worktag_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to the existing Allowed or Default Related Worktags.
 * @subpackage Structs
 */
class Related_Worktag_Widget_DataType extends AbstractStructBase
{
    /**
     * The Related_Worktags_by_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Allowed and Default Related Worktags Data by Worktag Type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Related_Worktags_by_Worktag_Type_DataType[]
     */
    public $Related_Worktags_by_Type_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: All existing related worktags (both allowed and default) are replaced with the ones specified in the request. It will supersede any "remove all" or delete option set to True by worktag type. When True, a default value must be
     * provided for all worktag types that are configured with 'Default Required' in the 'Maintain Related Worktag Usage'.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Related_Worktag_Widget_DataType
     * @uses Related_Worktag_Widget_DataType::setRelated_Worktags_by_Type_Data()
     * @uses Related_Worktag_Widget_DataType::setReplace_All()
     * @param \StructType\Related_Worktags_by_Worktag_Type_DataType[] $related_Worktags_by_Type_Data
     * @param bool $replace_All
     */
    public function __construct(array $related_Worktags_by_Type_Data = array(), $replace_All = null)
    {
        $this
            ->setRelated_Worktags_by_Type_Data($related_Worktags_by_Type_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Related_Worktags_by_Type_Data value
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType[]|null
     */
    public function getRelated_Worktags_by_Type_Data()
    {
        return $this->Related_Worktags_by_Type_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Worktags_by_Type_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Worktags_by_Type_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Worktags_by_Type_DataForArrayConstraintsFromSetRelated_Worktags_by_Type_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem) {
            // validation for constraint: itemType
            if (!$related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem instanceof \StructType\Related_Worktags_by_Worktag_Type_DataType) {
                $invalidValues[] = is_object($related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem) ? get_class($related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem) : sprintf('%s(%s)', gettype($related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem), var_export($related_Worktag_Widget_DataTypeRelated_Worktags_by_Type_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Worktags_by_Type_Data property can only contain items of type \StructType\Related_Worktags_by_Worktag_Type_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Worktags_by_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Worktags_by_Worktag_Type_DataType[] $related_Worktags_by_Type_Data
     * @return \StructType\Related_Worktag_Widget_DataType
     */
    public function setRelated_Worktags_by_Type_Data(array $related_Worktags_by_Type_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Worktags_by_Type_DataArrayErrorMessage = self::validateRelated_Worktags_by_Type_DataForArrayConstraintsFromSetRelated_Worktags_by_Type_Data($related_Worktags_by_Type_Data))) {
            throw new \InvalidArgumentException($related_Worktags_by_Type_DataArrayErrorMessage, __LINE__);
        }
        $this->Related_Worktags_by_Type_Data = $related_Worktags_by_Type_Data;
        return $this;
    }
    /**
     * Add item to Related_Worktags_by_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Worktags_by_Worktag_Type_DataType $item
     * @return \StructType\Related_Worktag_Widget_DataType
     */
    public function addToRelated_Worktags_by_Type_Data(\StructType\Related_Worktags_by_Worktag_Type_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Related_Worktags_by_Worktag_Type_DataType) {
            throw new \InvalidArgumentException(sprintf('The Related_Worktags_by_Type_Data property can only contain items of type \StructType\Related_Worktags_by_Worktag_Type_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Worktags_by_Type_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Related_Worktag_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
