<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Phase_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Put operation.
 * @subpackage Structs
 */
class Put_Project_Phase_RequestType extends AbstractStructBase
{
    /**
     * The Project_Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Phase Reference
     * - minOccurs: 0
     * @var \StructType\Project_PhaseObjectType
     */
    public $Project_Phase_Reference;
    /**
     * The Project_Phase_Data
     * @var \StructType\Project_Phase_DataType
     */
    public $Project_Phase_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Phase_RequestType
     * @uses Put_Project_Phase_RequestType::setProject_Phase_Reference()
     * @uses Put_Project_Phase_RequestType::setProject_Phase_Data()
     * @uses Put_Project_Phase_RequestType::setAdd_Only()
     * @uses Put_Project_Phase_RequestType::setVersion()
     * @param \StructType\Project_PhaseObjectType $project_Phase_Reference
     * @param \StructType\Project_Phase_DataType $project_Phase_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_PhaseObjectType $project_Phase_Reference = null, \StructType\Project_Phase_DataType $project_Phase_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Phase_Reference($project_Phase_Reference)
            ->setProject_Phase_Data($project_Phase_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Phase_Reference value
     * @return \StructType\Project_PhaseObjectType|null
     */
    public function getProject_Phase_Reference()
    {
        return $this->Project_Phase_Reference;
    }
    /**
     * Set Project_Phase_Reference value
     * @param \StructType\Project_PhaseObjectType $project_Phase_Reference
     * @return \StructType\Put_Project_Phase_RequestType
     */
    public function setProject_Phase_Reference(\StructType\Project_PhaseObjectType $project_Phase_Reference = null)
    {
        $this->Project_Phase_Reference = $project_Phase_Reference;
        return $this;
    }
    /**
     * Get Project_Phase_Data value
     * @return \StructType\Project_Phase_DataType|null
     */
    public function getProject_Phase_Data()
    {
        return $this->Project_Phase_Data;
    }
    /**
     * Set Project_Phase_Data value
     * @param \StructType\Project_Phase_DataType $project_Phase_Data
     * @return \StructType\Put_Project_Phase_RequestType
     */
    public function setProject_Phase_Data(\StructType\Project_Phase_DataType $project_Phase_Data = null)
    {
        $this->Project_Phase_Data = $project_Phase_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Phase_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Phase_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
