<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Template_Outbound_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Request Template
 * @subpackage Structs
 */
class Purchase_Item_Request_Template_Outbound_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_TemplateObjectType
     */
    public $Purchase_Item_Request_Template_Reference;
    /**
     * The Purchase_Item_Request_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Template_DataType[]
     */
    public $Purchase_Item_Request_Template_Data;
    /**
     * Constructor method for Purchase_Item_Request_Template_Outbound_DataType
     * @uses Purchase_Item_Request_Template_Outbound_DataType::setPurchase_Item_Request_Template_Reference()
     * @uses Purchase_Item_Request_Template_Outbound_DataType::setPurchase_Item_Request_Template_Data()
     * @param \StructType\Purchase_Item_Request_TemplateObjectType $purchase_Item_Request_Template_Reference
     * @param \StructType\Purchase_Item_Request_Template_DataType[] $purchase_Item_Request_Template_Data
     */
    public function __construct(\StructType\Purchase_Item_Request_TemplateObjectType $purchase_Item_Request_Template_Reference = null, array $purchase_Item_Request_Template_Data = array())
    {
        $this
            ->setPurchase_Item_Request_Template_Reference($purchase_Item_Request_Template_Reference)
            ->setPurchase_Item_Request_Template_Data($purchase_Item_Request_Template_Data);
    }
    /**
     * Get Purchase_Item_Request_Template_Reference value
     * @return \StructType\Purchase_Item_Request_TemplateObjectType|null
     */
    public function getPurchase_Item_Request_Template_Reference()
    {
        return $this->Purchase_Item_Request_Template_Reference;
    }
    /**
     * Set Purchase_Item_Request_Template_Reference value
     * @param \StructType\Purchase_Item_Request_TemplateObjectType $purchase_Item_Request_Template_Reference
     * @return \StructType\Purchase_Item_Request_Template_Outbound_DataType
     */
    public function setPurchase_Item_Request_Template_Reference(\StructType\Purchase_Item_Request_TemplateObjectType $purchase_Item_Request_Template_Reference = null)
    {
        $this->Purchase_Item_Request_Template_Reference = $purchase_Item_Request_Template_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Request_Template_Data value
     * @return \StructType\Purchase_Item_Request_Template_DataType[]|null
     */
    public function getPurchase_Item_Request_Template_Data()
    {
        return $this->Purchase_Item_Request_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_Template_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem instanceof \StructType\Purchase_Item_Request_Template_DataType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem) ? get_class($purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem), var_export($purchase_Item_Request_Template_Outbound_DataTypePurchase_Item_Request_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Template_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_DataType[] $purchase_Item_Request_Template_Data
     * @return \StructType\Purchase_Item_Request_Template_Outbound_DataType
     */
    public function setPurchase_Item_Request_Template_Data(array $purchase_Item_Request_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_Template_DataArrayErrorMessage = self::validatePurchase_Item_Request_Template_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Data($purchase_Item_Request_Template_Data))) {
            throw new \InvalidArgumentException($purchase_Item_Request_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Template_Data = $purchase_Item_Request_Template_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_DataType $item
     * @return \StructType\Purchase_Item_Request_Template_Outbound_DataType
     */
    public function addToPurchase_Item_Request_Template_Data(\StructType\Purchase_Item_Request_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Template_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Template_Data[] = $item;
        return $this;
    }
}
