<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Company_Default_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Expense Company Default Instance and Data
 * @subpackage Structs
 */
class Expense_Company_Default_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Company_Default
     * Meta information extracted from the WSDL
     * - documentation: Expense Company Default
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Company_DefaultType[]
     */
    public $Expense_Company_Default;
    /**
     * Constructor method for Expense_Company_Default_Response_DataType
     * @uses Expense_Company_Default_Response_DataType::setExpense_Company_Default()
     * @param \StructType\Expense_Company_DefaultType[] $expense_Company_Default
     */
    public function __construct(array $expense_Company_Default = array())
    {
        $this
            ->setExpense_Company_Default($expense_Company_Default);
    }
    /**
     * Get Expense_Company_Default value
     * @return \StructType\Expense_Company_DefaultType[]|null
     */
    public function getExpense_Company_Default()
    {
        return $this->Expense_Company_Default;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Company_Default method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Company_Default method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Company_DefaultForArrayConstraintsFromSetExpense_Company_Default(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem) {
            // validation for constraint: itemType
            if (!$expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem instanceof \StructType\Expense_Company_DefaultType) {
                $invalidValues[] = is_object($expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem) ? get_class($expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem) : sprintf('%s(%s)', gettype($expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem), var_export($expense_Company_Default_Response_DataTypeExpense_Company_DefaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Company_Default property can only contain items of type \StructType\Expense_Company_DefaultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Company_Default value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Company_DefaultType[] $expense_Company_Default
     * @return \StructType\Expense_Company_Default_Response_DataType
     */
    public function setExpense_Company_Default(array $expense_Company_Default = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Company_DefaultArrayErrorMessage = self::validateExpense_Company_DefaultForArrayConstraintsFromSetExpense_Company_Default($expense_Company_Default))) {
            throw new \InvalidArgumentException($expense_Company_DefaultArrayErrorMessage, __LINE__);
        }
        $this->Expense_Company_Default = $expense_Company_Default;
        return $this;
    }
    /**
     * Add item to Expense_Company_Default value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Company_DefaultType $item
     * @return \StructType\Expense_Company_Default_Response_DataType
     */
    public function addToExpense_Company_Default(\StructType\Expense_Company_DefaultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Company_DefaultType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Company_Default property can only contain items of type \StructType\Expense_Company_DefaultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Company_Default[] = $item;
        return $this;
    }
}
