<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dispose_Asset_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to process the asset disposal.
 * @subpackage Structs
 */
class Dispose_Asset_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can only dispose an asset that is In Service, Issued, Registered, or Out of Service. If you register an asset from a lease type supplier contract, the contract must be cancelled or the asset fully depreciated. You can't dispose
     * an asset that is a Discrete Composite Asset. | A reference to the asset that should be disposed.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The transaction effective date for the asset disposal.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Disposal_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the type of disposal.
     * @var \StructType\Asset_Disposal_TypeObjectType
     */
    public $Disposal_Type_Reference;
    /**
     * The Percent_to_Dispose
     * Meta information extracted from the WSDL
     * - documentation: The percent of asset total cost to dispose. Valid values between 1 and 100. If percent to dispose is 0 and cost to dispose is 0, percent to dispose will be set 100.
     * - base: xsd:decimal
     * - fractionDigits: 16
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 19
     * @var float
     */
    public $Percent_to_Dispose;
    /**
     * The Cost_to_Dispose
     * Meta information extracted from the WSDL
     * - documentation: The cost from total asset cost to dispose. | The cost to dispose entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Cost_to_Dispose;
    /**
     * The Disposal_Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Fair Market Value for the Disposal transaction that this Reinstatement is linked to. | The fair market value of the asset at the time it was disposed. | The fair market value of the asset at the time of disposal. | The
     * disposal fair market value entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Fair_Market_Value;
    /**
     * The Sale_Price
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Sale Price for the Disposal transaction that this Reinstatement is linked to. | The sale price, if the asset was sold as part of the disposal activity. | The sale price (if the Disposal Type was Sale) when the asset was
     * sold. | The sale price entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Sale_Price;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: Free-form comments to include with the disposal event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: A list of worktags to track with the disposal event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * Constructor method for Dispose_Asset_DataType
     * @uses Dispose_Asset_DataType::setAsset_Reference()
     * @uses Dispose_Asset_DataType::setTransaction_Effective_Date()
     * @uses Dispose_Asset_DataType::setDisposal_Type_Reference()
     * @uses Dispose_Asset_DataType::setPercent_to_Dispose()
     * @uses Dispose_Asset_DataType::setCost_to_Dispose()
     * @uses Dispose_Asset_DataType::setDisposal_Fair_Market_Value()
     * @uses Dispose_Asset_DataType::setSale_Price()
     * @uses Dispose_Asset_DataType::setComments()
     * @uses Dispose_Asset_DataType::setWorktag_Reference()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @param float $percent_to_Dispose
     * @param float $cost_to_Dispose
     * @param float $disposal_Fair_Market_Value
     * @param float $sale_Price
     * @param string $comments
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $transaction_Effective_Date = null, \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null, $percent_to_Dispose = null, $cost_to_Dispose = null, $disposal_Fair_Market_Value = null, $sale_Price = null, $comments = null, array $worktag_Reference = array())
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setDisposal_Type_Reference($disposal_Type_Reference)
            ->setPercent_to_Dispose($percent_to_Dispose)
            ->setCost_to_Dispose($cost_to_Dispose)
            ->setDisposal_Fair_Market_Value($disposal_Fair_Market_Value)
            ->setSale_Price($sale_Price)
            ->setComments($comments)
            ->setWorktag_Reference($worktag_Reference);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Disposal_Type_Reference value
     * @return \StructType\Asset_Disposal_TypeObjectType|null
     */
    public function getDisposal_Type_Reference()
    {
        return $this->Disposal_Type_Reference;
    }
    /**
     * Set Disposal_Type_Reference value
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setDisposal_Type_Reference(\StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null)
    {
        $this->Disposal_Type_Reference = $disposal_Type_Reference;
        return $this;
    }
    /**
     * Get Percent_to_Dispose value
     * @return float|null
     */
    public function getPercent_to_Dispose()
    {
        return $this->Percent_to_Dispose;
    }
    /**
     * Set Percent_to_Dispose value
     * @param float $percent_to_Dispose
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setPercent_to_Dispose($percent_to_Dispose = null)
    {
        // validation for constraint: float
        if (!is_null($percent_to_Dispose) && !(is_float($percent_to_Dispose) || is_numeric($percent_to_Dispose))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_to_Dispose, true), gettype($percent_to_Dispose)), __LINE__);
        }
        // validation for constraint: fractionDigits(16)
        if (!is_null($percent_to_Dispose) && mb_strlen(mb_substr($percent_to_Dispose, false !== mb_strpos($percent_to_Dispose, '.') ? mb_strpos($percent_to_Dispose, '.') + 1 : mb_strlen($percent_to_Dispose))) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 16 fraction digits, %d given', var_export($percent_to_Dispose, true), mb_strlen(mb_substr($percent_to_Dispose, mb_strpos($percent_to_Dispose, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_to_Dispose) && $percent_to_Dispose < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_to_Dispose, true)), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($percent_to_Dispose) && mb_strlen(preg_replace('/(\D)/', '', $percent_to_Dispose)) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($percent_to_Dispose, true), mb_strlen(preg_replace('/(\D)/', '', $percent_to_Dispose))), __LINE__);
        }
        $this->Percent_to_Dispose = $percent_to_Dispose;
        return $this;
    }
    /**
     * Get Cost_to_Dispose value
     * @return float|null
     */
    public function getCost_to_Dispose()
    {
        return $this->Cost_to_Dispose;
    }
    /**
     * Set Cost_to_Dispose value
     * @param float $cost_to_Dispose
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setCost_to_Dispose($cost_to_Dispose = null)
    {
        // validation for constraint: float
        if (!is_null($cost_to_Dispose) && !(is_float($cost_to_Dispose) || is_numeric($cost_to_Dispose))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost_to_Dispose, true), gettype($cost_to_Dispose)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($cost_to_Dispose) && mb_strlen(mb_substr($cost_to_Dispose, false !== mb_strpos($cost_to_Dispose, '.') ? mb_strpos($cost_to_Dispose, '.') + 1 : mb_strlen($cost_to_Dispose))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($cost_to_Dispose, true), mb_strlen(mb_substr($cost_to_Dispose, mb_strpos($cost_to_Dispose, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($cost_to_Dispose) && mb_strlen(preg_replace('/(\D)/', '', $cost_to_Dispose)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($cost_to_Dispose, true), mb_strlen(preg_replace('/(\D)/', '', $cost_to_Dispose))), __LINE__);
        }
        $this->Cost_to_Dispose = $cost_to_Dispose;
        return $this;
    }
    /**
     * Get Disposal_Fair_Market_Value value
     * @return float|null
     */
    public function getDisposal_Fair_Market_Value()
    {
        return $this->Disposal_Fair_Market_Value;
    }
    /**
     * Set Disposal_Fair_Market_Value value
     * @param float $disposal_Fair_Market_Value
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setDisposal_Fair_Market_Value($disposal_Fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Fair_Market_Value) && !(is_float($disposal_Fair_Market_Value) || is_numeric($disposal_Fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Fair_Market_Value, true), gettype($disposal_Fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(mb_substr($disposal_Fair_Market_Value, false !== mb_strpos($disposal_Fair_Market_Value, '.') ? mb_strpos($disposal_Fair_Market_Value, '.') + 1 : mb_strlen($disposal_Fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Fair_Market_Value, true), mb_strlen(mb_substr($disposal_Fair_Market_Value, mb_strpos($disposal_Fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value))), __LINE__);
        }
        $this->Disposal_Fair_Market_Value = $disposal_Fair_Market_Value;
        return $this;
    }
    /**
     * Get Sale_Price value
     * @return float|null
     */
    public function getSale_Price()
    {
        return $this->Sale_Price;
    }
    /**
     * Set Sale_Price value
     * @param float $sale_Price
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setSale_Price($sale_Price = null)
    {
        // validation for constraint: float
        if (!is_null($sale_Price) && !(is_float($sale_Price) || is_numeric($sale_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sale_Price, true), gettype($sale_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($sale_Price) && mb_strlen(mb_substr($sale_Price, false !== mb_strpos($sale_Price, '.') ? mb_strpos($sale_Price, '.') + 1 : mb_strlen($sale_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($sale_Price, true), mb_strlen(mb_substr($sale_Price, mb_strpos($sale_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($sale_Price) && mb_strlen(preg_replace('/(\D)/', '', $sale_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($sale_Price, true), mb_strlen(preg_replace('/(\D)/', '', $sale_Price))), __LINE__);
        }
        $this->Sale_Price = $sale_Price;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dispose_Asset_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$dispose_Asset_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($dispose_Asset_DataTypeWorktag_ReferenceItem) ? get_class($dispose_Asset_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($dispose_Asset_DataTypeWorktag_ReferenceItem), var_export($dispose_Asset_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Dispose_Asset_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Dispose_Asset_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
}
