<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulates all the data for a single Asset.
 * @subpackage Structs
 */
class Asset_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the Asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Reference_ID;
    /**
     * The Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: The primary ID of this asset. This is a unique ID that can be used to identify this asset instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Company this asset belongs to.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The base currency for the company this asset belongs to.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The Asset_Description
     * Meta information extracted from the WSDL
     * - documentation: A text description of the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Description;
    /**
     * The Asset_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the current status of the asset.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Asset_Status_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Spend Category this asset belongs to.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Total_Asset_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Asset Cost | The total asset cost entered has too many digits beyond the decimal point | The current total cost of this asset. | This field is for display only, any values updated will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Asset_Cost;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Quantity;
    /**
     * The Quantity_Available
     * Meta information extracted from the WSDL
     * - documentation: Units available
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Quantity_Available;
    /**
     * The Residual_Value
     * Meta information extracted from the WSDL
     * - documentation: Residual or salvage value | Residual value cannot be greater than acquisition (unit) cost. | The residual value entered has too many digits beyond the decimal point | The current residual value of this asset. | Residual or salvage
     * value for the specified Book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Residual_Value;
    /**
     * The Date_Placed_In_Service
     * Meta information extracted from the WSDL
     * - documentation: The date this asset was placed in service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Placed_In_Service;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Accounting Treatment used for this asset.
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The asset identifier for this asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Serial_Number
     * Meta information extracted from the WSDL
     * - documentation: The serial number assigned to this asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Number;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: The manufacturer for the Asset, as a text value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Class for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Type for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Business_Use_Percentage
     * Meta information extracted from the WSDL
     * - documentation: The Business Use % for the asset. If left empty, will default to 100. | Business Use Percentage | The Business Use Percentage for this asset, as a number from 1 to 100.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Business_Use_Percentage;
    /**
     * The Coordinating_Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: References the coordinating cost center for reporting only.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Coordinating_Cost_Center_Reference;
    /**
     * The Asset_Coordinator_Reference
     * Meta information extracted from the WSDL
     * - documentation: References the asset coordinator for reporting only.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Asset_Coordinator_Reference;
    /**
     * The Related_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to other assets that are related to this one.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Related_Asset_Reference;
    /**
     * The Event_In_Progress
     * Meta information extracted from the WSDL
     * - documentation: A boolean returning True if the asset has an event in progress.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Event_In_Progress;
    /**
     * The Asset_Share_Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Share_Response_DataType[]
     */
    public $Asset_Share_Reference;
    /**
     * The Acquisition_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Acquisition_WWS_DataType[]
     */
    public $Acquisition_Data;
    /**
     * The Custodian_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Custodian_WWS_DataType[]
     */
    public $Custodian_Data;
    /**
     * The Asset_Component_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Components_WWS_DataType[]
     */
    public $Asset_Component_Data;
    /**
     * The Depreciation_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_WWS_DataType[]
     */
    public $Depreciation_Data;
    /**
     * The Disposal_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Disposal_WWS_DataType[]
     */
    public $Disposal_Data;
    /**
     * The Depreciation_Detail_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_Detail_DataType[]
     */
    public $Depreciation_Detail_Data;
    /**
     * The Reinstatement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Reinstatement_WWS_DataType[]
     */
    public $Reinstatement_Data;
    /**
     * The Intercompany_Transfer_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Intercompany_Transfer_WWS_DataType[]
     */
    public $Intercompany_Transfer_Data;
    /**
     * The Impairment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Impairment_WWS_DataType[]
     */
    public $Impairment_Data;
    /**
     * The In_Service_Schedule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_In_Service_Schedule_WWS_DataType[]
     */
    public $In_Service_Schedule_Data;
    /**
     * The Cost_Adjustment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Cost_Adjustment_WWS_DataType[]
     */
    public $Cost_Adjustment_Data;
    /**
     * The Reclassification_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Reclassification_WWS_DataType[]
     */
    public $Reclassification_Data;
    /**
     * The Removal_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Removal_WWS_DataType[]
     */
    public $Removal_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Asset_DataType
     * @uses Asset_DataType::setAsset_Reference_ID()
     * @uses Asset_DataType::setAsset_ID()
     * @uses Asset_DataType::setCompany_Reference()
     * @uses Asset_DataType::setCurrency_Reference()
     * @uses Asset_DataType::setAsset_Name()
     * @uses Asset_DataType::setAsset_Description()
     * @uses Asset_DataType::setAsset_Status_Reference()
     * @uses Asset_DataType::setSpend_Category_Reference()
     * @uses Asset_DataType::setTotal_Asset_Cost()
     * @uses Asset_DataType::setQuantity()
     * @uses Asset_DataType::setQuantity_Available()
     * @uses Asset_DataType::setResidual_Value()
     * @uses Asset_DataType::setDate_Placed_In_Service()
     * @uses Asset_DataType::setAccounting_Treatment_Reference()
     * @uses Asset_DataType::setAsset_Identifier()
     * @uses Asset_DataType::setSerial_Number()
     * @uses Asset_DataType::setManufacturer()
     * @uses Asset_DataType::setAsset_Class_Reference()
     * @uses Asset_DataType::setAsset_Type_Reference()
     * @uses Asset_DataType::setBusiness_Use_Percentage()
     * @uses Asset_DataType::setCoordinating_Cost_Center_Reference()
     * @uses Asset_DataType::setAsset_Coordinator_Reference()
     * @uses Asset_DataType::setRelated_Asset_Reference()
     * @uses Asset_DataType::setEvent_In_Progress()
     * @uses Asset_DataType::setAsset_Share_Reference()
     * @uses Asset_DataType::setAcquisition_Data()
     * @uses Asset_DataType::setCustodian_Data()
     * @uses Asset_DataType::setAsset_Component_Data()
     * @uses Asset_DataType::setDepreciation_Data()
     * @uses Asset_DataType::setDisposal_Data()
     * @uses Asset_DataType::setDepreciation_Detail_Data()
     * @uses Asset_DataType::setReinstatement_Data()
     * @uses Asset_DataType::setIntercompany_Transfer_Data()
     * @uses Asset_DataType::setImpairment_Data()
     * @uses Asset_DataType::setIn_Service_Schedule_Data()
     * @uses Asset_DataType::setCost_Adjustment_Data()
     * @uses Asset_DataType::setReclassification_Data()
     * @uses Asset_DataType::setRemoval_Data()
     * @uses Asset_DataType::setAttachment_Data()
     * @param string $asset_Reference_ID
     * @param string $asset_ID
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $asset_Name
     * @param string $asset_Description
     * @param \StructType\Document_StatusObjectType $asset_Status_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param float $total_Asset_Cost
     * @param float $quantity
     * @param float $quantity_Available
     * @param float $residual_Value
     * @param string $date_Placed_In_Service
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param string $asset_Identifier
     * @param string $serial_Number
     * @param string $manufacturer
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param float $business_Use_Percentage
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @param \StructType\Business_AssetObjectType[] $related_Asset_Reference
     * @param bool $event_In_Progress
     * @param \StructType\Asset_Share_Response_DataType[] $asset_Share_Reference
     * @param \StructType\Asset_Acquisition_WWS_DataType[] $acquisition_Data
     * @param \StructType\Asset_Custodian_WWS_DataType[] $custodian_Data
     * @param \StructType\Asset_Components_WWS_DataType[] $asset_Component_Data
     * @param \StructType\Asset_Depreciation_WWS_DataType[] $depreciation_Data
     * @param \StructType\Asset_Disposal_WWS_DataType[] $disposal_Data
     * @param \StructType\Asset_Depreciation_Detail_DataType[] $depreciation_Detail_Data
     * @param \StructType\Asset_Reinstatement_WWS_DataType[] $reinstatement_Data
     * @param \StructType\Asset_Intercompany_Transfer_WWS_DataType[] $intercompany_Transfer_Data
     * @param \StructType\Asset_Impairment_WWS_DataType[] $impairment_Data
     * @param \StructType\Asset_In_Service_Schedule_WWS_DataType[] $in_Service_Schedule_Data
     * @param \StructType\Asset_Cost_Adjustment_WWS_DataType[] $cost_Adjustment_Data
     * @param \StructType\Asset_Reclassification_WWS_DataType[] $reclassification_Data
     * @param \StructType\Asset_Removal_WWS_DataType[] $removal_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct($asset_Reference_ID = null, $asset_ID = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $asset_Name = null, $asset_Description = null, \StructType\Document_StatusObjectType $asset_Status_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $total_Asset_Cost = null, $quantity = null, $quantity_Available = null, $residual_Value = null, $date_Placed_In_Service = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, $asset_Identifier = null, $serial_Number = null, $manufacturer = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, $business_Use_Percentage = null, \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null, \StructType\WorkerObjectType $asset_Coordinator_Reference = null, array $related_Asset_Reference = array(), $event_In_Progress = null, array $asset_Share_Reference = array(), array $acquisition_Data = array(), array $custodian_Data = array(), array $asset_Component_Data = array(), array $depreciation_Data = array(), array $disposal_Data = array(), array $depreciation_Detail_Data = array(), array $reinstatement_Data = array(), array $intercompany_Transfer_Data = array(), array $impairment_Data = array(), array $in_Service_Schedule_Data = array(), array $cost_Adjustment_Data = array(), array $reclassification_Data = array(), array $removal_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setAsset_Reference_ID($asset_Reference_ID)
            ->setAsset_ID($asset_ID)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setAsset_Name($asset_Name)
            ->setAsset_Description($asset_Description)
            ->setAsset_Status_Reference($asset_Status_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setTotal_Asset_Cost($total_Asset_Cost)
            ->setQuantity($quantity)
            ->setQuantity_Available($quantity_Available)
            ->setResidual_Value($residual_Value)
            ->setDate_Placed_In_Service($date_Placed_In_Service)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setAsset_Identifier($asset_Identifier)
            ->setSerial_Number($serial_Number)
            ->setManufacturer($manufacturer)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setBusiness_Use_Percentage($business_Use_Percentage)
            ->setCoordinating_Cost_Center_Reference($coordinating_Cost_Center_Reference)
            ->setAsset_Coordinator_Reference($asset_Coordinator_Reference)
            ->setRelated_Asset_Reference($related_Asset_Reference)
            ->setEvent_In_Progress($event_In_Progress)
            ->setAsset_Share_Reference($asset_Share_Reference)
            ->setAcquisition_Data($acquisition_Data)
            ->setCustodian_Data($custodian_Data)
            ->setAsset_Component_Data($asset_Component_Data)
            ->setDepreciation_Data($depreciation_Data)
            ->setDisposal_Data($disposal_Data)
            ->setDepreciation_Detail_Data($depreciation_Detail_Data)
            ->setReinstatement_Data($reinstatement_Data)
            ->setIntercompany_Transfer_Data($intercompany_Transfer_Data)
            ->setImpairment_Data($impairment_Data)
            ->setIn_Service_Schedule_Data($in_Service_Schedule_Data)
            ->setCost_Adjustment_Data($cost_Adjustment_Data)
            ->setReclassification_Data($reclassification_Data)
            ->setRemoval_Data($removal_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Asset_Reference_ID value
     * @return string|null
     */
    public function getAsset_Reference_ID()
    {
        return $this->Asset_Reference_ID;
    }
    /**
     * Set Asset_Reference_ID value
     * @param string $asset_Reference_ID
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Reference_ID($asset_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Reference_ID) && !is_string($asset_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Reference_ID, true), gettype($asset_Reference_ID)), __LINE__);
        }
        $this->Asset_Reference_ID = $asset_Reference_ID;
        return $this;
    }
    /**
     * Get Asset_ID value
     * @return string|null
     */
    public function getAsset_ID()
    {
        return $this->Asset_ID;
    }
    /**
     * Set Asset_ID value
     * @param string $asset_ID
     * @return \StructType\Asset_DataType
     */
    public function setAsset_ID($asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($asset_ID) && !is_string($asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_ID, true), gettype($asset_ID)), __LINE__);
        }
        $this->Asset_ID = $asset_ID;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Asset_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Asset_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get Asset_Description value
     * @return string|null
     */
    public function getAsset_Description()
    {
        return $this->Asset_Description;
    }
    /**
     * Set Asset_Description value
     * @param string $asset_Description
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Description($asset_Description = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Description) && !is_string($asset_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Description, true), gettype($asset_Description)), __LINE__);
        }
        $this->Asset_Description = $asset_Description;
        return $this;
    }
    /**
     * Get Asset_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getAsset_Status_Reference()
    {
        return $this->Asset_Status_Reference;
    }
    /**
     * Set Asset_Status_Reference value
     * @param \StructType\Document_StatusObjectType $asset_Status_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Status_Reference(\StructType\Document_StatusObjectType $asset_Status_Reference = null)
    {
        $this->Asset_Status_Reference = $asset_Status_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Asset_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Total_Asset_Cost value
     * @return float|null
     */
    public function getTotal_Asset_Cost()
    {
        return $this->Total_Asset_Cost;
    }
    /**
     * Set Total_Asset_Cost value
     * @param float $total_Asset_Cost
     * @return \StructType\Asset_DataType
     */
    public function setTotal_Asset_Cost($total_Asset_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Asset_Cost) && !(is_float($total_Asset_Cost) || is_numeric($total_Asset_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Asset_Cost, true), gettype($total_Asset_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Asset_Cost) && mb_strlen(mb_substr($total_Asset_Cost, false !== mb_strpos($total_Asset_Cost, '.') ? mb_strpos($total_Asset_Cost, '.') + 1 : mb_strlen($total_Asset_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Asset_Cost, true), mb_strlen(mb_substr($total_Asset_Cost, mb_strpos($total_Asset_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Asset_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Asset_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost))), __LINE__);
        }
        $this->Total_Asset_Cost = $total_Asset_Cost;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Asset_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($quantity) && $quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Quantity_Available value
     * @return float|null
     */
    public function getQuantity_Available()
    {
        return $this->Quantity_Available;
    }
    /**
     * Set Quantity_Available value
     * @param float $quantity_Available
     * @return \StructType\Asset_DataType
     */
    public function setQuantity_Available($quantity_Available = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_Available) && !(is_float($quantity_Available) || is_numeric($quantity_Available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_Available, true), gettype($quantity_Available)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($quantity_Available) && mb_strlen(mb_substr($quantity_Available, false !== mb_strpos($quantity_Available, '.') ? mb_strpos($quantity_Available, '.') + 1 : mb_strlen($quantity_Available))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($quantity_Available, true), mb_strlen(mb_substr($quantity_Available, mb_strpos($quantity_Available, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($quantity_Available) && $quantity_Available < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($quantity_Available, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity_Available) && mb_strlen(preg_replace('/(\D)/', '', $quantity_Available)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity_Available, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_Available))), __LINE__);
        }
        $this->Quantity_Available = $quantity_Available;
        return $this;
    }
    /**
     * Get Residual_Value value
     * @return float|null
     */
    public function getResidual_Value()
    {
        return $this->Residual_Value;
    }
    /**
     * Set Residual_Value value
     * @param float $residual_Value
     * @return \StructType\Asset_DataType
     */
    public function setResidual_Value($residual_Value = null)
    {
        // validation for constraint: float
        if (!is_null($residual_Value) && !(is_float($residual_Value) || is_numeric($residual_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($residual_Value, true), gettype($residual_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($residual_Value) && mb_strlen(mb_substr($residual_Value, false !== mb_strpos($residual_Value, '.') ? mb_strpos($residual_Value, '.') + 1 : mb_strlen($residual_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($residual_Value, true), mb_strlen(mb_substr($residual_Value, mb_strpos($residual_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($residual_Value) && mb_strlen(preg_replace('/(\D)/', '', $residual_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($residual_Value, true), mb_strlen(preg_replace('/(\D)/', '', $residual_Value))), __LINE__);
        }
        $this->Residual_Value = $residual_Value;
        return $this;
    }
    /**
     * Get Date_Placed_In_Service value
     * @return string|null
     */
    public function getDate_Placed_In_Service()
    {
        return $this->Date_Placed_In_Service;
    }
    /**
     * Set Date_Placed_In_Service value
     * @param string $date_Placed_In_Service
     * @return \StructType\Asset_DataType
     */
    public function setDate_Placed_In_Service($date_Placed_In_Service = null)
    {
        // validation for constraint: string
        if (!is_null($date_Placed_In_Service) && !is_string($date_Placed_In_Service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Placed_In_Service, true), gettype($date_Placed_In_Service)), __LINE__);
        }
        $this->Date_Placed_In_Service = $date_Placed_In_Service;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Serial_Number value
     * @return string|null
     */
    public function getSerial_Number()
    {
        return $this->Serial_Number;
    }
    /**
     * Set Serial_Number value
     * @param string $serial_Number
     * @return \StructType\Asset_DataType
     */
    public function setSerial_Number($serial_Number = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Number) && !is_string($serial_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Number, true), gettype($serial_Number)), __LINE__);
        }
        $this->Serial_Number = $serial_Number;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\Asset_DataType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Business_Use_Percentage value
     * @return float|null
     */
    public function getBusiness_Use_Percentage()
    {
        return $this->Business_Use_Percentage;
    }
    /**
     * Set Business_Use_Percentage value
     * @param float $business_Use_Percentage
     * @return \StructType\Asset_DataType
     */
    public function setBusiness_Use_Percentage($business_Use_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($business_Use_Percentage) && !(is_float($business_Use_Percentage) || is_numeric($business_Use_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($business_Use_Percentage, true), gettype($business_Use_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($business_Use_Percentage) && mb_strlen(mb_substr($business_Use_Percentage, false !== mb_strpos($business_Use_Percentage, '.') ? mb_strpos($business_Use_Percentage, '.') + 1 : mb_strlen($business_Use_Percentage))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($business_Use_Percentage, true), mb_strlen(mb_substr($business_Use_Percentage, mb_strpos($business_Use_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($business_Use_Percentage) && $business_Use_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($business_Use_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($business_Use_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($business_Use_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage))), __LINE__);
        }
        $this->Business_Use_Percentage = $business_Use_Percentage;
        return $this;
    }
    /**
     * Get Coordinating_Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCoordinating_Cost_Center_Reference()
    {
        return $this->Coordinating_Cost_Center_Reference;
    }
    /**
     * Set Coordinating_Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @return \StructType\Asset_DataType
     */
    public function setCoordinating_Cost_Center_Reference(\StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null)
    {
        $this->Coordinating_Cost_Center_Reference = $coordinating_Cost_Center_Reference;
        return $this;
    }
    /**
     * Get Asset_Coordinator_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAsset_Coordinator_Reference()
    {
        return $this->Asset_Coordinator_Reference;
    }
    /**
     * Set Asset_Coordinator_Reference value
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Coordinator_Reference(\StructType\WorkerObjectType $asset_Coordinator_Reference = null)
    {
        $this->Asset_Coordinator_Reference = $asset_Coordinator_Reference;
        return $this;
    }
    /**
     * Get Related_Asset_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getRelated_Asset_Reference()
    {
        return $this->Related_Asset_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Asset_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Asset_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Asset_ReferenceForArrayConstraintsFromSetRelated_Asset_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeRelated_Asset_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeRelated_Asset_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($asset_DataTypeRelated_Asset_ReferenceItem) ? get_class($asset_DataTypeRelated_Asset_ReferenceItem) : sprintf('%s(%s)', gettype($asset_DataTypeRelated_Asset_ReferenceItem), var_export($asset_DataTypeRelated_Asset_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $related_Asset_Reference
     * @return \StructType\Asset_DataType
     */
    public function setRelated_Asset_Reference(array $related_Asset_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Asset_ReferenceArrayErrorMessage = self::validateRelated_Asset_ReferenceForArrayConstraintsFromSetRelated_Asset_Reference($related_Asset_Reference))) {
            throw new \InvalidArgumentException($related_Asset_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Related_Asset_Reference = $related_Asset_Reference;
        return $this;
    }
    /**
     * Add item to Related_Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Asset_DataType
     */
    public function addToRelated_Asset_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Related_Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Asset_Reference[] = $item;
        return $this;
    }
    /**
     * Get Event_In_Progress value
     * @return bool|null
     */
    public function getEvent_In_Progress()
    {
        return $this->Event_In_Progress;
    }
    /**
     * Set Event_In_Progress value
     * @param bool $event_In_Progress
     * @return \StructType\Asset_DataType
     */
    public function setEvent_In_Progress($event_In_Progress = null)
    {
        // validation for constraint: boolean
        if (!is_null($event_In_Progress) && !is_bool($event_In_Progress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($event_In_Progress, true), gettype($event_In_Progress)), __LINE__);
        }
        $this->Event_In_Progress = $event_In_Progress;
        return $this;
    }
    /**
     * Get Asset_Share_Reference value
     * @return \StructType\Asset_Share_Response_DataType[]|null
     */
    public function getAsset_Share_Reference()
    {
        return $this->Asset_Share_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Share_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Share_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Share_ReferenceForArrayConstraintsFromSetAsset_Share_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeAsset_Share_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeAsset_Share_ReferenceItem instanceof \StructType\Asset_Share_Response_DataType) {
                $invalidValues[] = is_object($asset_DataTypeAsset_Share_ReferenceItem) ? get_class($asset_DataTypeAsset_Share_ReferenceItem) : sprintf('%s(%s)', gettype($asset_DataTypeAsset_Share_ReferenceItem), var_export($asset_DataTypeAsset_Share_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Share_Reference property can only contain items of type \StructType\Asset_Share_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Share_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Response_DataType[] $asset_Share_Reference
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Share_Reference(array $asset_Share_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Share_ReferenceArrayErrorMessage = self::validateAsset_Share_ReferenceForArrayConstraintsFromSetAsset_Share_Reference($asset_Share_Reference))) {
            throw new \InvalidArgumentException($asset_Share_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Share_Reference = $asset_Share_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Share_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Response_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToAsset_Share_Reference(\StructType\Asset_Share_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Share_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Share_Reference property can only contain items of type \StructType\Asset_Share_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Share_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acquisition_Data value
     * @return \StructType\Asset_Acquisition_WWS_DataType[]|null
     */
    public function getAcquisition_Data()
    {
        return $this->Acquisition_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAcquisition_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcquisition_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcquisition_DataForArrayConstraintsFromSetAcquisition_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeAcquisition_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeAcquisition_DataItem instanceof \StructType\Asset_Acquisition_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeAcquisition_DataItem) ? get_class($asset_DataTypeAcquisition_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeAcquisition_DataItem), var_export($asset_DataTypeAcquisition_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Acquisition_Data property can only contain items of type \StructType\Asset_Acquisition_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Acquisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Acquisition_WWS_DataType[] $acquisition_Data
     * @return \StructType\Asset_DataType
     */
    public function setAcquisition_Data(array $acquisition_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($acquisition_DataArrayErrorMessage = self::validateAcquisition_DataForArrayConstraintsFromSetAcquisition_Data($acquisition_Data))) {
            throw new \InvalidArgumentException($acquisition_DataArrayErrorMessage, __LINE__);
        }
        $this->Acquisition_Data = $acquisition_Data;
        return $this;
    }
    /**
     * Add item to Acquisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Acquisition_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToAcquisition_Data(\StructType\Asset_Acquisition_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Acquisition_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Acquisition_Data property can only contain items of type \StructType\Asset_Acquisition_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Acquisition_Data[] = $item;
        return $this;
    }
    /**
     * Get Custodian_Data value
     * @return \StructType\Asset_Custodian_WWS_DataType[]|null
     */
    public function getCustodian_Data()
    {
        return $this->Custodian_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCustodian_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustodian_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustodian_DataForArrayConstraintsFromSetCustodian_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeCustodian_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeCustodian_DataItem instanceof \StructType\Asset_Custodian_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeCustodian_DataItem) ? get_class($asset_DataTypeCustodian_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeCustodian_DataItem), var_export($asset_DataTypeCustodian_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Custodian_Data property can only contain items of type \StructType\Asset_Custodian_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Custodian_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Custodian_WWS_DataType[] $custodian_Data
     * @return \StructType\Asset_DataType
     */
    public function setCustodian_Data(array $custodian_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($custodian_DataArrayErrorMessage = self::validateCustodian_DataForArrayConstraintsFromSetCustodian_Data($custodian_Data))) {
            throw new \InvalidArgumentException($custodian_DataArrayErrorMessage, __LINE__);
        }
        $this->Custodian_Data = $custodian_Data;
        return $this;
    }
    /**
     * Add item to Custodian_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Custodian_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToCustodian_Data(\StructType\Asset_Custodian_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Custodian_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Custodian_Data property can only contain items of type \StructType\Asset_Custodian_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Custodian_Data[] = $item;
        return $this;
    }
    /**
     * Get Asset_Component_Data value
     * @return \StructType\Asset_Components_WWS_DataType[]|null
     */
    public function getAsset_Component_Data()
    {
        return $this->Asset_Component_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Component_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Component_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Component_DataForArrayConstraintsFromSetAsset_Component_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeAsset_Component_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeAsset_Component_DataItem instanceof \StructType\Asset_Components_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeAsset_Component_DataItem) ? get_class($asset_DataTypeAsset_Component_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeAsset_Component_DataItem), var_export($asset_DataTypeAsset_Component_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Component_Data property can only contain items of type \StructType\Asset_Components_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Component_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Components_WWS_DataType[] $asset_Component_Data
     * @return \StructType\Asset_DataType
     */
    public function setAsset_Component_Data(array $asset_Component_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Component_DataArrayErrorMessage = self::validateAsset_Component_DataForArrayConstraintsFromSetAsset_Component_Data($asset_Component_Data))) {
            throw new \InvalidArgumentException($asset_Component_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Component_Data = $asset_Component_Data;
        return $this;
    }
    /**
     * Add item to Asset_Component_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Components_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToAsset_Component_Data(\StructType\Asset_Components_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Components_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Component_Data property can only contain items of type \StructType\Asset_Components_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Component_Data[] = $item;
        return $this;
    }
    /**
     * Get Depreciation_Data value
     * @return \StructType\Asset_Depreciation_WWS_DataType[]|null
     */
    public function getDepreciation_Data()
    {
        return $this->Depreciation_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDepreciation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepreciation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepreciation_DataForArrayConstraintsFromSetDepreciation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeDepreciation_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeDepreciation_DataItem instanceof \StructType\Asset_Depreciation_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeDepreciation_DataItem) ? get_class($asset_DataTypeDepreciation_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeDepreciation_DataItem), var_export($asset_DataTypeDepreciation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Depreciation_Data property can only contain items of type \StructType\Asset_Depreciation_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Depreciation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_WWS_DataType[] $depreciation_Data
     * @return \StructType\Asset_DataType
     */
    public function setDepreciation_Data(array $depreciation_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($depreciation_DataArrayErrorMessage = self::validateDepreciation_DataForArrayConstraintsFromSetDepreciation_Data($depreciation_Data))) {
            throw new \InvalidArgumentException($depreciation_DataArrayErrorMessage, __LINE__);
        }
        $this->Depreciation_Data = $depreciation_Data;
        return $this;
    }
    /**
     * Add item to Depreciation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToDepreciation_Data(\StructType\Asset_Depreciation_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Depreciation_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Depreciation_Data property can only contain items of type \StructType\Asset_Depreciation_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Depreciation_Data[] = $item;
        return $this;
    }
    /**
     * Get Disposal_Data value
     * @return \StructType\Asset_Disposal_WWS_DataType[]|null
     */
    public function getDisposal_Data()
    {
        return $this->Disposal_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDisposal_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisposal_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisposal_DataForArrayConstraintsFromSetDisposal_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeDisposal_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeDisposal_DataItem instanceof \StructType\Asset_Disposal_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeDisposal_DataItem) ? get_class($asset_DataTypeDisposal_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeDisposal_DataItem), var_export($asset_DataTypeDisposal_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disposal_Data property can only contain items of type \StructType\Asset_Disposal_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disposal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Disposal_WWS_DataType[] $disposal_Data
     * @return \StructType\Asset_DataType
     */
    public function setDisposal_Data(array $disposal_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($disposal_DataArrayErrorMessage = self::validateDisposal_DataForArrayConstraintsFromSetDisposal_Data($disposal_Data))) {
            throw new \InvalidArgumentException($disposal_DataArrayErrorMessage, __LINE__);
        }
        $this->Disposal_Data = $disposal_Data;
        return $this;
    }
    /**
     * Add item to Disposal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Disposal_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToDisposal_Data(\StructType\Asset_Disposal_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Disposal_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Disposal_Data property can only contain items of type \StructType\Asset_Disposal_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disposal_Data[] = $item;
        return $this;
    }
    /**
     * Get Depreciation_Detail_Data value
     * @return \StructType\Asset_Depreciation_Detail_DataType[]|null
     */
    public function getDepreciation_Detail_Data()
    {
        return $this->Depreciation_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDepreciation_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepreciation_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepreciation_Detail_DataForArrayConstraintsFromSetDepreciation_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeDepreciation_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeDepreciation_Detail_DataItem instanceof \StructType\Asset_Depreciation_Detail_DataType) {
                $invalidValues[] = is_object($asset_DataTypeDepreciation_Detail_DataItem) ? get_class($asset_DataTypeDepreciation_Detail_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeDepreciation_Detail_DataItem), var_export($asset_DataTypeDepreciation_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Depreciation_Detail_Data property can only contain items of type \StructType\Asset_Depreciation_Detail_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Depreciation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Detail_DataType[] $depreciation_Detail_Data
     * @return \StructType\Asset_DataType
     */
    public function setDepreciation_Detail_Data(array $depreciation_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($depreciation_Detail_DataArrayErrorMessage = self::validateDepreciation_Detail_DataForArrayConstraintsFromSetDepreciation_Detail_Data($depreciation_Detail_Data))) {
            throw new \InvalidArgumentException($depreciation_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Depreciation_Detail_Data = $depreciation_Detail_Data;
        return $this;
    }
    /**
     * Add item to Depreciation_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Detail_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToDepreciation_Detail_Data(\StructType\Asset_Depreciation_Detail_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Depreciation_Detail_DataType) {
            throw new \InvalidArgumentException(sprintf('The Depreciation_Detail_Data property can only contain items of type \StructType\Asset_Depreciation_Detail_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Depreciation_Detail_Data[] = $item;
        return $this;
    }
    /**
     * Get Reinstatement_Data value
     * @return \StructType\Asset_Reinstatement_WWS_DataType[]|null
     */
    public function getReinstatement_Data()
    {
        return $this->Reinstatement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReinstatement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReinstatement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReinstatement_DataForArrayConstraintsFromSetReinstatement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeReinstatement_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeReinstatement_DataItem instanceof \StructType\Asset_Reinstatement_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeReinstatement_DataItem) ? get_class($asset_DataTypeReinstatement_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeReinstatement_DataItem), var_export($asset_DataTypeReinstatement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reinstatement_Data property can only contain items of type \StructType\Asset_Reinstatement_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reinstatement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Reinstatement_WWS_DataType[] $reinstatement_Data
     * @return \StructType\Asset_DataType
     */
    public function setReinstatement_Data(array $reinstatement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($reinstatement_DataArrayErrorMessage = self::validateReinstatement_DataForArrayConstraintsFromSetReinstatement_Data($reinstatement_Data))) {
            throw new \InvalidArgumentException($reinstatement_DataArrayErrorMessage, __LINE__);
        }
        $this->Reinstatement_Data = $reinstatement_Data;
        return $this;
    }
    /**
     * Add item to Reinstatement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Reinstatement_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToReinstatement_Data(\StructType\Asset_Reinstatement_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Reinstatement_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Reinstatement_Data property can only contain items of type \StructType\Asset_Reinstatement_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reinstatement_Data[] = $item;
        return $this;
    }
    /**
     * Get Intercompany_Transfer_Data value
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType[]|null
     */
    public function getIntercompany_Transfer_Data()
    {
        return $this->Intercompany_Transfer_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setIntercompany_Transfer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIntercompany_Transfer_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIntercompany_Transfer_DataForArrayConstraintsFromSetIntercompany_Transfer_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeIntercompany_Transfer_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeIntercompany_Transfer_DataItem instanceof \StructType\Asset_Intercompany_Transfer_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeIntercompany_Transfer_DataItem) ? get_class($asset_DataTypeIntercompany_Transfer_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeIntercompany_Transfer_DataItem), var_export($asset_DataTypeIntercompany_Transfer_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Intercompany_Transfer_Data property can only contain items of type \StructType\Asset_Intercompany_Transfer_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Intercompany_Transfer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Intercompany_Transfer_WWS_DataType[] $intercompany_Transfer_Data
     * @return \StructType\Asset_DataType
     */
    public function setIntercompany_Transfer_Data(array $intercompany_Transfer_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($intercompany_Transfer_DataArrayErrorMessage = self::validateIntercompany_Transfer_DataForArrayConstraintsFromSetIntercompany_Transfer_Data($intercompany_Transfer_Data))) {
            throw new \InvalidArgumentException($intercompany_Transfer_DataArrayErrorMessage, __LINE__);
        }
        $this->Intercompany_Transfer_Data = $intercompany_Transfer_Data;
        return $this;
    }
    /**
     * Add item to Intercompany_Transfer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Intercompany_Transfer_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToIntercompany_Transfer_Data(\StructType\Asset_Intercompany_Transfer_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Intercompany_Transfer_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Intercompany_Transfer_Data property can only contain items of type \StructType\Asset_Intercompany_Transfer_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Intercompany_Transfer_Data[] = $item;
        return $this;
    }
    /**
     * Get Impairment_Data value
     * @return \StructType\Asset_Impairment_WWS_DataType[]|null
     */
    public function getImpairment_Data()
    {
        return $this->Impairment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setImpairment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImpairment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImpairment_DataForArrayConstraintsFromSetImpairment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeImpairment_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeImpairment_DataItem instanceof \StructType\Asset_Impairment_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeImpairment_DataItem) ? get_class($asset_DataTypeImpairment_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeImpairment_DataItem), var_export($asset_DataTypeImpairment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Impairment_Data property can only contain items of type \StructType\Asset_Impairment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Impairment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Impairment_WWS_DataType[] $impairment_Data
     * @return \StructType\Asset_DataType
     */
    public function setImpairment_Data(array $impairment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($impairment_DataArrayErrorMessage = self::validateImpairment_DataForArrayConstraintsFromSetImpairment_Data($impairment_Data))) {
            throw new \InvalidArgumentException($impairment_DataArrayErrorMessage, __LINE__);
        }
        $this->Impairment_Data = $impairment_Data;
        return $this;
    }
    /**
     * Add item to Impairment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Impairment_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToImpairment_Data(\StructType\Asset_Impairment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Impairment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Impairment_Data property can only contain items of type \StructType\Asset_Impairment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Impairment_Data[] = $item;
        return $this;
    }
    /**
     * Get In_Service_Schedule_Data value
     * @return \StructType\Asset_In_Service_Schedule_WWS_DataType[]|null
     */
    public function getIn_Service_Schedule_Data()
    {
        return $this->In_Service_Schedule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setIn_Service_Schedule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIn_Service_Schedule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIn_Service_Schedule_DataForArrayConstraintsFromSetIn_Service_Schedule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeIn_Service_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeIn_Service_Schedule_DataItem instanceof \StructType\Asset_In_Service_Schedule_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeIn_Service_Schedule_DataItem) ? get_class($asset_DataTypeIn_Service_Schedule_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeIn_Service_Schedule_DataItem), var_export($asset_DataTypeIn_Service_Schedule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The In_Service_Schedule_Data property can only contain items of type \StructType\Asset_In_Service_Schedule_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set In_Service_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_In_Service_Schedule_WWS_DataType[] $in_Service_Schedule_Data
     * @return \StructType\Asset_DataType
     */
    public function setIn_Service_Schedule_Data(array $in_Service_Schedule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($in_Service_Schedule_DataArrayErrorMessage = self::validateIn_Service_Schedule_DataForArrayConstraintsFromSetIn_Service_Schedule_Data($in_Service_Schedule_Data))) {
            throw new \InvalidArgumentException($in_Service_Schedule_DataArrayErrorMessage, __LINE__);
        }
        $this->In_Service_Schedule_Data = $in_Service_Schedule_Data;
        return $this;
    }
    /**
     * Add item to In_Service_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_In_Service_Schedule_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToIn_Service_Schedule_Data(\StructType\Asset_In_Service_Schedule_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_In_Service_Schedule_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The In_Service_Schedule_Data property can only contain items of type \StructType\Asset_In_Service_Schedule_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->In_Service_Schedule_Data[] = $item;
        return $this;
    }
    /**
     * Get Cost_Adjustment_Data value
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType[]|null
     */
    public function getCost_Adjustment_Data()
    {
        return $this->Cost_Adjustment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCost_Adjustment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCost_Adjustment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCost_Adjustment_DataForArrayConstraintsFromSetCost_Adjustment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeCost_Adjustment_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeCost_Adjustment_DataItem instanceof \StructType\Asset_Cost_Adjustment_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeCost_Adjustment_DataItem) ? get_class($asset_DataTypeCost_Adjustment_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeCost_Adjustment_DataItem), var_export($asset_DataTypeCost_Adjustment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cost_Adjustment_Data property can only contain items of type \StructType\Asset_Cost_Adjustment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cost_Adjustment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Cost_Adjustment_WWS_DataType[] $cost_Adjustment_Data
     * @return \StructType\Asset_DataType
     */
    public function setCost_Adjustment_Data(array $cost_Adjustment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($cost_Adjustment_DataArrayErrorMessage = self::validateCost_Adjustment_DataForArrayConstraintsFromSetCost_Adjustment_Data($cost_Adjustment_Data))) {
            throw new \InvalidArgumentException($cost_Adjustment_DataArrayErrorMessage, __LINE__);
        }
        $this->Cost_Adjustment_Data = $cost_Adjustment_Data;
        return $this;
    }
    /**
     * Add item to Cost_Adjustment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Cost_Adjustment_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToCost_Adjustment_Data(\StructType\Asset_Cost_Adjustment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Cost_Adjustment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Cost_Adjustment_Data property can only contain items of type \StructType\Asset_Cost_Adjustment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cost_Adjustment_Data[] = $item;
        return $this;
    }
    /**
     * Get Reclassification_Data value
     * @return \StructType\Asset_Reclassification_WWS_DataType[]|null
     */
    public function getReclassification_Data()
    {
        return $this->Reclassification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReclassification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReclassification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReclassification_DataForArrayConstraintsFromSetReclassification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeReclassification_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeReclassification_DataItem instanceof \StructType\Asset_Reclassification_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeReclassification_DataItem) ? get_class($asset_DataTypeReclassification_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeReclassification_DataItem), var_export($asset_DataTypeReclassification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reclassification_Data property can only contain items of type \StructType\Asset_Reclassification_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reclassification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Reclassification_WWS_DataType[] $reclassification_Data
     * @return \StructType\Asset_DataType
     */
    public function setReclassification_Data(array $reclassification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($reclassification_DataArrayErrorMessage = self::validateReclassification_DataForArrayConstraintsFromSetReclassification_Data($reclassification_Data))) {
            throw new \InvalidArgumentException($reclassification_DataArrayErrorMessage, __LINE__);
        }
        $this->Reclassification_Data = $reclassification_Data;
        return $this;
    }
    /**
     * Add item to Reclassification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Reclassification_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToReclassification_Data(\StructType\Asset_Reclassification_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Reclassification_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Reclassification_Data property can only contain items of type \StructType\Asset_Reclassification_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reclassification_Data[] = $item;
        return $this;
    }
    /**
     * Get Removal_Data value
     * @return \StructType\Asset_Removal_WWS_DataType[]|null
     */
    public function getRemoval_Data()
    {
        return $this->Removal_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRemoval_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoval_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemoval_DataForArrayConstraintsFromSetRemoval_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeRemoval_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeRemoval_DataItem instanceof \StructType\Asset_Removal_WWS_DataType) {
                $invalidValues[] = is_object($asset_DataTypeRemoval_DataItem) ? get_class($asset_DataTypeRemoval_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeRemoval_DataItem), var_export($asset_DataTypeRemoval_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Removal_Data property can only contain items of type \StructType\Asset_Removal_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Removal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Removal_WWS_DataType[] $removal_Data
     * @return \StructType\Asset_DataType
     */
    public function setRemoval_Data(array $removal_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($removal_DataArrayErrorMessage = self::validateRemoval_DataForArrayConstraintsFromSetRemoval_Data($removal_Data))) {
            throw new \InvalidArgumentException($removal_DataArrayErrorMessage, __LINE__);
        }
        $this->Removal_Data = $removal_Data;
        return $this;
    }
    /**
     * Add item to Removal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Removal_WWS_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToRemoval_Data(\StructType\Asset_Removal_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Removal_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Removal_Data property can only contain items of type \StructType\Asset_Removal_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Removal_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$asset_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($asset_DataTypeAttachment_DataItem) ? get_class($asset_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($asset_DataTypeAttachment_DataItem), var_export($asset_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Asset_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Asset_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
