<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Put ServiceType
 * @subpackage Services
 */
class Put extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Put_Resource_Category
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Spend Categories. Spend Categories are a classification for items and services that drives the accounting in Workday. Whenever an accounting entry is made, Workday looks first at the spend
     * category. All items—expense items, purchase items—and services are associated with a Spend Category. Sales items are associated with its analog: Revenue Category. This service returns the spend categories that are applied to every business
     * asset—that is, expense item, purchase item, and service—in Workday. You can define categories to fit your enterprise's needs. You can also followed a standard like the UN/SPSC coding hierarchy. Spend Category data for this service includes Spend
     * Category ID, Spend Category Name, Procurement Usage flag, Expense Usage flag, Track Items flag, Accounting Treatment, Depreciation Profile, and UNSPSC Code Range.Business Asset and Resource are synonymous and refer to the same business object.Spend
     * Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Resource_Category_RequestType $body
     * @return \StructType\Put_Resource_Category_ResponseType|bool
     */
    public function Put_Resource_Category(\StructType\Put_Resource_Category_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Resource_Category($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Purchase_Item_Group
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Purchase Item Groups. Purchase items are goods and services that are purchased from suppliers. Purchase Item data includes Purchase Item ID, Name, Spend Category, Item Description, Item
     * Identifier, Unit of Measure, Item Unit Price, Currency and Purchase Item Group.Spend Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Item_Group_RequestType $body
     * @return \StructType\Put_Purchase_Item_Group_ResponseType|bool
     */
    public function Put_Purchase_Item_Group(\StructType\Put_Purchase_Item_Group_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Item_Group($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Purchase_Item
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Purchase Items. Purchase items are goods and services that are purchased from suppliers. Purchase Item data includes Purchase Item ID, Name, Spend Category, Item Description, Item Identifier,
     * Unit of Measure, Item Unit Price, Currency and Purchase Item Group.Spend Category and Resource Category are synonymous and refer to the same business object.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Item_RequestType $body
     * @return \StructType\Put_Purchase_Item_ResponseType|bool
     */
    public function Put_Purchase_Item(\StructType\Put_Purchase_Item_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Item($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Item
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Expense Items. Expense Item are used to create and track goods and services which can be expensed to a company by Employees. Expense item data includes Expense Item ID, Item Name, Spend
     * Category, Item Description, Item Unit Price, Currency, Instructions for the User, Fixed Expense flag, Maximum Expense flag, and Memo Require Flag.Spend Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Item_RequestType $body
     * @return \StructType\Put_Expense_Item_ResponseType|bool
     */
    public function Put_Expense_Item(\StructType\Put_Expense_Item_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Item($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: DEPRECATED: The functionality within this operation has been replaced by new functionality within the "Submit Supplier" operation.This service operation previously adds or updates Suppliers. Supplier data includes Supplier ID,
     * Supplier Reference ID, Supplier Name, Worktag Only, Approval Status, Tax Authority Form Type, IRS 1099 Supplier Flag, Report 1099 with Parent Flag, TIN Type Reference, Supplier Category, Supplier Group, Tax Document Date, Default Tax Code Reference,
     * Certificate of Insurance Date, Customer Account Number, DUNS Number, Disable Change Order Flag, Purchase Order Issue Option, Payment Terms, Payment Types accepted, Default Payment Type, Procurement Credit Card, Included Children, Proposed Children
     * Reference, Business Entity data, Settlement Account data, Do Not Pay if Settlement Bank Account Change In Progress flag, Supplier Status, Proposed Supplier Status, Separate Payments flag, Memo, Business Entity Alternate Name data, Business Entity
     * Attachment data and Areas Change Flags. Business Entity data includes Name, Tax ID, External ID, Contact Information data, and Business Entity Logo. Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data.1No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_RequestType $body
     * @return \StructType\Put_Supplier_ResponseType|bool
     */
    public function Put_Supplier(\StructType\Put_Supplier_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Item_Group
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Item Groups. Expense Item Group data includes Expense Item Group ID and Name. Expense Item Group can be used to make it easier to search for and select items. Expense items can belong to
     * multiple groups.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Item_Group_RequestType $body
     * @return \StructType\Put_Expense_Item_Group_ResponseType|bool
     */
    public function Put_Expense_Item_Group(\StructType\Put_Expense_Item_Group_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Item_Group($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Category
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Categories. Supplier Category data includes the Supplier Category ID and the Supplier Category Name. Supplier Categories are used to maintain suppliers and apply accounting rules to
     * procurement transactions. You can also use Supplier categories when selecting or searching for Suppliers. All Suppliers must have one and only one category.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Category_RequestType $body
     * @return \StructType\Put_Supplier_Category_ResponseType|bool
     */
    public function Put_Supplier_Category(\StructType\Put_Supplier_Category_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Category($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Group
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Groups. Supplier Groups are used for reporting and selection. Supplier groups can include individual suppliers. Supplier Group data includes Supplier Group ID and Name.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Group_RequestType $body
     * @return \StructType\Put_Supplier_Group_ResponseType|bool
     */
    public function Put_Supplier_Group(\StructType\Put_Supplier_Group_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Group($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Corporate_Credit_Card_Billing_Account
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Corporate Credit Card Accounts.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType $body
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_ResponseType|bool
     */
    public function Put_Corporate_Credit_Card_Billing_Account(\StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Corporate_Credit_Card_Billing_Account($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Credit_Card
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation is deprecated. Please use Import Credit Cards web service operation instead. If you do use this web service for high volumes of data, you may experience performance impacts.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Credit_Card_RequestType $body
     * @return \StructType\Put_Expense_Credit_Card_ResponseType|bool
     */
    public function Put_Expense_Credit_Card(\StructType\Put_Expense_Credit_Card_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Credit_Card($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Business_Entity_Contact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Business Entity Contacts. The data includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier, Customer, Financial Institution or Tax Authority), the Personal
     * Data including Name Detail data and Contact Information data. Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix. Contact Information data includes Address, Phone,
     * Email, Instance Messenger and Web Address data.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Business_Entity_Contact_RequestType $body
     * @return \StructType\Put_Business_Entity_Contact_ResponseType|bool
     */
    public function Put_Business_Entity_Contact(\StructType\Put_Business_Entity_Contact_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Business_Entity_Contact($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Invoice_History
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will add or update Supplier Invoice Histories. This contains data for Reference ID, Company, Currency, Supplier, Total Invoice Amount, document Reference Number, Invoice Date, External PO Number, Document
     * Number, and Source Integration System name.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_History_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_History_ResponseType|bool
     */
    public function Put_Supplier_Invoice_History(\StructType\Put_Supplier_Invoice_History_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_History($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Worker_Role
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Project Worker Role. A project worker role can be used by multiple Project Resource Pools for multiple Projects. Project Worker Role data includes Project Worker Role ID, Project Worker Role
     * Name, Project Worker Role Description, Default Hourly Billable Rate, Default Hourly Internal Rate, and Currency.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Worker_Role_RequestType $body
     * @return \StructType\Put_Project_Worker_Role_ResponseType|bool
     */
    public function Put_Project_Worker_Role(\StructType\Put_Project_Worker_Role_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Worker_Role($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Task
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put Project Task web serviceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Task_RequestType $body
     * @return \StructType\Put_Project_Task_ResponseType|bool
     */
    public function Put_Project_Task(\StructType\Put_Project_Task_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Task($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Phase
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the Put Project Phase web serviceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Phase_RequestType $body
     * @return \StructType\Put_Project_Phase_ResponseType|bool
     */
    public function Put_Project_Phase(\StructType\Put_Project_Phase_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Phase($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Policy_Group
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Expense Policy Groups. Expense Policy Group data includes Expense Policy Group ID and Name. Expense Policy Group can be used to make it easier to search for and select items for
     * administrators. Expense items can belong to multiple groups.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Policy_Group_RequestType $body
     * @return \StructType\Put_Expense_Policy_Group_ResponseType|bool
     */
    public function Put_Expense_Policy_Group(\StructType\Put_Expense_Policy_Group_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Policy_Group($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Rate_Table_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will add or update Expense Rate Table Rules. An Expense Rate Table Rule contains a Condition Rule, including an ID, a Description, and lines of Condition Items. Each Condition Rule contains Open or Close
     * Parentheses, an And or Or operator, and filter criteria for the rule.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Rate_Table_Rule_RequestType $body
     * @return \StructType\Put_Expense_Rate_Table_Rule_ResponseType|bool
     */
    public function Put_Expense_Rate_Table_Rule(\StructType\Put_Expense_Rate_Table_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Rate_Table_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Spend_Category_Hierarchy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Spend Category Hierarchies. This operation will allow for the addition of an existing Spend Category Hierarchies as the superiors/subordinates and addition of existing Spend Categories as
     * subordinates.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Spend_Category_Hierarchy_RequestType $body
     * @return \StructType\Put_Spend_Category_Hierarchy_ResponseType|bool
     */
    public function Put_Spend_Category_Hierarchy(\StructType\Put_Spend_Category_Hierarchy_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Spend_Category_Hierarchy($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Expense_Credit_Card_Transaction_File
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation is deprecated. Please use Import Credit Card Transactions web service operation instead. If you do use this web service for high volumes of data, you may experience performance impacts.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Credit_Card_Transaction_File_RequestType $body
     * @return \StructType\Put_Credit_Card_Transaction_File_ResponseType|bool
     */
    public function Put_Expense_Credit_Card_Transaction_File(\StructType\Put_Credit_Card_Transaction_File_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Credit_Card_Transaction_File($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Expense_Credit_Card_Transaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation is deprecated. Please use Import Credit Card Transactions web service operation instead. If you do use this web service for high volumes of data, you may experience performance impacts.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Credit_Card_Transaction_RequestType $body
     * @return \StructType\Put_Expense_Credit_Card_Transaction_ResponseType|bool
     */
    public function Put_Expense_Credit_Card_Transaction(\StructType\Put_Expense_Credit_Card_Transaction_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Credit_Card_Transaction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Company_Default
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update a default company on expense reports that may be different from worker’s own company of which they are a member. Expense Company Default data includes Company ID and Worker.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Company_Default_RequestType $body
     * @return \StructType\Put_Expense_Company_Default_ResponseType|bool
     */
    public function Put_Expense_Company_Default(\StructType\Put_Expense_Company_Default_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Company_Default($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Card_Holder_Listing_File
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation is deprecated. Please use Import Credit Cards web service operation instead. If you do use this web service for high volumes of data, you may experience performance impacts.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Card_Holder_Listing_File_RequestType $body
     * @return \StructType\Put_Card_Holder_Listing_File_ResponseType|bool
     */
    public function Put_Card_Holder_Listing_File(\StructType\Put_Card_Holder_Listing_File_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Card_Holder_Listing_File($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Expense_Item_Attribute_Group
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Item Attribute Groups. Expense Item Attribute Group data includes Expense Item Attribute Group ID and Name. Expense Item Attribute Group can be used to make it easier to search for and select
     * items. Expense item attributes can belong to multiple groups.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Expense_Item_Attribute_Group_RequestType $body
     * @return \StructType\Put_Expense_Item_Attribute_Group_ResponseType|bool
     */
    public function Put_Expense_Item_Attribute_Group(\StructType\Put_Expense_Item_Attribute_Group_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Expense_Item_Attribute_Group($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Asset_Book_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to put or replace asset book rules for asset books. Asset Book Rules are ordered; you specify Asset Book, Accounting Treatment and Depreciation Profile based on Spend Category, Asset Class, Asset Type,
     * Company, Amount, Currency, and Amount Basis Reference (Unit Amount or Extended Amount). If rules are sent a subsequent time, all rules are replaced.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Asset_Book_Rules_RequestType $body
     * @return \StructType\Put_Asset_Book_Rules_ResponseType|bool
     */
    public function Put_Asset_Book_Rules(\StructType\Put_Asset_Book_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Asset_Book_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Catalog
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to create or update a Supplier Catalog. To create a new Supplier Catalog set Add Only to true and provide the Catalog Name, Currency, and Supplier. To update an existing Supplier Catalog set Add
     * Only to false and include a Reference ID or WID to the existing Catalog.Note that you may not modify the Currency or Supplier for a Supplier Catalog that is in use by one or more Supplier Contracts.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Catalog_RequestType $body
     * @return \StructType\Put_Supplier_Catalog_ResponseType|bool
     */
    public function Put_Supplier_Catalog(\StructType\Put_Supplier_Catalog_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Catalog($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Airline
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Airline or modifies an existing Airline. If you supply a valid ID, then the existing Airline is modified. Otherwise, the operation creates a new Airline.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Airline_RequestType $body
     * @return \StructType\Put_Airline_ResponseType|bool
     */
    public function Put_Airline(\StructType\Put_Airline_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Airline($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Hotel
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Hotel or modifies an existing Hotel. If you provide a valid ID, the operation modifies an existing Hotel. If no ID is provided, the operation creates a new Hotel.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Hotel_RequestType $body
     * @return \StructType\Put_Hotel_ResponseType|bool
     */
    public function Put_Hotel(\StructType\Put_Hotel_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Hotel($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Car_Rental_Agency
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Car Rental Agency or modifies an existing Car Rental Agency. If you supply a valid ID, then the existing Car Rental Agency is modified. Otherwise, the operation creates a new Car Rental Agency.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Car_Rental_Agency_RequestType $body
     * @return \StructType\Put_Car_Rental_Agency_ResponseType|bool
     */
    public function Put_Car_Rental_Agency(\StructType\Put_Car_Rental_Agency_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Car_Rental_Agency($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Travel_City
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates or modifies a Travel City. Creates a new Travel City, if no ID is provided, or modifies an existing Travel City, if a valid ID is provided.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Travel_City_RequestType $body
     * @return \StructType\Put_Travel_City_ResponseType|bool
     */
    public function Put_Travel_City(\StructType\Put_Travel_City_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Travel_City($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Airport
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Airport or modifies an existing Airport. If you supply a valid ID, then the existing Airport is modified. Otherwise, the operation creates a new Airport.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Airport_RequestType $body
     * @return \StructType\Put_Airport_ResponseType|bool
     */
    public function Put_Airport(\StructType\Put_Airport_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Airport($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service used to put Project Asset associated to a Project.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Asset_RequestType $body
     * @return \StructType\Put_Project_Asset_ResponseType|bool
     */
    public function Put_Project_Asset(\StructType\Put_Project_Asset_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Asset_Pooling_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to put or replace asset pooling rules. Asset Pooling Rules are ordered, you specify Company, Spend Category, Item, Currency, Quantity Greater Than, and Unit Cost Less Than.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Asset_Pooling_Rule_RequestType $body
     * @return \StructType\Put_Asset_Pooling_Rule_ResponseType|bool
     */
    public function Put_Asset_Pooling_Rule(\StructType\Put_Asset_Pooling_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Asset_Pooling_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Task_Resources
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The service operation will replace existing Project Task Resources with the ones specified or add or update or delete specified Project Task Resources for a Project.Project Task Resource Request includes Project Reference,Replace All
     * Flag,Add Only Flag and Project Task Resource Data element.Project Task Resource Data contains Project Task Resource ID,Project Plan Task Reference,Project Resource Plan Detail Reference,Worker Reference,Resource Start Date,Resource End Date,%
     * Allocation,Estimated Hours.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Task_Resources_RequestType $body
     * @return \StructType\Put_Project_Task_Resources_ResponseType|bool
     */
    public function Put_Project_Task_Resources(\StructType\Put_Project_Task_Resources_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Task_Resources($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Plan
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the Put Project Plan web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Plan_RequestType $body
     * @return \StructType\Put_Project_Plan_ResponseType|bool
     */
    public function Put_Project_Plan(\StructType\Put_Project_Plan_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Plan($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Item_Identifier_Type
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will create or update an Item Identifier Type.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Item_Identifier_Type_RequestType $body
     * @return \StructType\Put_Item_Identifier_Type_ResponseType|bool
     */
    public function Put_Item_Identifier_Type(\StructType\Put_Item_Identifier_Type_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Item_Identifier_Type($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Requirements_for_Resource_Plan
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is W23 Put Requirements web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requirements_for_Resource_Plan_RequestType $body
     * @return \StructType\Put_Requirements_for_Resource_Plan_Line_ResponseType|bool
     */
    public function Put_Requirements_for_Resource_Plan(\StructType\Put_Requirements_for_Resource_Plan_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requirements_for_Resource_Plan($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Requisition_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation can create a requisition sourcing rule. It can also modify and delete an existing sourcing rule. There are four types of sourcing rules: Buyer, Supplier, Order-From Connection, and Inventory Site. It defaults these
     * values needed for requisition sourcing if it matches a rule's criteria. Only the highest ranking rule will be applied to determine a value. There are also some global attributes to be used for all sourcing rules of a given type. Beginning in v33.0,
     * those global values cannot be set using this web service operation, and can only be assigned using the Maintain Requisition Sourcing Rules task. This was removed to allow support of import and export of sourcing rules using a spreadsheet.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requisition_Sourcing_Rule_RequestType $body
     * @return \StructType\Put_Requisition_Sourcing_Rule_ResponseType|bool
     */
    public function Put_Requisition_Sourcing_Rule(\StructType\Put_Requisition_Sourcing_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requisition_Sourcing_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Cash_Advance_Repayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates Cash Advance Repayments. Cash Advance Repayment data includes Spend Authorization for Repayment, Repayment Amount, Repayment Currency, Date, Reference, and Memo.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Cash_Advance_Repayment_RequestType $body
     * @return \StructType\Put_Cash_Advance_Repayment_ResponseType|bool
     */
    public function Put_Cash_Advance_Repayment(\StructType\Put_Cash_Advance_Repayment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Cash_Advance_Repayment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Project_Standard_Cost_Rate_Sheet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Loads or updates Project Standard Cost Rate Sheet and associated Project Standard Cost Rates data, including project roles, rules, and standard cost rates.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Standard_Cost_Rate_Sheet_RequestType $body
     * @return \StructType\Put_Project_Standard_Cost_Rate_Sheet_ResponseType|bool
     */
    public function Put_Project_Standard_Cost_Rate_Sheet(\StructType\Put_Project_Standard_Cost_Rate_Sheet_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Standard_Cost_Rate_Sheet($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Item_Tag
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will create or update an Item Tag.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Item_Tag_RequestType $body
     * @return \StructType\Put_Item_Tag_ResponseType|bool
     */
    public function Put_Item_Tag(\StructType\Put_Item_Tag_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Item_Tag($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Internal_Service_Provider
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Internal Service Providers. Internal Service Provider data includes Internal Service Provider Name, Internal Service Provider ID, Currency, Inactive boolean, Company or Company Hierarchy,
     * Revenue Category, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Internal_Service_Provider_RequestType $body
     * @return \StructType\Put_Internal_Service_Provider_ResponseType|bool
     */
    public function Put_Internal_Service_Provider(\StructType\Put_Internal_Service_Provider_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Internal_Service_Provider($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Internal_Catalog
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation is for creating or updating an Internal Catalog. Creating a new Internal Catalog would set the Add Only flag to true, followed by the required catalog attributes of Name, Currency, and Internal Service
     * Provider. Updating an existing Internal Catalog would set the Add Only flag to false, include a Reference ID or WID to the existing Catalog, followed by the same three required attributes.If a Catalog has catalog items and Catalog Load is in
     * progress, then only the Catalog Name can be updated.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Internal_Catalog_RequestType $body
     * @return \StructType\Put_Internal_Catalog_ResponseType|bool
     */
    public function Put_Internal_Catalog(\StructType\Put_Internal_Catalog_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Internal_Catalog($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Credit_Card_Code_Mapping
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Add, update, or delete merchant code to expense item mappingsNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Credit_Card_Code_Mapping_RequestType $body
     * @return \StructType\Put_Credit_Card_Code_Mapping_ResponseType|bool
     */
    public function Put_Credit_Card_Code_Mapping(\StructType\Put_Credit_Card_Code_Mapping_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Credit_Card_Code_Mapping($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Procurement_Document_Attachment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds a new attachment to a supplier invoice, receipt, supplier contract, and purchase order. We plan to support other procurement documents in the future.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Procurement_Document_Attachment_RequestType $body
     * @return \StructType\Put_Procurement_Document_Attachment_ResponseType|bool
     */
    public function Put_Procurement_Document_Attachment(\StructType\Put_Procurement_Document_Attachment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Procurement_Document_Attachment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Location_Customer_Account_Number_Detail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to add or update a single Location Customer Account Number Detail. To create a new Location Customer Account Number detail, set "Add Only" to true and provide Supplier, Location, Customer
     * Account Number, JIT Customer Account Number and Inactive. To update an existing Location Customer Account Number Detail, set Add Only to false and include a Reference ID or WID to the existing Location Customer Account Number Detail.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Location_Customer_Account_Number_Detail_RequestType $body
     * @return \StructType\Put_Location_Customer_Account_Number_Detail_ResponseType|bool
     */
    public function Put_Location_Customer_Account_Number_Detail(\StructType\Put_Location_Customer_Account_Number_Detail_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Location_Customer_Account_Number_Detail($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Role_Category
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Project Role Category (or updates an existing Project Role Category) with the information supplied in the request.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Role_Category_RequestType $body
     * @return \StructType\Put_Project_Role_Category_ResponseType|bool
     */
    public function Put_Project_Role_Category(\StructType\Put_Project_Role_Category_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Role_Category($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Classification
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will allow to setup classifications that can be associated with a supplier. Supplier classifications will be used for reporting. Supplier classification data will include classification name, external site boolean,
     * country, and attributes.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Classification_RequestType $body
     * @return \StructType\Put_Supplier_Classification_ResponseType|bool
     */
    public function Put_Supplier_Classification(\StructType\Put_Supplier_Classification_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Classification($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Invoice_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates or modifies an invoice type. Creates a new invoice type based on filtering criteria. Duplicate Invoice Types are not allowed.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Invoice_Types_RequestType $body
     * @return \StructType\Put_Invoice_Types_ResponseType|bool
     */
    public function Put_Invoice_Types(\StructType\Put_Invoice_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Invoice_Types($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Contract_Document_Link
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to update the Document Link on Supplier Contract.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Contract_Document_Link_RequestType $body
     * @return \StructType\Put_Supplier_Contract_Document_Link_ResponseType|bool
     */
    public function Put_Supplier_Contract_Document_Link(\StructType\Put_Supplier_Contract_Document_Link_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Contract_Document_Link($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Resource_Pool_Hierarchy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put Resource Pool Hierarchy.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Resource_Pool_Hierarchy_RequestType $body
     * @return \StructType\Put_Resource_Pool_Hierarchy_ResponseType|bool
     */
    public function Put_Resource_Pool_Hierarchy(\StructType\Put_Resource_Pool_Hierarchy_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Resource_Pool_Hierarchy($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Resource_Pool
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put Resource Pool.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Resource_Pool_RequestType $body
     * @return \StructType\Put_Resource_Pool_ResponseType|bool
     */
    public function Put_Resource_Pool(\StructType\Put_Resource_Pool_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Resource_Pool($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Requisition_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enables updating of custom objects on Requisition.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requisition_Additional_Data_RequestType $body
     * @return \StructType\Put_Requisition_Additional_Data_ResponseType|bool
     */
    public function Put_Requisition_Additional_Data(\StructType\Put_Requisition_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requisition_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Requisition_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enables updating of custom objects on Requisition Line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requisition_Line_Additional_Data_RequestType $body
     * @return \StructType\Put_Requisition_Line_Additional_Data_ResponseType|bool
     */
    public function Put_Requisition_Line_Additional_Data(\StructType\Put_Requisition_Line_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requisition_Line_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Company_Asset_Book_Restrictions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: You can put or replace Company Asset Book Restrictions for company asset books. Company Asset Book Restrictions are ordered; you can specify Spend Category or Hierarchy, Restricted to Books and Asset Book for Primary Asset Book
     * Override based on Company. If rules are subsequently sent with matching ID, the rules are updated.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Company_Asset_Book_Restrictions_RequestType $body
     * @return \StructType\Put_Company_Asset_Book_Restrictions_ResponseType|bool
     */
    public function Put_Company_Asset_Book_Restrictions(\StructType\Put_Company_Asset_Book_Restrictions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Company_Asset_Book_Restrictions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Transfer_Pricing_Rate_Sheet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Loads or updates Transfer Pricing Rate Sheet and associated Transfer Pricing Rate dataNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Transfer_Pricing_Rate_Sheet_RequestType $body
     * @return \StructType\Put_Transfer_Pricing_Rate_Sheet_ResponseType|bool
     */
    public function Put_Transfer_Pricing_Rate_Sheet(\StructType\Put_Transfer_Pricing_Rate_Sheet_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Transfer_Pricing_Rate_Sheet($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Revenue_Center
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates Revenue Centers. Data includes Company, Revenue Center Code, and Active.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Revenue_Center_RequestType $body
     * @return \StructType\Put_Revenue_Center_ResponseType|bool
     */
    public function Put_Revenue_Center(\StructType\Put_Revenue_Center_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Revenue_Center($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Requisition_Template
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Shared Requisition Templates. Requisition Template Date includes Company, Template Name, Owned By, Document Date, Job ProfileNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requisition_Template_RequestType $body
     * @return \StructType\Put_Requisition_Template_ResponseType|bool
     */
    public function Put_Requisition_Template(\StructType\Put_Requisition_Template_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requisition_Template($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Patient_Charge_Information
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds Patient Charge Information to a Purchase Item. Data includes Revenue Center, CDM, HCPCS and Company or Company HierarchyNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Patient_Charge_Information_RequestType $body
     * @return \StructType\Put_Patient_Charge_Information_ResponseType|bool
     */
    public function Put_Patient_Charge_Information(\StructType\Put_Patient_Charge_Information_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Patient_Charge_Information($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Invoice_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enables updating of custom objects on Supplier Invoice Line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_Line_Additional_Data_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_Line_Additional_Data_ResponseType|bool
     */
    public function Put_Supplier_Invoice_Line_Additional_Data(\StructType\Put_Supplier_Invoice_Line_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_Line_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Worker_Utilization_Target_Sheet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation loads or updates Worker Utilization Target Sheet and associated Utilization Target data, i.e., Utilization Target % defined for Utilization Target Rules or Workers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Worker_Utilization_Target_Sheet_RequestType $body
     * @return \StructType\Put_Worker_Utilization_Target_Sheet_ResponseType|bool
     */
    public function Put_Worker_Utilization_Target_Sheet(\StructType\Put_Worker_Utilization_Target_Sheet_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Worker_Utilization_Target_Sheet($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_OCR_Supplier_Invoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add an OCR Supplier Invoice and submit to the OCR engine for scanning. OCR Supplier Invoice data includes Company, Assignee, Received Date, OCR High Priority, Work Queue Notes and Attachment.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_OCR_Supplier_Invoice_RequestType $body
     * @return \StructType\Put_OCR_Supplier_Invoice_ResponseType|bool
     */
    public function Put_OCR_Supplier_Invoice(\StructType\Put_OCR_Supplier_Invoice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_OCR_Supplier_Invoice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Payment_Memo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates supplier payment memos. Use supplier payment memos to capture and store additional information on supplier payments.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Payment_Memo_RequestType $body
     * @return \StructType\Put_Supplier_Payment_Memo_ResponseType|bool
     */
    public function Put_Supplier_Payment_Memo(\StructType\Put_Supplier_Payment_Memo_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Payment_Memo($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Purchase_Order_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enables updating of custom objects on Purchase Order Line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Order_Line_Additional_Data_RequestType $body
     * @return \StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType|bool
     */
    public function Put_Purchase_Order_Line_Additional_Data(\StructType\Put_Purchase_Order_Line_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Order_Line_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Portfolio
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put ~Project~ Portfolios.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Portfolio_RequestType $body
     * @return \StructType\Put_Project_Portfolio_ResponseType|bool
     */
    public function Put_Project_Portfolio(\StructType\Put_Project_Portfolio_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Portfolio($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Worktag_Split_Template_Restriction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Task that allows creation of Worktag Split Template Restriction through Web ServiceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Worktag_Split_Template_Restriction_RequestType $body
     * @return \StructType\Put_Worktag_Split_Template_Restriction_ResponseType|bool
     */
    public function Put_Worktag_Split_Template_Restriction(\StructType\Put_Worktag_Split_Template_Restriction_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Worktag_Split_Template_Restriction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Worktag_Split_Template
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Task that allows creation of Worktag Split Template Criteria through Web ServiceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Worktag_Split_Template_RequestType $body
     * @return \StructType\Put_Worktag_Split_Template_ResponseType|bool
     */
    public function Put_Worktag_Split_Template(\StructType\Put_Worktag_Split_Template_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Worktag_Split_Template($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Receivable_Repayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Receivable Repayment. Receivable Repayment data includes Date, Business Purpose, Spend Authorization, Total Amount, Payment Type, Memo, and Expense Report Lines. The data for the lines
     * includes ID, Document Status, Expense payee, Company, Date, Amount, Currency, Payment Type, Payment Reference, Memo, Expense Reports being paid.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Receivable_Repayment_RequestType $body
     * @return \StructType\Put_Receivable_Repayment_ResponseType|bool
     */
    public function Put_Receivable_Repayment(\StructType\Put_Receivable_Repayment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Receivable_Repayment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Tax_Certificate_Numbers_On_Supplier_Payment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put Tax Certificate Numbers On Supplier PaymentNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType $body
     * @return \StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_ResponseType|bool
     */
    public function Put_Tax_Certificate_Numbers_On_Supplier_Payment(\StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Tax_Certificate_Numbers_On_Supplier_Payment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Commodity_Code_Type
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Add or modify commodity code types.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Commodity_Code_Type_RequestType $body
     * @return \StructType\Put_Commodity_Code_Type_ResponseType|bool
     */
    public function Put_Commodity_Code_Type(\StructType\Put_Commodity_Code_Type_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Commodity_Code_Type($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Invoice_Work_Queue_Tag
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will allow setup of supplier invoice work queue tags that can be associated with a supplier invoice document. Supplier invoice work queue tags will be used for reporting and management of work flow. Supplier invoice work
     * queue tag data will include name, description, urgent boolean, and inactive boolean.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_ResponseType|bool
     */
    public function Put_Supplier_Invoice_Work_Queue_Tag(\StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_Work_Queue_Tag($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Commodity_Code
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to create or edit a Commodity Code. To create a Commodity Code, provide Code, Description and optionally Short Description, Parent Commodity Code and Spend Categories. If Parent Commodity Code
     * is not provided, this Web Service operation will auto-create the hierarchical structure of Commodity Codes. A subsequent operation can be used to update the Description\Short Description of the superior Commodity Codes that are created
     * automatically.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Commodity_Code_RequestType $body
     * @return \StructType\Put_Commodity_Code_ResponseType|bool
     */
    public function Put_Commodity_Code(\StructType\Put_Commodity_Code_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Commodity_Code($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation maintains Supplier Invoice Work Queue Tag Assignment Rules associated with a supplier invoice document. Supplier Invoice Work Queue Tag Assignment Rules include work queue tags, payment terms, suppliers, supplier
     * categories, supplier group, purchase order and non-purchase order invoice options, priority scanning, greater than amount, currency.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_ResponseType|bool
     */
    public function Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule(\StructType\Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Invoice_Assignment_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation maintains Supplier Invoice Assignment Rules associated with a supplier invoice document. Supplier Invoice Assignment Rules include work queue tags, suppliers, supplier categories, supplier group, company, assignee,
     * greater than amount, and currency.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_Assignment_Rule_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_Assignment_Rule_ResponseType|bool
     */
    public function Put_Supplier_Invoice_Assignment_Rule(\StructType\Put_Supplier_Invoice_Assignment_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_Assignment_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Assign_Supplier_to_Contingent_Worker
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds supplier to existing, already hired contingent workers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Assign_Supplier_to_Contingent_Worker_RequestType $body
     * @return \StructType\Put_Assign_Supplier_to_Contingent_Worker_ResponseType|bool
     */
    public function Put_Assign_Supplier_to_Contingent_Worker(\StructType\Put_Assign_Supplier_to_Contingent_Worker_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Assign_Supplier_to_Contingent_Worker($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Procurement_Conditional_Rule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will add or update Procurement Conditional Rule(s). A Procurement Conditional Rule Request contains a Procurement Conditional Rules Context and the Procurement Conditional Rule Data. Each Procurement
     * Conditional Rule Data contains the conditional rule's reference id, the context name and many conditional rules which are made up of Condition Items that make up the logic used in the Procurement Conditional Rule.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Procurement_Conditional_Rule_RequestType $body
     * @return \StructType\Put_Procurement_Conditional_Rule_ResponseType|bool
     */
    public function Put_Procurement_Conditional_Rule(\StructType\Put_Procurement_Conditional_Rule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Procurement_Conditional_Rule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Project_Budget_Template
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will create or modify Project Budget Templates. A Project Budget Template is used to define default budget plan lines for Project Budgets.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Project_Budget_Template_RequestType $body
     * @return \StructType\Put_Project_Budget_Template_ResponseType|bool
     */
    public function Put_Project_Budget_Template(\StructType\Put_Project_Budget_Template_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Project_Budget_Template($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Purchase_Item_Request_Type
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates the request types for updating purchase item information or creating new purchase items. You can submit purchase item request templates, questionnaires (optional), and the request task to use for the purchase item request
     * type.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Item_Request_Type_RequestType $body
     * @return \StructType\Put_Purchase_Item_Request_Type_ResponseType|bool
     */
    public function Put_Purchase_Item_Request_Type(\StructType\Put_Purchase_Item_Request_Type_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Item_Request_Type($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Purchase_Item_Request_Template
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put Purchase Item Request Template -Creates or updates workbook templates for purchase item requests which enable you to configure the required item information before processing requests. You can select from these options of item
     * information for purchase item request templates:Purchase Item InformationSupplier Item InformationAdvanced PricingSupplier UOM and PricingNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Item_Request_Template_RequestType $body
     * @return \StructType\Put_Purchase_Item_Request_Template_ResponseType|bool
     */
    public function Put_Purchase_Item_Request_Template(\StructType\Put_Purchase_Item_Request_Template_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Item_Request_Template($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_External_Transaction_Source
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Task that allows creation of an External Transaction Source through Web Service.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_External_Transaction_Source_RequestType $body
     * @return \StructType\Put_External_Transaction_Source_ResponseType|bool
     */
    public function Put_External_Transaction_Source(\StructType\Put_External_Transaction_Source_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_External_Transaction_Source($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_External_Reference_on_Spend_Transaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Use this WWS operation to update an existing Supplier Contract, Supplier and Custom Supplier Classification Interface in Workday Procurement to indicate that it originated from an external system. The Request Data element includes a
     * reference to a Supplier Contract, Supplier and Custom Supplier Classification Interface along with a reference to the External System and the External Reference ID. Note that only Supplier Contracts, Supplier and Custom Supplier Classification
     * Interface that currently do not have External System Reference set on them are eligible for this WWS operation.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_External_Reference_on_Spend_Transaction_RequestType $body
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_ResponseType|bool
     */
    public function Put_External_Reference_on_Spend_Transaction(\StructType\Put_External_Reference_on_Spend_Transaction_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_External_Reference_on_Spend_Transaction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Requesting_Entity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Create or update requesting entities. You can update requesting entity default values and the restricted purchase items or restricted purchase item lists they have access to.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Requesting_Entity_RequestType $body
     * @return \StructType\Put_Requesting_Entity_ResponseType|bool
     */
    public function Put_Requesting_Entity(\StructType\Put_Requesting_Entity_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Requesting_Entity($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Purchase_Item_List
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates or updates restricted purchase item lists. You can also process restricted purchase item lists in bulk. This operation can add or remove items when you update the restricted purchase item list by replacing the details with
     * the request data. Workday removes an item from the restricted purchase item list when you update a list and exclude an existing item. This operation also enables you to restrict use of items on the lists to specific requesting entities. Access the
     * Maintain Purchase Item Lists task when you need to create or update purchase item lists in Workday.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Purchase_Item_List_RequestType $body
     * @return \StructType\Put_Purchase_Item_List_ResponseType|bool
     */
    public function Put_Purchase_Item_List(\StructType\Put_Purchase_Item_List_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Purchase_Item_List($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Web_Item_Attributes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to create or edit a mapping between an existing web item and a purchase item.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Web_Item_Attributes_RequestType $body
     * @return \StructType\Put_Web_Item_Attributes_ResponseType|bool
     */
    public function Put_Web_Item_Attributes(\StructType\Put_Web_Item_Attributes_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Web_Item_Attributes($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_External_Business_Entity_Contact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates or updates contact information for External Business Entities. The data created or updated includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier), the Personal Data including Name Detail
     * data, Contact Information and Workday Account Creation Options data. Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix. Contact Information data includes Address,
     * Phone, Email, Instance Messenger and Web Address data.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_External_Business_Entity_Contact_RequestType $body
     * @return \StructType\Put_External_Business_Entity_Contact_ResponseType|bool
     */
    public function Put_External_Business_Entity_Contact(\StructType\Put_External_Business_Entity_Contact_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_External_Business_Entity_Contact($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Supplier_Invoice_System_Validation_Configuration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will set the source for the validation that you want to trigger after you submit supplier invoices through an integration. When you submit an integration for the selected source, Workday creates a supplier
     * invoice in Draft status and redirects the invoice to the Supplier Invoice Work Area. Correct the invoice to complete the business process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_System_Validation_Configuration_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_System_Validation_Configuration_ResponseType|bool
     */
    public function Put_Supplier_Invoice_System_Validation_Configuration(\StructType\Put_Supplier_Invoice_System_Validation_Configuration_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_System_Validation_Configuration($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Carriers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Use this web service operation to insert and update Carrier information.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Carriers_RequestType $body
     * @return \StructType\Put_Carriers_ResponseType|bool
     */
    public function Put_Carriers(\StructType\Put_Carriers_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Carriers($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Supplier_Invoice_Links
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Updates the document link field of Supplier Invoices of the following statuses Draft, Approved, In Progress, Incomplete, Denied, Canceled, and Paid. It will only be updating the document link field, no other part of the Supplier
     * Invoice will be updated.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Supplier_Invoice_Links_RequestType $body
     * @return \StructType\Put_Supplier_Invoice_Links_ResponseType|bool
     */
    public function Put_Supplier_Invoice_Links(\StructType\Put_Supplier_Invoice_Links_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Supplier_Invoice_Links($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Put_Airline_ResponseType|\StructType\Put_Airport_ResponseType|\StructType\Put_Asset_Book_Rules_ResponseType|\StructType\Put_Asset_Pooling_Rule_ResponseType|\StructType\Put_Assign_Supplier_to_Contingent_Worker_ResponseType|\StructType\Put_Business_Entity_Contact_ResponseType|\StructType\Put_Card_Holder_Listing_File_ResponseType|\StructType\Put_Carriers_ResponseType|\StructType\Put_Car_Rental_Agency_ResponseType|\StructType\Put_Cash_Advance_Repayment_ResponseType|\StructType\Put_Commodity_Code_ResponseType|\StructType\Put_Commodity_Code_Type_ResponseType|\StructType\Put_Company_Asset_Book_Restrictions_ResponseType|\StructType\Put_Corporate_Credit_Card_Billing_Account_ResponseType|\StructType\Put_Credit_Card_Code_Mapping_ResponseType|\StructType\Put_Credit_Card_Transaction_File_ResponseType|\StructType\Put_Expense_Company_Default_ResponseType|\StructType\Put_Expense_Credit_Card_ResponseType|\StructType\Put_Expense_Credit_Card_Transaction_ResponseType|\StructType\Put_Expense_Item_Attribute_Group_ResponseType|\StructType\Put_Expense_Item_Group_ResponseType|\StructType\Put_Expense_Item_ResponseType|\StructType\Put_Expense_Policy_Group_ResponseType|\StructType\Put_Expense_Rate_Table_Rule_ResponseType|\StructType\Put_External_Business_Entity_Contact_ResponseType|\StructType\Put_External_Reference_on_Spend_Transaction_ResponseType|\StructType\Put_External_Transaction_Source_ResponseType|\StructType\Put_Hotel_ResponseType|\StructType\Put_Internal_Catalog_ResponseType|\StructType\Put_Internal_Service_Provider_ResponseType|\StructType\Put_Invoice_Types_ResponseType|\StructType\Put_Item_Identifier_Type_ResponseType|\StructType\Put_Item_Tag_ResponseType|\StructType\Put_Location_Customer_Account_Number_Detail_ResponseType|\StructType\Put_OCR_Supplier_Invoice_ResponseType|\StructType\Put_Patient_Charge_Information_ResponseType|\StructType\Put_Procurement_Conditional_Rule_ResponseType|\StructType\Put_Procurement_Document_Attachment_ResponseType|\StructType\Put_Project_Asset_ResponseType|\StructType\Put_Project_Budget_Template_ResponseType|\StructType\Put_Project_Phase_ResponseType|\StructType\Put_Project_Plan_ResponseType|\StructType\Put_Project_Portfolio_ResponseType|\StructType\Put_Project_Role_Category_ResponseType|\StructType\Put_Project_Standard_Cost_Rate_Sheet_ResponseType|\StructType\Put_Project_Task_Resources_ResponseType|\StructType\Put_Project_Task_ResponseType|\StructType\Put_Project_Worker_Role_ResponseType|\StructType\Put_Purchase_Item_Group_ResponseType|\StructType\Put_Purchase_Item_List_ResponseType|\StructType\Put_Purchase_Item_Request_Template_ResponseType|\StructType\Put_Purchase_Item_Request_Type_ResponseType|\StructType\Put_Purchase_Item_ResponseType|\StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType|\StructType\Put_Receivable_Repayment_ResponseType|\StructType\Put_Requesting_Entity_ResponseType|\StructType\Put_Requirements_for_Resource_Plan_Line_ResponseType|\StructType\Put_Requisition_Additional_Data_ResponseType|\StructType\Put_Requisition_Line_Additional_Data_ResponseType|\StructType\Put_Requisition_Sourcing_Rule_ResponseType|\StructType\Put_Requisition_Template_ResponseType|\StructType\Put_Resource_Category_ResponseType|\StructType\Put_Resource_Pool_Hierarchy_ResponseType|\StructType\Put_Resource_Pool_ResponseType|\StructType\Put_Revenue_Center_ResponseType|\StructType\Put_Spend_Category_Hierarchy_ResponseType|\StructType\Put_Supplier_Catalog_ResponseType|\StructType\Put_Supplier_Category_ResponseType|\StructType\Put_Supplier_Classification_ResponseType|\StructType\Put_Supplier_Contract_Document_Link_ResponseType|\StructType\Put_Supplier_Group_ResponseType|\StructType\Put_Supplier_Invoice_Assignment_Rule_ResponseType|\StructType\Put_Supplier_Invoice_History_ResponseType|\StructType\Put_Supplier_Invoice_Line_Additional_Data_ResponseType|\StructType\Put_Supplier_Invoice_Links_ResponseType|\StructType\Put_Supplier_Invoice_System_Validation_Configuration_ResponseType|\StructType\Put_Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_ResponseType|\StructType\Put_Supplier_Invoice_Work_Queue_Tag_ResponseType|\StructType\Put_Supplier_Payment_Memo_ResponseType|\StructType\Put_Supplier_ResponseType|\StructType\Put_Tax_Certificate_Numbers_On_Supplier_Payment_ResponseType|\StructType\Put_Transfer_Pricing_Rate_Sheet_ResponseType|\StructType\Put_Travel_City_ResponseType|\StructType\Put_Web_Item_Attributes_ResponseType|\StructType\Put_Worker_Utilization_Target_Sheet_ResponseType|\StructType\Put_Worktag_Split_Template_ResponseType|\StructType\Put_Worktag_Split_Template_Restriction_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
