<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Workday_Account_Creation_Options_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Define Primary Work Email. A Primary Work Email is required to create a Workday account. | Workday Account Creation Options Data.
 * @subpackage Structs
 */
class Workday_Account_Creation_Options_DataType extends AbstractStructBase
{
    /**
     * The Create_Workday_Account
     * Meta information extracted from the WSDL
     * - documentation: Create Workday Account. This flag will trigger the creation of the Workday Account.
     * - minOccurs: 0
     * @var bool
     */
    public $Create_Workday_Account;
    /**
     * Constructor method for Workday_Account_Creation_Options_DataType
     * @uses Workday_Account_Creation_Options_DataType::setCreate_Workday_Account()
     * @param bool $create_Workday_Account
     */
    public function __construct($create_Workday_Account = null)
    {
        $this
            ->setCreate_Workday_Account($create_Workday_Account);
    }
    /**
     * Get Create_Workday_Account value
     * @return bool|null
     */
    public function getCreate_Workday_Account()
    {
        return $this->Create_Workday_Account;
    }
    /**
     * Set Create_Workday_Account value
     * @param bool $create_Workday_Account
     * @return \StructType\Workday_Account_Creation_Options_DataType
     */
    public function setCreate_Workday_Account($create_Workday_Account = null)
    {
        // validation for constraint: boolean
        if (!is_null($create_Workday_Account) && !is_bool($create_Workday_Account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($create_Workday_Account, true), gettype($create_Workday_Account)), __LINE__);
        }
        $this->Create_Workday_Account = $create_Workday_Account;
        return $this;
    }
}
