<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restricted_Purchase_Item_List_Outbound_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that includes Restricted Purchase Item List instance and Data.
 * @subpackage Structs
 */
class Restricted_Purchase_Item_List_Outbound_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_List_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Restricted Purchase Item List
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_ListObjectType
     */
    public $Purchase_Item_List_Reference;
    /**
     * The Purchase_Item_List_Data
     * Meta information extracted from the WSDL
     * - documentation: Restricted Purchase Item List Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_List_DataType[]
     */
    public $Purchase_Item_List_Data;
    /**
     * Constructor method for Restricted_Purchase_Item_List_Outbound_DataType
     * @uses Restricted_Purchase_Item_List_Outbound_DataType::setPurchase_Item_List_Reference()
     * @uses Restricted_Purchase_Item_List_Outbound_DataType::setPurchase_Item_List_Data()
     * @param \StructType\Restricted_Purchase_Item_ListObjectType $purchase_Item_List_Reference
     * @param \StructType\Restricted_Purchase_Item_List_DataType[] $purchase_Item_List_Data
     */
    public function __construct(\StructType\Restricted_Purchase_Item_ListObjectType $purchase_Item_List_Reference = null, array $purchase_Item_List_Data = array())
    {
        $this
            ->setPurchase_Item_List_Reference($purchase_Item_List_Reference)
            ->setPurchase_Item_List_Data($purchase_Item_List_Data);
    }
    /**
     * Get Purchase_Item_List_Reference value
     * @return \StructType\Restricted_Purchase_Item_ListObjectType|null
     */
    public function getPurchase_Item_List_Reference()
    {
        return $this->Purchase_Item_List_Reference;
    }
    /**
     * Set Purchase_Item_List_Reference value
     * @param \StructType\Restricted_Purchase_Item_ListObjectType $purchase_Item_List_Reference
     * @return \StructType\Restricted_Purchase_Item_List_Outbound_DataType
     */
    public function setPurchase_Item_List_Reference(\StructType\Restricted_Purchase_Item_ListObjectType $purchase_Item_List_Reference = null)
    {
        $this->Purchase_Item_List_Reference = $purchase_Item_List_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_List_Data value
     * @return \StructType\Restricted_Purchase_Item_List_DataType[]|null
     */
    public function getPurchase_Item_List_Data()
    {
        return $this->Purchase_Item_List_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_List_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_List_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_List_DataForArrayConstraintsFromSetPurchase_Item_List_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem instanceof \StructType\Restricted_Purchase_Item_List_DataType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem) ? get_class($restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem), var_export($restricted_Purchase_Item_List_Outbound_DataTypePurchase_Item_List_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_List_Data property can only contain items of type \StructType\Restricted_Purchase_Item_List_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_List_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_List_DataType[] $purchase_Item_List_Data
     * @return \StructType\Restricted_Purchase_Item_List_Outbound_DataType
     */
    public function setPurchase_Item_List_Data(array $purchase_Item_List_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_List_DataArrayErrorMessage = self::validatePurchase_Item_List_DataForArrayConstraintsFromSetPurchase_Item_List_Data($purchase_Item_List_Data))) {
            throw new \InvalidArgumentException($purchase_Item_List_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_List_Data = $purchase_Item_List_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Item_List_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_List_DataType $item
     * @return \StructType\Restricted_Purchase_Item_List_Outbound_DataType
     */
    public function addToPurchase_Item_List_Data(\StructType\Restricted_Purchase_Item_List_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_List_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_List_Data property can only contain items of type \StructType\Restricted_Purchase_Item_List_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_List_Data[] = $item;
        return $this;
    }
}
