<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Catalog_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Supplier Catalog, or change 'Add Only' to 'false' to edit the Supplier Catalog. | Element to capture Supplier Catalog data.
 * @subpackage Structs
 */
class Put_Supplier_Catalog_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Catalog.
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogObjectType
     */
    public $Supplier_Catalog_Reference;
    /**
     * The Supplier_Catalog_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Supplier Catalog data.
     * - minOccurs: 0
     * @var \StructType\Supplier_Catalog_DataType
     */
    public $Supplier_Catalog_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Catalog_RequestType
     * @uses Put_Supplier_Catalog_RequestType::setSupplier_Catalog_Reference()
     * @uses Put_Supplier_Catalog_RequestType::setSupplier_Catalog_Data()
     * @uses Put_Supplier_Catalog_RequestType::setAdd_Only()
     * @uses Put_Supplier_Catalog_RequestType::setVersion()
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @param \StructType\Supplier_Catalog_DataType $supplier_Catalog_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null, \StructType\Supplier_Catalog_DataType $supplier_Catalog_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference)
            ->setSupplier_Catalog_Data($supplier_Catalog_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Supplier_CatalogObjectType|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @return \StructType\Put_Supplier_Catalog_RequestType
     */
    public function setSupplier_Catalog_Reference(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null)
    {
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Get Supplier_Catalog_Data value
     * @return \StructType\Supplier_Catalog_DataType|null
     */
    public function getSupplier_Catalog_Data()
    {
        return $this->Supplier_Catalog_Data;
    }
    /**
     * Set Supplier_Catalog_Data value
     * @param \StructType\Supplier_Catalog_DataType $supplier_Catalog_Data
     * @return \StructType\Put_Supplier_Catalog_RequestType
     */
    public function setSupplier_Catalog_Data(\StructType\Supplier_Catalog_DataType $supplier_Catalog_Data = null)
    {
        $this->Supplier_Catalog_Data = $supplier_Catalog_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_Catalog_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Catalog_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
