<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Purchase Item data
 * @subpackage Structs
 */
class Purchase_Item_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item ID. This is the Purchase Item unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_ID;
    /**
     * The Item_Name
     * Meta information extracted from the WSDL
     * - documentation: Purchase item name is already used. | Free form text field for meaningful Purchase Item Name
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Name;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Instances associated with the Purchase or Catalog Item. Commodity code is a standard code that identifies the type of goods or service. Example of standard commodity code types are UNSPSC, NIGP etc. The commodity code
     * needs to be active and not a parent code to associate to the item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType[]
     */
    public $Commodity_Code_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the spend category. A spend category is a classification of items and services that drive the accounting. All expense items are associated with a Spend Category and sales items are associated with a
     * Revenue Category.If a value is provided for sales item, revenue category will default so it is recommended to provide a value for either sales item or revenue category but not both. It is required if sales item is blank.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Last_Updated
     * Meta information extracted from the WSDL
     * - documentation: The exact moment in time this purchase item was last functionally updated - Cannot be updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text for Purchase Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Free form test for Item Identifier. This is not the Item Reference ID, but a non-unique field for providing addition Item identification data.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Identifier;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item tags for the Purchase Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String for the Purchase Item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Item_Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Currency field for Item Unit Price | Unit Price.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Item_Unit_Price;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability from the sales item. If the invoice line has a tax code then tax applicability
     * is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Accounting Treatment
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Default_as_Service_Request
     * Meta information extracted from the WSDL
     * - documentation: Create as a Service Request Line on the Requisition if adding the Purchase Item via Search Catalog or Add to Cart button. If the flag is false, it will create as a Goods Request Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_as_Service_Request;
    /**
     * The Purchase_Item_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item Group. Assign purchase items to item groups to make it easier to search for and select items. Purchase items can belong to multiple groups.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_GroupObjectType[]
     */
    public $Purchase_Item_Group_Reference;
    /**
     * The Related_Worktags_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType
     */
    public $Related_Worktags_Data;
    /**
     * The Preferred_Item
     * Meta information extracted from the WSDL
     * - documentation: Controls whether the purchase item is preferred in requisition search.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Preferred_Item;
    /**
     * The Unit_of_Measure_Set_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Unit of Measure Set
     * - minOccurs: 0
     * @var \StructType\Unit_of_Measure_SetObjectType
     */
    public $Unit_of_Measure_Set_Reference;
    /**
     * The Base_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Base Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Base_Unit_of_Measure_Reference;
    /**
     * The Lot_Control
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if a Purchase Item is Lot Control.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Lot_Control;
    /**
     * The Serial_Control_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Serial Control Method
     * - minOccurs: 0
     * @var \StructType\Serial_Control_MethodObjectType
     */
    public $Serial_Control_Method_Reference;
    /**
     * The Is_Manufacturer_Required
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if Manufacturer is required on the Lot for the Purchase Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Manufacturer_Required;
    /**
     * The Use_Item_Manufacturers_Only
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the Item Lot can have only Item Manufacturers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Item_Manufacturers_Only;
    /**
     * The Is_Expiration_Date_Required
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if Expiration Date is required for an item lot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Expiration_Date_Required;
    /**
     * The Inbound_Alert_Period_in_Days
     * Meta information extracted from the WSDL
     * - documentation: Numeric Field to define Tolerance Periods for Purchase Items on Inbound tasks.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 50
     * @var float
     */
    public $Inbound_Alert_Period_in_Days;
    /**
     * The Outbound_Alert_Period_in_Days
     * Meta information extracted from the WSDL
     * - documentation: Numeric field to define alert period in days for purchase items on outbound tasks.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 50
     * @var float
     */
    public $Outbound_Alert_Period_in_Days;
    /**
     * The Requisition_Fulfillment_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Fulfillment Requisition Source for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Requisition_SourceObjectType
     */
    public $Requisition_Fulfillment_Source_Reference;
    /**
     * The Alternate_Item_Identifiers_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Alternate Item Identifiers Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Item_Identifiers_DataType[]
     */
    public $Alternate_Item_Identifiers_Data;
    /**
     * The Purchase_Item_Unit_of_Measure_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Stocking Unit of Measures
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Unit_of_Measure_DataType[]
     */
    public $Purchase_Item_Unit_of_Measure_Data;
    /**
     * The Supplier_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Priority_Ranked_Supplier_Item_DataType[]
     */
    public $Supplier_Item_Data;
    /**
     * The Item_Inventory_Attributes_Data
     * Meta information extracted from the WSDL
     * - documentation: Added Patient Chargeable flag to Inventory Site Options
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Inventory_Attributes_DataType[]
     */
    public $Item_Inventory_Attributes_Data;
    /**
     * The Purchase_Item_Substitute_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Substitute_DataType
     */
    public $Purchase_Item_Substitute_Data;
    /**
     * The Primary_Image_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Primary_Image_DataType
     */
    public $Primary_Image_Data;
    /**
     * The Additional_Image_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Additional_Image_DataType[]
     */
    public $Additional_Image_Data;
    /**
     * The Maps_To_Sales_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Sales Item being mapped.
     * - minOccurs: 0
     * @var \StructType\Sales_ItemObjectType
     */
    public $Maps_To_Sales_Item_Reference;
    /**
     * The Item_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Associated Item Status of the Purchase Item.Active: Available for spend transactions.Restricted from Purchasing: Item can't be purchased but can still be requested and fulfilled from available stock.Inactive: Item no longer available
     * for use.
     * - minOccurs: 0
     * @var \StructType\Spend_Item_StatusObjectType
     */
    public $Item_Status_Reference;
    /**
     * The Requesting_Entity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Active requesting entities for purchase item. Inactive requesting entities are allowed if requesting entities were inactivated after assigned to a purchase item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requesting_EntityObjectType[]
     */
    public $Requesting_Entity_Reference;
    /**
     * The Purchase_Item_List_Reference
     * Meta information extracted from the WSDL
     * - documentation: Active purchase item lists for purchase item. Inactive purchase item lists are allowed if purchase item lists were inactivated after assigned to a purchase item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_ListObjectType[]
     */
    public $Purchase_Item_List_Reference;
    /**
     * Constructor method for Purchase_Item_DataType
     * @uses Purchase_Item_DataType::setPurchase_Item_ID()
     * @uses Purchase_Item_DataType::setItem_Name()
     * @uses Purchase_Item_DataType::setCommodity_Code_Reference()
     * @uses Purchase_Item_DataType::setResource_Category_Reference()
     * @uses Purchase_Item_DataType::setLast_Updated()
     * @uses Purchase_Item_DataType::setItem_Description()
     * @uses Purchase_Item_DataType::setItem_Identifier()
     * @uses Purchase_Item_DataType::setItem_URL()
     * @uses Purchase_Item_DataType::setItem_Tag_Reference()
     * @uses Purchase_Item_DataType::setPackaging_String()
     * @uses Purchase_Item_DataType::setItem_Unit_Price()
     * @uses Purchase_Item_DataType::setCurrency_Reference()
     * @uses Purchase_Item_DataType::setTax_Applicability_Reference()
     * @uses Purchase_Item_DataType::setAccounting_Treatment_Reference()
     * @uses Purchase_Item_DataType::setDefault_as_Service_Request()
     * @uses Purchase_Item_DataType::setPurchase_Item_Group_Reference()
     * @uses Purchase_Item_DataType::setRelated_Worktags_Data()
     * @uses Purchase_Item_DataType::setPreferred_Item()
     * @uses Purchase_Item_DataType::setUnit_of_Measure_Set_Reference()
     * @uses Purchase_Item_DataType::setBase_Unit_of_Measure_Reference()
     * @uses Purchase_Item_DataType::setLot_Control()
     * @uses Purchase_Item_DataType::setSerial_Control_Method_Reference()
     * @uses Purchase_Item_DataType::setIs_Manufacturer_Required()
     * @uses Purchase_Item_DataType::setUse_Item_Manufacturers_Only()
     * @uses Purchase_Item_DataType::setIs_Expiration_Date_Required()
     * @uses Purchase_Item_DataType::setInbound_Alert_Period_in_Days()
     * @uses Purchase_Item_DataType::setOutbound_Alert_Period_in_Days()
     * @uses Purchase_Item_DataType::setRequisition_Fulfillment_Source_Reference()
     * @uses Purchase_Item_DataType::setAlternate_Item_Identifiers_Data()
     * @uses Purchase_Item_DataType::setPurchase_Item_Unit_of_Measure_Data()
     * @uses Purchase_Item_DataType::setSupplier_Item_Data()
     * @uses Purchase_Item_DataType::setItem_Inventory_Attributes_Data()
     * @uses Purchase_Item_DataType::setPurchase_Item_Substitute_Data()
     * @uses Purchase_Item_DataType::setPrimary_Image_Data()
     * @uses Purchase_Item_DataType::setAdditional_Image_Data()
     * @uses Purchase_Item_DataType::setMaps_To_Sales_Item_Reference()
     * @uses Purchase_Item_DataType::setItem_Status_Reference()
     * @uses Purchase_Item_DataType::setRequesting_Entity_Reference()
     * @uses Purchase_Item_DataType::setPurchase_Item_List_Reference()
     * @param string $purchase_Item_ID
     * @param string $item_Name
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param string $last_Updated
     * @param string $item_Description
     * @param string $item_Identifier
     * @param string $item_URL
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @param string $packaging_String
     * @param float $item_Unit_Price
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param bool $default_as_Service_Request
     * @param \StructType\Purchase_Item_GroupObjectType[] $purchase_Item_Group_Reference
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data
     * @param bool $preferred_Item
     * @param \StructType\Unit_of_Measure_SetObjectType $unit_of_Measure_Set_Reference
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @param bool $lot_Control
     * @param \StructType\Serial_Control_MethodObjectType $serial_Control_Method_Reference
     * @param bool $is_Manufacturer_Required
     * @param bool $use_Item_Manufacturers_Only
     * @param bool $is_Expiration_Date_Required
     * @param float $inbound_Alert_Period_in_Days
     * @param float $outbound_Alert_Period_in_Days
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @param \StructType\Purchase_Item_Unit_of_Measure_DataType[] $purchase_Item_Unit_of_Measure_Data
     * @param \StructType\Priority_Ranked_Supplier_Item_DataType[] $supplier_Item_Data
     * @param \StructType\Item_Inventory_Attributes_DataType[] $item_Inventory_Attributes_Data
     * @param \StructType\Purchase_Item_Substitute_DataType $purchase_Item_Substitute_Data
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @param \StructType\Sales_ItemObjectType $maps_To_Sales_Item_Reference
     * @param \StructType\Spend_Item_StatusObjectType $item_Status_Reference
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entity_Reference
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     */
    public function __construct($purchase_Item_ID = null, $item_Name = null, array $commodity_Code_Reference = array(), \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, $last_Updated = null, $item_Description = null, $item_Identifier = null, $item_URL = null, array $item_Tag_Reference = array(), $packaging_String = null, $item_Unit_Price = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, $default_as_Service_Request = null, array $purchase_Item_Group_Reference = array(), \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data = null, $preferred_Item = null, \StructType\Unit_of_Measure_SetObjectType $unit_of_Measure_Set_Reference = null, \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null, $lot_Control = null, \StructType\Serial_Control_MethodObjectType $serial_Control_Method_Reference = null, $is_Manufacturer_Required = null, $use_Item_Manufacturers_Only = null, $is_Expiration_Date_Required = null, $inbound_Alert_Period_in_Days = null, $outbound_Alert_Period_in_Days = null, \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null, array $alternate_Item_Identifiers_Data = array(), array $purchase_Item_Unit_of_Measure_Data = array(), array $supplier_Item_Data = array(), array $item_Inventory_Attributes_Data = array(), \StructType\Purchase_Item_Substitute_DataType $purchase_Item_Substitute_Data = null, \StructType\Primary_Image_DataType $primary_Image_Data = null, array $additional_Image_Data = array(), \StructType\Sales_ItemObjectType $maps_To_Sales_Item_Reference = null, \StructType\Spend_Item_StatusObjectType $item_Status_Reference = null, array $requesting_Entity_Reference = array(), array $purchase_Item_List_Reference = array())
    {
        $this
            ->setPurchase_Item_ID($purchase_Item_ID)
            ->setItem_Name($item_Name)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setLast_Updated($last_Updated)
            ->setItem_Description($item_Description)
            ->setItem_Identifier($item_Identifier)
            ->setItem_URL($item_URL)
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setPackaging_String($packaging_String)
            ->setItem_Unit_Price($item_Unit_Price)
            ->setCurrency_Reference($currency_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setDefault_as_Service_Request($default_as_Service_Request)
            ->setPurchase_Item_Group_Reference($purchase_Item_Group_Reference)
            ->setRelated_Worktags_Data($related_Worktags_Data)
            ->setPreferred_Item($preferred_Item)
            ->setUnit_of_Measure_Set_Reference($unit_of_Measure_Set_Reference)
            ->setBase_Unit_of_Measure_Reference($base_Unit_of_Measure_Reference)
            ->setLot_Control($lot_Control)
            ->setSerial_Control_Method_Reference($serial_Control_Method_Reference)
            ->setIs_Manufacturer_Required($is_Manufacturer_Required)
            ->setUse_Item_Manufacturers_Only($use_Item_Manufacturers_Only)
            ->setIs_Expiration_Date_Required($is_Expiration_Date_Required)
            ->setInbound_Alert_Period_in_Days($inbound_Alert_Period_in_Days)
            ->setOutbound_Alert_Period_in_Days($outbound_Alert_Period_in_Days)
            ->setRequisition_Fulfillment_Source_Reference($requisition_Fulfillment_Source_Reference)
            ->setAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data)
            ->setPurchase_Item_Unit_of_Measure_Data($purchase_Item_Unit_of_Measure_Data)
            ->setSupplier_Item_Data($supplier_Item_Data)
            ->setItem_Inventory_Attributes_Data($item_Inventory_Attributes_Data)
            ->setPurchase_Item_Substitute_Data($purchase_Item_Substitute_Data)
            ->setPrimary_Image_Data($primary_Image_Data)
            ->setAdditional_Image_Data($additional_Image_Data)
            ->setMaps_To_Sales_Item_Reference($maps_To_Sales_Item_Reference)
            ->setItem_Status_Reference($item_Status_Reference)
            ->setRequesting_Entity_Reference($requesting_Entity_Reference)
            ->setPurchase_Item_List_Reference($purchase_Item_List_Reference);
    }
    /**
     * Get Purchase_Item_ID value
     * @return string|null
     */
    public function getPurchase_Item_ID()
    {
        return $this->Purchase_Item_ID;
    }
    /**
     * Set Purchase_Item_ID value
     * @param string $purchase_Item_ID
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPurchase_Item_ID($purchase_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_ID) && !is_string($purchase_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_ID, true), gettype($purchase_Item_ID)), __LINE__);
        }
        $this->Purchase_Item_ID = $purchase_Item_ID;
        return $this;
    }
    /**
     * Get Item_Name value
     * @return string|null
     */
    public function getItem_Name()
    {
        return $this->Item_Name;
    }
    /**
     * Set Item_Name value
     * @param string $item_Name
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Name($item_Name = null)
    {
        // validation for constraint: string
        if (!is_null($item_Name) && !is_string($item_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Name, true), gettype($item_Name)), __LINE__);
        }
        $this->Item_Name = $item_Name;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType[]|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeCommodity_Code_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeCommodity_Code_ReferenceItem instanceof \StructType\Commodity_CodeObjectType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeCommodity_Code_ReferenceItem) ? get_class($purchase_Item_DataTypeCommodity_Code_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeCommodity_Code_ReferenceItem), var_export($purchase_Item_DataTypeCommodity_Code_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setCommodity_Code_Reference(array $commodity_Code_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_ReferenceArrayErrorMessage = self::validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference($commodity_Code_Reference))) {
            throw new \InvalidArgumentException($commodity_Code_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_CodeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Last_Updated value
     * @return string|null
     */
    public function getLast_Updated()
    {
        return $this->Last_Updated;
    }
    /**
     * Set Last_Updated value
     * @param string $last_Updated
     * @return \StructType\Purchase_Item_DataType
     */
    public function setLast_Updated($last_Updated = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated) && !is_string($last_Updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated, true), gettype($last_Updated)), __LINE__);
        }
        $this->Last_Updated = $last_Updated;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeItem_Tag_ReferenceItem) ? get_class($purchase_Item_DataTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeItem_Tag_ReferenceItem), var_export($purchase_Item_DataTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Item_Unit_Price value
     * @return float|null
     */
    public function getItem_Unit_Price()
    {
        return $this->Item_Unit_Price;
    }
    /**
     * Set Item_Unit_Price value
     * @param float $item_Unit_Price
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Unit_Price($item_Unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($item_Unit_Price) && !(is_float($item_Unit_Price) || is_numeric($item_Unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($item_Unit_Price, true), gettype($item_Unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($item_Unit_Price) && mb_strlen(mb_substr($item_Unit_Price, false !== mb_strpos($item_Unit_Price, '.') ? mb_strpos($item_Unit_Price, '.') + 1 : mb_strlen($item_Unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($item_Unit_Price, true), mb_strlen(mb_substr($item_Unit_Price, mb_strpos($item_Unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($item_Unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($item_Unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price))), __LINE__);
        }
        $this->Item_Unit_Price = $item_Unit_Price;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Default_as_Service_Request value
     * @return bool|null
     */
    public function getDefault_as_Service_Request()
    {
        return $this->Default_as_Service_Request;
    }
    /**
     * Set Default_as_Service_Request value
     * @param bool $default_as_Service_Request
     * @return \StructType\Purchase_Item_DataType
     */
    public function setDefault_as_Service_Request($default_as_Service_Request = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_as_Service_Request) && !is_bool($default_as_Service_Request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_as_Service_Request, true), gettype($default_as_Service_Request)), __LINE__);
        }
        $this->Default_as_Service_Request = $default_as_Service_Request;
        return $this;
    }
    /**
     * Get Purchase_Item_Group_Reference value
     * @return \StructType\Purchase_Item_GroupObjectType[]|null
     */
    public function getPurchase_Item_Group_Reference()
    {
        return $this->Purchase_Item_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Group_ReferenceForArrayConstraintsFromSetPurchase_Item_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypePurchase_Item_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypePurchase_Item_Group_ReferenceItem instanceof \StructType\Purchase_Item_GroupObjectType) {
                $invalidValues[] = is_object($purchase_Item_DataTypePurchase_Item_Group_ReferenceItem) ? get_class($purchase_Item_DataTypePurchase_Item_Group_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypePurchase_Item_Group_ReferenceItem), var_export($purchase_Item_DataTypePurchase_Item_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Group_Reference property can only contain items of type \StructType\Purchase_Item_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupObjectType[] $purchase_Item_Group_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPurchase_Item_Group_Reference(array $purchase_Item_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Group_ReferenceArrayErrorMessage = self::validatePurchase_Item_Group_ReferenceForArrayConstraintsFromSetPurchase_Item_Group_Reference($purchase_Item_Group_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Group_Reference = $purchase_Item_Group_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupObjectType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToPurchase_Item_Group_Reference(\StructType\Purchase_Item_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Group_Reference property can only contain items of type \StructType\Purchase_Item_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Related_Worktags_Data value
     * @return \StructType\Related_Worktag_Widget_DataType|null
     */
    public function getRelated_Worktags_Data()
    {
        return $this->Related_Worktags_Data;
    }
    /**
     * Set Related_Worktags_Data value
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setRelated_Worktags_Data(\StructType\Related_Worktag_Widget_DataType $related_Worktags_Data = null)
    {
        $this->Related_Worktags_Data = $related_Worktags_Data;
        return $this;
    }
    /**
     * Get Preferred_Item value
     * @return bool|null
     */
    public function getPreferred_Item()
    {
        return $this->Preferred_Item;
    }
    /**
     * Set Preferred_Item value
     * @param bool $preferred_Item
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPreferred_Item($preferred_Item = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferred_Item) && !is_bool($preferred_Item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferred_Item, true), gettype($preferred_Item)), __LINE__);
        }
        $this->Preferred_Item = $preferred_Item;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Set_Reference value
     * @return \StructType\Unit_of_Measure_SetObjectType|null
     */
    public function getUnit_of_Measure_Set_Reference()
    {
        return $this->Unit_of_Measure_Set_Reference;
    }
    /**
     * Set Unit_of_Measure_Set_Reference value
     * @param \StructType\Unit_of_Measure_SetObjectType $unit_of_Measure_Set_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setUnit_of_Measure_Set_Reference(\StructType\Unit_of_Measure_SetObjectType $unit_of_Measure_Set_Reference = null)
    {
        $this->Unit_of_Measure_Set_Reference = $unit_of_Measure_Set_Reference;
        return $this;
    }
    /**
     * Get Base_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getBase_Unit_of_Measure_Reference()
    {
        return $this->Base_Unit_of_Measure_Reference;
    }
    /**
     * Set Base_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setBase_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null)
    {
        $this->Base_Unit_of_Measure_Reference = $base_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Lot_Control value
     * @return bool|null
     */
    public function getLot_Control()
    {
        return $this->Lot_Control;
    }
    /**
     * Set Lot_Control value
     * @param bool $lot_Control
     * @return \StructType\Purchase_Item_DataType
     */
    public function setLot_Control($lot_Control = null)
    {
        // validation for constraint: boolean
        if (!is_null($lot_Control) && !is_bool($lot_Control)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lot_Control, true), gettype($lot_Control)), __LINE__);
        }
        $this->Lot_Control = $lot_Control;
        return $this;
    }
    /**
     * Get Serial_Control_Method_Reference value
     * @return \StructType\Serial_Control_MethodObjectType|null
     */
    public function getSerial_Control_Method_Reference()
    {
        return $this->Serial_Control_Method_Reference;
    }
    /**
     * Set Serial_Control_Method_Reference value
     * @param \StructType\Serial_Control_MethodObjectType $serial_Control_Method_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setSerial_Control_Method_Reference(\StructType\Serial_Control_MethodObjectType $serial_Control_Method_Reference = null)
    {
        $this->Serial_Control_Method_Reference = $serial_Control_Method_Reference;
        return $this;
    }
    /**
     * Get Is_Manufacturer_Required value
     * @return bool|null
     */
    public function getIs_Manufacturer_Required()
    {
        return $this->Is_Manufacturer_Required;
    }
    /**
     * Set Is_Manufacturer_Required value
     * @param bool $is_Manufacturer_Required
     * @return \StructType\Purchase_Item_DataType
     */
    public function setIs_Manufacturer_Required($is_Manufacturer_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Manufacturer_Required) && !is_bool($is_Manufacturer_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Manufacturer_Required, true), gettype($is_Manufacturer_Required)), __LINE__);
        }
        $this->Is_Manufacturer_Required = $is_Manufacturer_Required;
        return $this;
    }
    /**
     * Get Use_Item_Manufacturers_Only value
     * @return bool|null
     */
    public function getUse_Item_Manufacturers_Only()
    {
        return $this->Use_Item_Manufacturers_Only;
    }
    /**
     * Set Use_Item_Manufacturers_Only value
     * @param bool $use_Item_Manufacturers_Only
     * @return \StructType\Purchase_Item_DataType
     */
    public function setUse_Item_Manufacturers_Only($use_Item_Manufacturers_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Item_Manufacturers_Only) && !is_bool($use_Item_Manufacturers_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Item_Manufacturers_Only, true), gettype($use_Item_Manufacturers_Only)), __LINE__);
        }
        $this->Use_Item_Manufacturers_Only = $use_Item_Manufacturers_Only;
        return $this;
    }
    /**
     * Get Is_Expiration_Date_Required value
     * @return bool|null
     */
    public function getIs_Expiration_Date_Required()
    {
        return $this->Is_Expiration_Date_Required;
    }
    /**
     * Set Is_Expiration_Date_Required value
     * @param bool $is_Expiration_Date_Required
     * @return \StructType\Purchase_Item_DataType
     */
    public function setIs_Expiration_Date_Required($is_Expiration_Date_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Expiration_Date_Required) && !is_bool($is_Expiration_Date_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Expiration_Date_Required, true), gettype($is_Expiration_Date_Required)), __LINE__);
        }
        $this->Is_Expiration_Date_Required = $is_Expiration_Date_Required;
        return $this;
    }
    /**
     * Get Inbound_Alert_Period_in_Days value
     * @return float|null
     */
    public function getInbound_Alert_Period_in_Days()
    {
        return $this->Inbound_Alert_Period_in_Days;
    }
    /**
     * Set Inbound_Alert_Period_in_Days value
     * @param float $inbound_Alert_Period_in_Days
     * @return \StructType\Purchase_Item_DataType
     */
    public function setInbound_Alert_Period_in_Days($inbound_Alert_Period_in_Days = null)
    {
        // validation for constraint: float
        if (!is_null($inbound_Alert_Period_in_Days) && !(is_float($inbound_Alert_Period_in_Days) || is_numeric($inbound_Alert_Period_in_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inbound_Alert_Period_in_Days, true), gettype($inbound_Alert_Period_in_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($inbound_Alert_Period_in_Days) && mb_strlen(mb_substr($inbound_Alert_Period_in_Days, false !== mb_strpos($inbound_Alert_Period_in_Days, '.') ? mb_strpos($inbound_Alert_Period_in_Days, '.') + 1 : mb_strlen($inbound_Alert_Period_in_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($inbound_Alert_Period_in_Days, true), mb_strlen(mb_substr($inbound_Alert_Period_in_Days, mb_strpos($inbound_Alert_Period_in_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($inbound_Alert_Period_in_Days) && $inbound_Alert_Period_in_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($inbound_Alert_Period_in_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(50)
        if (!is_null($inbound_Alert_Period_in_Days) && mb_strlen(preg_replace('/(\D)/', '', $inbound_Alert_Period_in_Days)) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 50 digits, "%d" given', var_export($inbound_Alert_Period_in_Days, true), mb_strlen(preg_replace('/(\D)/', '', $inbound_Alert_Period_in_Days))), __LINE__);
        }
        $this->Inbound_Alert_Period_in_Days = $inbound_Alert_Period_in_Days;
        return $this;
    }
    /**
     * Get Outbound_Alert_Period_in_Days value
     * @return float|null
     */
    public function getOutbound_Alert_Period_in_Days()
    {
        return $this->Outbound_Alert_Period_in_Days;
    }
    /**
     * Set Outbound_Alert_Period_in_Days value
     * @param float $outbound_Alert_Period_in_Days
     * @return \StructType\Purchase_Item_DataType
     */
    public function setOutbound_Alert_Period_in_Days($outbound_Alert_Period_in_Days = null)
    {
        // validation for constraint: float
        if (!is_null($outbound_Alert_Period_in_Days) && !(is_float($outbound_Alert_Period_in_Days) || is_numeric($outbound_Alert_Period_in_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($outbound_Alert_Period_in_Days, true), gettype($outbound_Alert_Period_in_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($outbound_Alert_Period_in_Days) && mb_strlen(mb_substr($outbound_Alert_Period_in_Days, false !== mb_strpos($outbound_Alert_Period_in_Days, '.') ? mb_strpos($outbound_Alert_Period_in_Days, '.') + 1 : mb_strlen($outbound_Alert_Period_in_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($outbound_Alert_Period_in_Days, true), mb_strlen(mb_substr($outbound_Alert_Period_in_Days, mb_strpos($outbound_Alert_Period_in_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($outbound_Alert_Period_in_Days) && $outbound_Alert_Period_in_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($outbound_Alert_Period_in_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(50)
        if (!is_null($outbound_Alert_Period_in_Days) && mb_strlen(preg_replace('/(\D)/', '', $outbound_Alert_Period_in_Days)) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 50 digits, "%d" given', var_export($outbound_Alert_Period_in_Days, true), mb_strlen(preg_replace('/(\D)/', '', $outbound_Alert_Period_in_Days))), __LINE__);
        }
        $this->Outbound_Alert_Period_in_Days = $outbound_Alert_Period_in_Days;
        return $this;
    }
    /**
     * Get Requisition_Fulfillment_Source_Reference value
     * @return \StructType\Requisition_SourceObjectType|null
     */
    public function getRequisition_Fulfillment_Source_Reference()
    {
        return $this->Requisition_Fulfillment_Source_Reference;
    }
    /**
     * Set Requisition_Fulfillment_Source_Reference value
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setRequisition_Fulfillment_Source_Reference(\StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null)
    {
        $this->Requisition_Fulfillment_Source_Reference = $requisition_Fulfillment_Source_Reference;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifiers_Data value
     * @return \StructType\Alternate_Item_Identifiers_DataType[]|null
     */
    public function getAlternate_Item_Identifiers_Data()
    {
        return $this->Alternate_Item_Identifiers_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifiers_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifiers_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem instanceof \StructType\Alternate_Item_Identifiers_DataType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem) ? get_class($purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem), var_export($purchase_Item_DataTypeAlternate_Item_Identifiers_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setAlternate_Item_Identifiers_Data(array $alternate_Item_Identifiers_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifiers_DataArrayErrorMessage = self::validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifiers_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data = $alternate_Item_Identifiers_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToAlternate_Item_Identifiers_Data(\StructType\Alternate_Item_Identifiers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Item_Identifiers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Unit_of_Measure_Data value
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType[]|null
     */
    public function getPurchase_Item_Unit_of_Measure_Data()
    {
        return $this->Purchase_Item_Unit_of_Measure_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Unit_of_Measure_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Unit_of_Measure_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Unit_of_Measure_DataForArrayConstraintsFromSetPurchase_Item_Unit_of_Measure_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem instanceof \StructType\Purchase_Item_Unit_of_Measure_DataType) {
                $invalidValues[] = is_object($purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem) ? get_class($purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem), var_export($purchase_Item_DataTypePurchase_Item_Unit_of_Measure_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Purchase_Item_Unit_of_Measure_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Unit_of_Measure_DataType[] $purchase_Item_Unit_of_Measure_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPurchase_Item_Unit_of_Measure_Data(array $purchase_Item_Unit_of_Measure_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Unit_of_Measure_DataArrayErrorMessage = self::validatePurchase_Item_Unit_of_Measure_DataForArrayConstraintsFromSetPurchase_Item_Unit_of_Measure_Data($purchase_Item_Unit_of_Measure_Data))) {
            throw new \InvalidArgumentException($purchase_Item_Unit_of_Measure_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Unit_of_Measure_Data = $purchase_Item_Unit_of_Measure_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Unit_of_Measure_DataType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToPurchase_Item_Unit_of_Measure_Data(\StructType\Purchase_Item_Unit_of_Measure_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Unit_of_Measure_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Purchase_Item_Unit_of_Measure_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Unit_of_Measure_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Item_Data value
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType[]|null
     */
    public function getSupplier_Item_Data()
    {
        return $this->Supplier_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeSupplier_Item_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeSupplier_Item_DataItem instanceof \StructType\Priority_Ranked_Supplier_Item_DataType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeSupplier_Item_DataItem) ? get_class($purchase_Item_DataTypeSupplier_Item_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeSupplier_Item_DataItem), var_export($purchase_Item_DataTypeSupplier_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Item_DataType[] $supplier_Item_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setSupplier_Item_Data(array $supplier_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_DataArrayErrorMessage = self::validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data($supplier_Item_Data))) {
            throw new \InvalidArgumentException($supplier_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Data = $supplier_Item_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Item_DataType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToSupplier_Item_Data(\StructType\Priority_Ranked_Supplier_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Priority_Ranked_Supplier_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Data[] = $item;
        return $this;
    }
    /**
     * Get Item_Inventory_Attributes_Data value
     * @return \StructType\Item_Inventory_Attributes_DataType[]|null
     */
    public function getItem_Inventory_Attributes_Data()
    {
        return $this->Item_Inventory_Attributes_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Inventory_Attributes_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Inventory_Attributes_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Inventory_Attributes_DataForArrayConstraintsFromSetItem_Inventory_Attributes_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeItem_Inventory_Attributes_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeItem_Inventory_Attributes_DataItem instanceof \StructType\Item_Inventory_Attributes_DataType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeItem_Inventory_Attributes_DataItem) ? get_class($purchase_Item_DataTypeItem_Inventory_Attributes_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeItem_Inventory_Attributes_DataItem), var_export($purchase_Item_DataTypeItem_Inventory_Attributes_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Inventory_Attributes_Data property can only contain items of type \StructType\Item_Inventory_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Inventory_Attributes_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Inventory_Attributes_DataType[] $item_Inventory_Attributes_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Inventory_Attributes_Data(array $item_Inventory_Attributes_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Inventory_Attributes_DataArrayErrorMessage = self::validateItem_Inventory_Attributes_DataForArrayConstraintsFromSetItem_Inventory_Attributes_Data($item_Inventory_Attributes_Data))) {
            throw new \InvalidArgumentException($item_Inventory_Attributes_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Inventory_Attributes_Data = $item_Inventory_Attributes_Data;
        return $this;
    }
    /**
     * Add item to Item_Inventory_Attributes_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Inventory_Attributes_DataType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToItem_Inventory_Attributes_Data(\StructType\Item_Inventory_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Inventory_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Inventory_Attributes_Data property can only contain items of type \StructType\Item_Inventory_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Inventory_Attributes_Data[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Substitute_Data value
     * @return \StructType\Purchase_Item_Substitute_DataType|null
     */
    public function getPurchase_Item_Substitute_Data()
    {
        return $this->Purchase_Item_Substitute_Data;
    }
    /**
     * Set Purchase_Item_Substitute_Data value
     * @param \StructType\Purchase_Item_Substitute_DataType $purchase_Item_Substitute_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPurchase_Item_Substitute_Data(\StructType\Purchase_Item_Substitute_DataType $purchase_Item_Substitute_Data = null)
    {
        $this->Purchase_Item_Substitute_Data = $purchase_Item_Substitute_Data;
        return $this;
    }
    /**
     * Get Primary_Image_Data value
     * @return \StructType\Primary_Image_DataType|null
     */
    public function getPrimary_Image_Data()
    {
        return $this->Primary_Image_Data;
    }
    /**
     * Set Primary_Image_Data value
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPrimary_Image_Data(\StructType\Primary_Image_DataType $primary_Image_Data = null)
    {
        $this->Primary_Image_Data = $primary_Image_Data;
        return $this;
    }
    /**
     * Get Additional_Image_Data value
     * @return \StructType\Additional_Image_DataType[]|null
     */
    public function getAdditional_Image_Data()
    {
        return $this->Additional_Image_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Image_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Image_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeAdditional_Image_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeAdditional_Image_DataItem instanceof \StructType\Additional_Image_DataType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeAdditional_Image_DataItem) ? get_class($purchase_Item_DataTypeAdditional_Image_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeAdditional_Image_DataItem), var_export($purchase_Item_DataTypeAdditional_Image_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @return \StructType\Purchase_Item_DataType
     */
    public function setAdditional_Image_Data(array $additional_Image_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Image_DataArrayErrorMessage = self::validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data($additional_Image_Data))) {
            throw new \InvalidArgumentException($additional_Image_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Image_Data = $additional_Image_Data;
        return $this;
    }
    /**
     * Add item to Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToAdditional_Image_Data(\StructType\Additional_Image_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Additional_Image_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Image_Data[] = $item;
        return $this;
    }
    /**
     * Get Maps_To_Sales_Item_Reference value
     * @return \StructType\Sales_ItemObjectType|null
     */
    public function getMaps_To_Sales_Item_Reference()
    {
        return $this->Maps_To_Sales_Item_Reference;
    }
    /**
     * Set Maps_To_Sales_Item_Reference value
     * @param \StructType\Sales_ItemObjectType $maps_To_Sales_Item_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setMaps_To_Sales_Item_Reference(\StructType\Sales_ItemObjectType $maps_To_Sales_Item_Reference = null)
    {
        $this->Maps_To_Sales_Item_Reference = $maps_To_Sales_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Status_Reference value
     * @return \StructType\Spend_Item_StatusObjectType|null
     */
    public function getItem_Status_Reference()
    {
        return $this->Item_Status_Reference;
    }
    /**
     * Set Item_Status_Reference value
     * @param \StructType\Spend_Item_StatusObjectType $item_Status_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setItem_Status_Reference(\StructType\Spend_Item_StatusObjectType $item_Status_Reference = null)
    {
        $this->Item_Status_Reference = $item_Status_Reference;
        return $this;
    }
    /**
     * Get Requesting_Entity_Reference value
     * @return \StructType\Requesting_EntityObjectType[]|null
     */
    public function getRequesting_Entity_Reference()
    {
        return $this->Requesting_Entity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequesting_Entity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequesting_Entity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequesting_Entity_ReferenceForArrayConstraintsFromSetRequesting_Entity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypeRequesting_Entity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypeRequesting_Entity_ReferenceItem instanceof \StructType\Requesting_EntityObjectType) {
                $invalidValues[] = is_object($purchase_Item_DataTypeRequesting_Entity_ReferenceItem) ? get_class($purchase_Item_DataTypeRequesting_Entity_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypeRequesting_Entity_ReferenceItem), var_export($purchase_Item_DataTypeRequesting_Entity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requesting_Entity_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requesting_Entity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entity_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setRequesting_Entity_Reference(array $requesting_Entity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requesting_Entity_ReferenceArrayErrorMessage = self::validateRequesting_Entity_ReferenceForArrayConstraintsFromSetRequesting_Entity_Reference($requesting_Entity_Reference))) {
            throw new \InvalidArgumentException($requesting_Entity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requesting_Entity_Reference = $requesting_Entity_Reference;
        return $this;
    }
    /**
     * Add item to Requesting_Entity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToRequesting_Entity_Reference(\StructType\Requesting_EntityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requesting_EntityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requesting_Entity_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requesting_Entity_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_List_Reference value
     * @return \StructType\Restricted_Purchase_Item_ListObjectType[]|null
     */
    public function getPurchase_Item_List_Reference()
    {
        return $this->Purchase_Item_List_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_List_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_List_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_DataTypePurchase_Item_List_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_DataTypePurchase_Item_List_ReferenceItem instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
                $invalidValues[] = is_object($purchase_Item_DataTypePurchase_Item_List_ReferenceItem) ? get_class($purchase_Item_DataTypePurchase_Item_List_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_DataTypePurchase_Item_List_ReferenceItem), var_export($purchase_Item_DataTypePurchase_Item_List_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     * @return \StructType\Purchase_Item_DataType
     */
    public function setPurchase_Item_List_Reference(array $purchase_Item_List_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_List_ReferenceArrayErrorMessage = self::validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference($purchase_Item_List_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_List_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_List_Reference = $purchase_Item_List_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType $item
     * @return \StructType\Purchase_Item_DataType
     */
    public function addToPurchase_Item_List_Reference(\StructType\Restricted_Purchase_Item_ListObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_List_Reference[] = $item;
        return $this;
    }
}
