<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProductBasicRequest StructType
 * @subpackage Structs
 */
class UpdateProductBasicRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price;
    /**
     * The productDiscount
     * @var \StructType\SellerProductDiscount
     */
    public $productDiscount;
    /**
     * The stockItems
     * @var \StructType\ProductUpdateSkuBasicRequestItemList
     */
    public $stockItems;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * Constructor method for UpdateProductBasicRequest
     * @uses UpdateProductBasicRequest::setAuth()
     * @uses UpdateProductBasicRequest::setProductId()
     * @uses UpdateProductBasicRequest::setProductSellerCode()
     * @uses UpdateProductBasicRequest::setPrice()
     * @uses UpdateProductBasicRequest::setProductDiscount()
     * @uses UpdateProductBasicRequest::setStockItems()
     * @uses UpdateProductBasicRequest::setDescription()
     * @param \StructType\Authentication $auth
     * @param int $productId
     * @param string $productSellerCode
     * @param float $price
     * @param \StructType\SellerProductDiscount $productDiscount
     * @param \StructType\ProductUpdateSkuBasicRequestItemList $stockItems
     * @param string $description
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null, $productSellerCode = null, $price = null, \StructType\SellerProductDiscount $productDiscount = null, \StructType\ProductUpdateSkuBasicRequestItemList $stockItems = null, $description = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId)
            ->setProductSellerCode($productSellerCode)
            ->setPrice($price)
            ->setProductDiscount($productDiscount)
            ->setStockItems($stockItems)
            ->setDescription($description);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productSellerCode, true), gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Get productDiscount value
     * @return \StructType\SellerProductDiscount|null
     */
    public function getProductDiscount()
    {
        return $this->productDiscount;
    }
    /**
     * Set productDiscount value
     * @param \StructType\SellerProductDiscount $productDiscount
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductDiscount(\StructType\SellerProductDiscount $productDiscount = null)
    {
        $this->productDiscount = $productDiscount;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductUpdateSkuBasicRequestItemList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductUpdateSkuBasicRequestItemList $stockItems
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setStockItems(\StructType\ProductUpdateSkuBasicRequestItemList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
