<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForUpdateStockWithSellerStockCodeList StructType
 * @subpackage Structs
 */
class StockItemForUpdateStockWithSellerStockCodeList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForUpdateStockWithSellerStockCode[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForUpdateStockWithSellerStockCodeList
     * @uses StockItemForUpdateStockWithSellerStockCodeList::setStockItem()
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForUpdateStockWithSellerStockCode[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemForArrayConstraintsFromSetStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockItemForUpdateStockWithSellerStockCodeListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForUpdateStockWithSellerStockCodeListStockItemItem instanceof \StructType\StockItemForUpdateStockWithSellerStockCode) {
                $invalidValues[] = is_object($stockItemForUpdateStockWithSellerStockCodeListStockItemItem) ? get_class($stockItemForUpdateStockWithSellerStockCodeListStockItemItem) : sprintf('%s(%s)', gettype($stockItemForUpdateStockWithSellerStockCodeListStockItemItem), var_export($stockItemForUpdateStockWithSellerStockCodeListStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItem property can only contain items of type \StructType\StockItemForUpdateStockWithSellerStockCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode[] $stockItem
     * @return \StructType\StockItemForUpdateStockWithSellerStockCodeList
     */
    public function setStockItem(array $stockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemArrayErrorMessage = self::validateStockItemForArrayConstraintsFromSetStockItem($stockItem))) {
            throw new \InvalidArgumentException($stockItemArrayErrorMessage, __LINE__);
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode $item
     * @return \StructType\StockItemForUpdateStockWithSellerStockCodeList
     */
    public function addToStockItem(\StructType\StockItemForUpdateStockWithSellerStockCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForUpdateStockWithSellerStockCode) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of type \StructType\StockItemForUpdateStockWithSellerStockCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
}
