<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockAttributeList StructType
 * @subpackage Structs
 */
class StockAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for StockAttributeList
     * @uses StockAttributeList::setAttribute()
     * @param \StructType\StockAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\StockAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$stockAttributeListAttributeItem instanceof \StructType\StockAttribute) {
                $invalidValues[] = is_object($stockAttributeListAttributeItem) ? get_class($stockAttributeListAttributeItem) : sprintf('%s(%s)', gettype($stockAttributeListAttributeItem), var_export($stockAttributeListAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\StockAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\StockAttribute[] $attribute
     * @return \StructType\StockAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\StockAttribute $item
     * @return \StructType\StockAttributeList
     */
    public function addToAttribute(\StructType\StockAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\StockAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
}
