<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchProductsResponse StructType
 * @subpackage Structs
 */
class SearchProductsResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The products
     * @var \StructType\ProductBasicList
     */
    public $products;
    /**
     * The pagingData
     * @var \StructType\PagingData
     */
    public $pagingData;
    /**
     * Constructor method for SearchProductsResponse
     * @uses SearchProductsResponse::setResult()
     * @uses SearchProductsResponse::setProducts()
     * @uses SearchProductsResponse::setPagingData()
     * @param \StructType\ResultInfo $result
     * @param \StructType\ProductBasicList $products
     * @param \StructType\PagingData $pagingData
     */
    public function __construct(\StructType\ResultInfo $result = null, \StructType\ProductBasicList $products = null, \StructType\PagingData $pagingData = null)
    {
        $this
            ->setResult($result)
            ->setProducts($products)
            ->setPagingData($pagingData);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\SearchProductsResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\ProductBasicList|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @param \StructType\ProductBasicList $products
     * @return \StructType\SearchProductsResponse
     */
    public function setProducts(\StructType\ProductBasicList $products = null)
    {
        $this->products = $products;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\PagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\PagingData $pagingData
     * @return \StructType\SearchProductsResponse
     */
    public function setPagingData(\StructType\PagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
}
