<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductUnitInfoModel StructType
 * @subpackage Structs
 */
class ProductUnitInfoModel extends AbstractStructBase
{
    /**
     * The unitType
     * @var int
     */
    public $unitType;
    /**
     * The unitWeight
     * @var int
     */
    public $unitWeight;
    /**
     * Constructor method for ProductUnitInfoModel
     * @uses ProductUnitInfoModel::setUnitType()
     * @uses ProductUnitInfoModel::setUnitWeight()
     * @param int $unitType
     * @param int $unitWeight
     */
    public function __construct($unitType = null, $unitWeight = null)
    {
        $this
            ->setUnitType($unitType)
            ->setUnitWeight($unitWeight);
    }
    /**
     * Get unitType value
     * @return int|null
     */
    public function getUnitType()
    {
        return $this->unitType;
    }
    /**
     * Set unitType value
     * @param int $unitType
     * @return \StructType\ProductUnitInfoModel
     */
    public function setUnitType($unitType = null)
    {
        // validation for constraint: int
        if (!is_null($unitType) && !(is_int($unitType) || ctype_digit($unitType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitType, true), gettype($unitType)), __LINE__);
        }
        $this->unitType = $unitType;
        return $this;
    }
    /**
     * Get unitWeight value
     * @return int|null
     */
    public function getUnitWeight()
    {
        return $this->unitWeight;
    }
    /**
     * Set unitWeight value
     * @param int $unitWeight
     * @return \StructType\ProductUnitInfoModel
     */
    public function setUnitWeight($unitWeight = null)
    {
        // validation for constraint: int
        if (!is_null($unitWeight) && !(is_int($unitWeight) || ctype_digit($unitWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitWeight, true), gettype($unitWeight)), __LINE__);
        }
        $this->unitWeight = $unitWeight;
        return $this;
    }
}
