<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasicRequestItemList StructType
 * @subpackage Structs
 */
class ProductSkuBasicRequestItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSkuBasicRequest[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductSkuBasicRequestItemList
     * @uses ProductSkuBasicRequestItemList::setStockItem()
     * @param \StructType\ProductSkuBasicRequest[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSkuBasicRequest[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemForArrayConstraintsFromSetStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSkuBasicRequestItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuBasicRequestItemListStockItemItem instanceof \StructType\ProductSkuBasicRequest) {
                $invalidValues[] = is_object($productSkuBasicRequestItemListStockItemItem) ? get_class($productSkuBasicRequestItemListStockItemItem) : sprintf('%s(%s)', gettype($productSkuBasicRequestItemListStockItemItem), var_export($productSkuBasicRequestItemListStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItem property can only contain items of type \StructType\ProductSkuBasicRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasicRequest[] $stockItem
     * @return \StructType\ProductSkuBasicRequestItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemArrayErrorMessage = self::validateStockItemForArrayConstraintsFromSetStockItem($stockItem))) {
            throw new \InvalidArgumentException($stockItemArrayErrorMessage, __LINE__);
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasicRequest $item
     * @return \StructType\ProductSkuBasicRequestItemList
     */
    public function addToStockItem(\StructType\ProductSkuBasicRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSkuBasicRequest) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of type \StructType\ProductSkuBasicRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
}
