<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagingData StructType
 * @subpackage Structs
 */
class PagingData extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $currentPage;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageSize;
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalCount;
    /**
     * The pageCount
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageCount;
    /**
     * Constructor method for PagingData
     * @uses PagingData::setCurrentPage()
     * @uses PagingData::setPageSize()
     * @uses PagingData::setTotalCount()
     * @uses PagingData::setPageCount()
     * @param int $currentPage
     * @param int $pageSize
     * @param int $totalCount
     * @param int $pageCount
     */
    public function __construct($currentPage = null, $pageSize = null, $totalCount = null, $pageCount = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setPageSize($pageSize)
            ->setTotalCount($totalCount)
            ->setPageCount($pageCount);
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\PagingData
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\PagingData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\PagingData
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get pageCount value
     * @return int|null
     */
    public function getPageCount()
    {
        return $this->pageCount;
    }
    /**
     * Set pageCount value
     * @param int $pageCount
     * @return \StructType\PagingData
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->pageCount = $pageCount;
        return $this;
    }
}
