<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveProductAnswer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveProductAnswerRequest $saveProductAnswerRequest
     * @return \StructType\SaveProductAnswerResponse|bool
     */
    public function SaveProductAnswer(\StructType\SaveProductAnswerRequest $saveProductAnswerRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveProductAnswer($saveProductAnswerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveProductRequest $saveProductRequest
     * @return \StructType\SaveProductResponse|bool
     */
    public function SaveProduct(\StructType\SaveProductRequest $saveProductRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveProduct($saveProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveProductAnswerResponse|\StructType\SaveProductResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
