<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Product ServiceType
 * @subpackage Services
 */
class Product extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProductApprovalStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductApprovalStatusRequest $productApprovalStatusRequest
     * @return \StructType\ProductApprovalStatusResponse|bool
     */
    public function ProductApprovalStatus(\StructType\ProductApprovalStatusRequest $productApprovalStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductApprovalStatus($productApprovalStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductApprovalStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
