<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adapt ServiceType
 * @subpackage Services
 */
class Adapt extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AdaptUnificationProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdaptUnificationProductsRequest $adaptUnificationProductsRequest
     * @return \StructType\AdaptUnificationProductsResponse|bool
     */
    public function AdaptUnificationProducts(\StructType\AdaptUnificationProductsRequest $adaptUnificationProductsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AdaptUnificationProducts($adaptUnificationProductsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AdaptUnificationProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
