<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProductStatus EnumType
 * @subpackage Enumerations
 */
class ProductStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Constant for value 'Prohibited'
     * @return string 'Prohibited'
     */
    const VALUE_PROHIBITED = 'Prohibited';
    /**
     * Constant for value 'WaitingForApproval'
     * @return string 'WaitingForApproval'
     */
    const VALUE_WAITING_FOR_APPROVAL = 'WaitingForApproval';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'UnapprovedUpdate'
     * @return string 'UnapprovedUpdate'
     */
    const VALUE_UNAPPROVED_UPDATE = 'UnapprovedUpdate';
    /**
     * Constant for value 'Unlisted'
     * @return string 'Unlisted'
     */
    const VALUE_UNLISTED = 'Unlisted';
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_PROHIBITED
     * @uses self::VALUE_WAITING_FOR_APPROVAL
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_UNAPPROVED_UPDATE
     * @uses self::VALUE_UNLISTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_SUSPENDED,
            self::VALUE_PROHIBITED,
            self::VALUE_WAITING_FOR_APPROVAL,
            self::VALUE_REJECTED,
            self::VALUE_UNAPPROVED_UPDATE,
            self::VALUE_UNLISTED,
        );
    }
}
