<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockDataWithProductSellerCode StructType
 * @subpackage Structs
 */
class StockDataWithProductSellerCode extends AbstractStructBase
{
    /**
     * The stockItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemList[]
     */
    public $stockItems;
    /**
     * The product
     * @var \StructType\ProductWithSellerCode
     */
    public $product;
    /**
     * Constructor method for StockDataWithProductSellerCode
     * @uses StockDataWithProductSellerCode::setStockItems()
     * @uses StockDataWithProductSellerCode::setProduct()
     * @param \StructType\StockItemList[] $stockItems
     * @param \StructType\ProductWithSellerCode $product
     */
    public function __construct(array $stockItems = array(), \StructType\ProductWithSellerCode $product = null)
    {
        $this
            ->setStockItems($stockItems)
            ->setProduct($product);
    }
    /**
     * Get stockItems value
     * @return \StructType\StockItemList[]|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemsForArrayConstraintsFromSetStockItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockDataWithProductSellerCodeStockItemsItem) {
            // validation for constraint: itemType
            if (!$stockDataWithProductSellerCodeStockItemsItem instanceof \StructType\StockItemList) {
                $invalidValues[] = is_object($stockDataWithProductSellerCodeStockItemsItem) ? get_class($stockDataWithProductSellerCodeStockItemsItem) : sprintf('%s(%s)', gettype($stockDataWithProductSellerCodeStockItemsItem), var_export($stockDataWithProductSellerCodeStockItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stockItems property can only contain items of type \StructType\StockItemList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stockItems value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemList[] $stockItems
     * @return \StructType\StockDataWithProductSellerCode
     */
    public function setStockItems(array $stockItems = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemsArrayErrorMessage = self::validateStockItemsForArrayConstraintsFromSetStockItems($stockItems))) {
            throw new \InvalidArgumentException($stockItemsArrayErrorMessage, __LINE__);
        }
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Add item to stockItems value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemList $item
     * @return \StructType\StockDataWithProductSellerCode
     */
    public function addToStockItems(\StructType\StockItemList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemList) {
            throw new \InvalidArgumentException(sprintf('The stockItems property can only contain items of type \StructType\StockItemList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stockItems[] = $item;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\ProductWithSellerCode|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductWithSellerCode $product
     * @return \StructType\StockDataWithProductSellerCode
     */
    public function setProduct(\StructType\ProductWithSellerCode $product = null)
    {
        $this->product = $product;
        return $this;
    }
}
