<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialProductInfoList StructType
 * @subpackage Structs
 */
class SpecialProductInfoList extends AbstractStructBase
{
    /**
     * The specialProductInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SpecialProductInfoApiModel[]
     */
    public $specialProductInfo;
    /**
     * Constructor method for SpecialProductInfoList
     * @uses SpecialProductInfoList::setSpecialProductInfo()
     * @param \StructType\SpecialProductInfoApiModel[] $specialProductInfo
     */
    public function __construct(array $specialProductInfo = array())
    {
        $this
            ->setSpecialProductInfo($specialProductInfo);
    }
    /**
     * Get specialProductInfo value
     * @return \StructType\SpecialProductInfoApiModel[]|null
     */
    public function getSpecialProductInfo()
    {
        return $this->specialProductInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialProductInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialProductInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialProductInfoForArrayConstraintsFromSetSpecialProductInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialProductInfoListSpecialProductInfoItem) {
            // validation for constraint: itemType
            if (!$specialProductInfoListSpecialProductInfoItem instanceof \StructType\SpecialProductInfoApiModel) {
                $invalidValues[] = is_object($specialProductInfoListSpecialProductInfoItem) ? get_class($specialProductInfoListSpecialProductInfoItem) : sprintf('%s(%s)', gettype($specialProductInfoListSpecialProductInfoItem), var_export($specialProductInfoListSpecialProductInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The specialProductInfo property can only contain items of type \StructType\SpecialProductInfoApiModel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set specialProductInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialProductInfoApiModel[] $specialProductInfo
     * @return \StructType\SpecialProductInfoList
     */
    public function setSpecialProductInfo(array $specialProductInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($specialProductInfoArrayErrorMessage = self::validateSpecialProductInfoForArrayConstraintsFromSetSpecialProductInfo($specialProductInfo))) {
            throw new \InvalidArgumentException($specialProductInfoArrayErrorMessage, __LINE__);
        }
        $this->specialProductInfo = $specialProductInfo;
        return $this;
    }
    /**
     * Add item to specialProductInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialProductInfoApiModel $item
     * @return \StructType\SpecialProductInfoList
     */
    public function addToSpecialProductInfo(\StructType\SpecialProductInfoApiModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialProductInfoApiModel) {
            throw new \InvalidArgumentException(sprintf('The specialProductInfo property can only contain items of type \StructType\SpecialProductInfoApiModel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->specialProductInfo[] = $item;
        return $this;
    }
}
