<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestionSearch StructType
 * @subpackage Structs
 */
class ProductQuestionSearch extends AbstractStructBase
{
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The buyerEmail
     * @var string
     */
    public $buyerEmail;
    /**
     * The subject
     * @var string
     */
    public $subject;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The questionDate
     * @var string
     */
    public $questionDate;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for ProductQuestionSearch
     * @uses ProductQuestionSearch::setProductId()
     * @uses ProductQuestionSearch::setBuyerEmail()
     * @uses ProductQuestionSearch::setSubject()
     * @uses ProductQuestionSearch::setStatus()
     * @uses ProductQuestionSearch::setQuestionDate()
     * @uses ProductQuestionSearch::setStartDate()
     * @uses ProductQuestionSearch::setEndDate()
     * @param int $productId
     * @param string $buyerEmail
     * @param string $subject
     * @param string $status
     * @param string $questionDate
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($productId = null, $buyerEmail = null, $subject = null, $status = null, $questionDate = null, $startDate = null, $endDate = null)
    {
        $this
            ->setProductId($productId)
            ->setBuyerEmail($buyerEmail)
            ->setSubject($subject)
            ->setStatus($status)
            ->setQuestionDate($questionDate)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductQuestionSearch
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get buyerEmail value
     * @return string|null
     */
    public function getBuyerEmail()
    {
        return $this->buyerEmail;
    }
    /**
     * Set buyerEmail value
     * @param string $buyerEmail
     * @return \StructType\ProductQuestionSearch
     */
    public function setBuyerEmail($buyerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($buyerEmail) && !is_string($buyerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerEmail, true), gettype($buyerEmail)), __LINE__);
        }
        $this->buyerEmail = $buyerEmail;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\ProductQuestionSearch
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ProductQuestionStatus::valueIsValid()
     * @uses \EnumType\ProductQuestionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ProductQuestionSearch
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductQuestionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductQuestionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ProductQuestionStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get questionDate value
     * @return string|null
     */
    public function getQuestionDate()
    {
        return $this->questionDate;
    }
    /**
     * Set questionDate value
     * @param string $questionDate
     * @return \StructType\ProductQuestionSearch
     */
    public function setQuestionDate($questionDate = null)
    {
        // validation for constraint: string
        if (!is_null($questionDate) && !is_string($questionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionDate, true), gettype($questionDate)), __LINE__);
        }
        $this->questionDate = $questionDate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProductQuestionSearch
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProductQuestionSearch
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
}
