<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestion StructType
 * @subpackage Structs
 */
class ProductQuestion extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The productTitle
     * @var string
     */
    public $productTitle;
    /**
     * The questionSubject
     * @var string
     */
    public $questionSubject;
    /**
     * The question
     * @var string
     */
    public $question;
    /**
     * The answer
     * @var string
     */
    public $answer;
    /**
     * The images
     * @var \StructType\ImageList
     */
    public $images;
    /**
     * Constructor method for ProductQuestion
     * @uses ProductQuestion::setId()
     * @uses ProductQuestion::setProductId()
     * @uses ProductQuestion::setProductTitle()
     * @uses ProductQuestion::setQuestionSubject()
     * @uses ProductQuestion::setQuestion()
     * @uses ProductQuestion::setAnswer()
     * @uses ProductQuestion::setImages()
     * @param int $id
     * @param int $productId
     * @param string $productTitle
     * @param string $questionSubject
     * @param string $question
     * @param string $answer
     * @param \StructType\ImageList $images
     */
    public function __construct($id = null, $productId = null, $productTitle = null, $questionSubject = null, $question = null, $answer = null, \StructType\ImageList $images = null)
    {
        $this
            ->setId($id)
            ->setProductId($productId)
            ->setProductTitle($productTitle)
            ->setQuestionSubject($questionSubject)
            ->setQuestion($question)
            ->setAnswer($answer)
            ->setImages($images);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductQuestion
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductQuestion
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\ProductQuestion
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTitle, true), gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get questionSubject value
     * @return string|null
     */
    public function getQuestionSubject()
    {
        return $this->questionSubject;
    }
    /**
     * Set questionSubject value
     * @param string $questionSubject
     * @return \StructType\ProductQuestion
     */
    public function setQuestionSubject($questionSubject = null)
    {
        // validation for constraint: string
        if (!is_null($questionSubject) && !is_string($questionSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionSubject, true), gettype($questionSubject)), __LINE__);
        }
        $this->questionSubject = $questionSubject;
        return $this;
    }
    /**
     * Get question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->question;
    }
    /**
     * Set question value
     * @param string $question
     * @return \StructType\ProductQuestion
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question, true), gettype($question)), __LINE__);
        }
        $this->question = $question;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \StructType\ProductQuestion
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ImageList $images
     * @return \StructType\ProductQuestion
     */
    public function setImages(\StructType\ImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
}
