<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductBasicList StructType
 * @subpackage Structs
 */
class ProductBasicList extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductBasic[]
     */
    public $product;
    /**
     * Constructor method for ProductBasicList
     * @uses ProductBasicList::setProduct()
     * @param \StructType\ProductBasic[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get product value
     * @return \StructType\ProductBasic[]|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productBasicListProductItem) {
            // validation for constraint: itemType
            if (!$productBasicListProductItem instanceof \StructType\ProductBasic) {
                $invalidValues[] = is_object($productBasicListProductItem) ? get_class($productBasicListProductItem) : sprintf('%s(%s)', gettype($productBasicListProductItem), var_export($productBasicListProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The product property can only contain items of type \StructType\ProductBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set product value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductBasic[] $product
     * @return \StructType\ProductBasicList
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductBasic $item
     * @return \StructType\ProductBasicList
     */
    public function addToProduct(\StructType\ProductBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductBasic) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of type \StructType\ProductBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
}
