<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAttributeList StructType
 * @subpackage Structs
 */
class ProductAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for ProductAttributeList
     * @uses ProductAttributeList::setAttribute()
     * @param \StructType\ProductAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\ProductAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$productAttributeListAttributeItem instanceof \StructType\ProductAttribute) {
                $invalidValues[] = is_object($productAttributeListAttributeItem) ? get_class($productAttributeListAttributeItem) : sprintf('%s(%s)', gettype($productAttributeListAttributeItem), var_export($productAttributeListAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\ProductAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute[] $attribute
     * @return \StructType\ProductAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute $item
     * @return \StructType\ProductAttributeList
     */
    public function addToAttribute(\StructType\ProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\ProductAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
}
