<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDiscountValueByProductIdRequest StructType
 * @subpackage Structs
 */
class UpdateDiscountValueByProductIdRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The productDiscount
     * @var \StructType\SellerProductDiscount
     */
    public $productDiscount;
    /**
     * Constructor method for UpdateDiscountValueByProductIdRequest
     * @uses UpdateDiscountValueByProductIdRequest::setAuth()
     * @uses UpdateDiscountValueByProductIdRequest::setProductId()
     * @uses UpdateDiscountValueByProductIdRequest::setProductDiscount()
     * @param \StructType\Authentication $auth
     * @param int $productId
     * @param \StructType\SellerProductDiscount $productDiscount
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null, \StructType\SellerProductDiscount $productDiscount = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId)
            ->setProductDiscount($productDiscount);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateDiscountValueByProductIdRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\UpdateDiscountValueByProductIdRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productDiscount value
     * @return \StructType\SellerProductDiscount|null
     */
    public function getProductDiscount()
    {
        return $this->productDiscount;
    }
    /**
     * Set productDiscount value
     * @param \StructType\SellerProductDiscount $productDiscount
     * @return \StructType\UpdateDiscountValueByProductIdRequest
     */
    public function setProductDiscount(\StructType\SellerProductDiscount $productDiscount = null)
    {
        $this->productDiscount = $productDiscount;
        return $this;
    }
}
