<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithAttributes StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithAttributes extends AbstractStructBase
{
    /**
     * The attributes
     * @var \StructType\StockAttributeList
     */
    public $attributes;
    /**
     * The quantityToIncrease
     * @var int
     */
    public $quantityToIncrease;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForAddStockWithAttributes
     * @uses StockItemForAddStockWithAttributes::setAttributes()
     * @uses StockItemForAddStockWithAttributes::setQuantityToIncrease()
     * @uses StockItemForAddStockWithAttributes::setVersion()
     * @param \StructType\StockAttributeList $attributes
     * @param int $quantityToIncrease
     * @param int $version
     */
    public function __construct(\StructType\StockAttributeList $attributes = null, $quantityToIncrease = null, $version = null)
    {
        $this
            ->setAttributes($attributes)
            ->setQuantityToIncrease($quantityToIncrease)
            ->setVersion($version);
    }
    /**
     * Get attributes value
     * @return \StructType\StockAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\StockAttributeList $attributes
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setAttributes(\StructType\StockAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get quantityToIncrease value
     * @return int|null
     */
    public function getQuantityToIncrease()
    {
        return $this->quantityToIncrease;
    }
    /**
     * Set quantityToIncrease value
     * @param int $quantityToIncrease
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setQuantityToIncrease($quantityToIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($quantityToIncrease) && !(is_int($quantityToIncrease) || ctype_digit($quantityToIncrease))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityToIncrease, true), gettype($quantityToIncrease)), __LINE__);
        }
        $this->quantityToIncrease = $quantityToIncrease;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
