<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellerProductDiscount StructType
 * @subpackage Structs
 */
class SellerProductDiscount extends AbstractStructBase
{
    /**
     * The discountType
     * @var int
     */
    public $discountType;
    /**
     * The discountValue
     * @var float
     */
    public $discountValue;
    /**
     * The discountStartDate
     * @var string
     */
    public $discountStartDate;
    /**
     * The discountEndDate
     * @var string
     */
    public $discountEndDate;
    /**
     * Constructor method for SellerProductDiscount
     * @uses SellerProductDiscount::setDiscountType()
     * @uses SellerProductDiscount::setDiscountValue()
     * @uses SellerProductDiscount::setDiscountStartDate()
     * @uses SellerProductDiscount::setDiscountEndDate()
     * @param int $discountType
     * @param float $discountValue
     * @param string $discountStartDate
     * @param string $discountEndDate
     */
    public function __construct($discountType = null, $discountValue = null, $discountStartDate = null, $discountEndDate = null)
    {
        $this
            ->setDiscountType($discountType)
            ->setDiscountValue($discountValue)
            ->setDiscountStartDate($discountStartDate)
            ->setDiscountEndDate($discountEndDate);
    }
    /**
     * Get discountType value
     * @return int|null
     */
    public function getDiscountType()
    {
        return $this->discountType;
    }
    /**
     * Set discountType value
     * @param int $discountType
     * @return \StructType\SellerProductDiscount
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: int
        if (!is_null($discountType) && !(is_int($discountType) || ctype_digit($discountType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountType, true), gettype($discountType)), __LINE__);
        }
        $this->discountType = $discountType;
        return $this;
    }
    /**
     * Get discountValue value
     * @return float|null
     */
    public function getDiscountValue()
    {
        return $this->discountValue;
    }
    /**
     * Set discountValue value
     * @param float $discountValue
     * @return \StructType\SellerProductDiscount
     */
    public function setDiscountValue($discountValue = null)
    {
        // validation for constraint: float
        if (!is_null($discountValue) && !(is_float($discountValue) || is_numeric($discountValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountValue, true), gettype($discountValue)), __LINE__);
        }
        $this->discountValue = $discountValue;
        return $this;
    }
    /**
     * Get discountStartDate value
     * @return string|null
     */
    public function getDiscountStartDate()
    {
        return $this->discountStartDate;
    }
    /**
     * Set discountStartDate value
     * @param string $discountStartDate
     * @return \StructType\SellerProductDiscount
     */
    public function setDiscountStartDate($discountStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountStartDate) && !is_string($discountStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountStartDate, true), gettype($discountStartDate)), __LINE__);
        }
        $this->discountStartDate = $discountStartDate;
        return $this;
    }
    /**
     * Get discountEndDate value
     * @return string|null
     */
    public function getDiscountEndDate()
    {
        return $this->discountEndDate;
    }
    /**
     * Set discountEndDate value
     * @param string $discountEndDate
     * @return \StructType\SellerProductDiscount
     */
    public function setDiscountEndDate($discountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountEndDate) && !is_string($discountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountEndDate, true), gettype($discountEndDate)), __LINE__);
        }
        $this->discountEndDate = $discountEndDate;
        return $this;
    }
}
