<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithIdAndStockSellerCode StructType
 * @subpackage Structs
 */
class ProductWithIdAndStockSellerCode extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockList
     * @var \StructType\StockItemForAddStockWithSellerStockCodeList
     */
    public $stockList;
    /**
     * Constructor method for ProductWithIdAndStockSellerCode
     * @uses ProductWithIdAndStockSellerCode::setId()
     * @uses ProductWithIdAndStockSellerCode::setStockList()
     * @param int $id
     * @param \StructType\StockItemForAddStockWithSellerStockCodeList $stockList
     */
    public function __construct($id = null, \StructType\StockItemForAddStockWithSellerStockCodeList $stockList = null)
    {
        $this
            ->setId($id)
            ->setStockList($stockList);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductWithIdAndStockSellerCode
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockList value
     * @return \StructType\StockItemForAddStockWithSellerStockCodeList|null
     */
    public function getStockList()
    {
        return $this->stockList;
    }
    /**
     * Set stockList value
     * @param \StructType\StockItemForAddStockWithSellerStockCodeList $stockList
     * @return \StructType\ProductWithIdAndStockSellerCode
     */
    public function setStockList(\StructType\StockItemForAddStockWithSellerStockCodeList $stockList = null)
    {
        $this->stockList = $stockList;
        return $this;
    }
}
