<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasicRequest StructType
 * @subpackage Structs
 */
class ProductSkuBasicRequest extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The optionPrice
     * @var float
     */
    public $optionPrice;
    /**
     * Constructor method for ProductSkuBasicRequest
     * @uses ProductSkuBasicRequest::setSellerStockCode()
     * @uses ProductSkuBasicRequest::setOptionPrice()
     * @param string $sellerStockCode
     * @param float $optionPrice
     */
    public function __construct($sellerStockCode = null, $optionPrice = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setOptionPrice($optionPrice);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductSkuBasicRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStockCode, true), gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float|null
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\ProductSkuBasicRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($optionPrice) && !(is_float($optionPrice) || is_numeric($optionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionPrice, true), gettype($optionPrice)), __LINE__);
        }
        $this->optionPrice = $optionPrice;
        return $this;
    }
}
